/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.push;

import android.content.Context;
import android.support.annotation.RestrictTo;
import android.text.TextUtils;
import com.moe.pushlibrary.MoEHelper;
import com.moe.pushlibrary.PayloadBuilder;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.Logger;
import com.moengage.core.MoEDispatcher;
import com.moengage.push.PushManager;
import org.json.JSONObject;

public class TokenHandler {
    public static final String TOKEN_BY_MOE = "MoE";
    public static final String REQ_REGISTRATION = "MOE_REG_REQ";
    private final String ATTR_REGISTRATION_BY = "registered_by";
    private final Object lock = new Object();
    private PushManager.OnTokenReceivedListener tokenListener;
    private static final String TAG = "TokenHandler";
    private static TokenHandler instance = null;
    private static final String ID_PREFIX = "|ID|";

    private TokenHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TokenHandler getInstance() {
        if (instance != null) return instance;
        Class<TokenHandler> clazz = TokenHandler.class;
        synchronized (TokenHandler.class) {
            if (instance != null) return instance;
            instance = new TokenHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void processToken(Context context, String token, String pushRegisteredBy) {
        if (TextUtils.isEmpty((CharSequence)token)) {
            return;
        }
        Logger.v("TokenHandler processToken() : Will try to process push token. Token: " + token + "\nregistered by: " + pushRegisteredBy);
        try {
            Object object = this.lock;
            synchronized (object) {
                token = this.ripMultiplexingExtras(token);
                if (this.tokenListener != null) {
                    this.tokenListener.onTokenReceived(token);
                }
                String oldRegId = ConfigurationProvider.getInstance(context).getFcmToken();
                boolean update = this.tokenRefreshRequired(context, token);
                if (update) {
                    PayloadBuilder payloadBuilder = new PayloadBuilder();
                    payloadBuilder.putAttrString("registered_by", pushRegisteredBy);
                    payloadBuilder.setNonInteractive();
                    MoEHelper.getInstance(context).trackEvent("TOKEN_EVENT", payloadBuilder);
                    this.trackDeviceAttributeForRegistration(context, pushRegisteredBy);
                }
                if (update) {
                    ConfigurationProvider.getInstance(context).setFcmToken(token);
                    MoEDispatcher.getInstance(context).getDeviceAddManager().registerFcmToken(context);
                }
                Logger.v("TokenHandler processToken() oldId: = " + oldRegId + " token = " + token + " --updating[true/false]: " + update);
            }
        }
        catch (Exception e) {
            Logger.f("TokenHandler processToken() : Exception ", e);
        }
    }

    private String ripMultiplexingExtras(String token) {
        return !TextUtils.isEmpty((CharSequence)token) && token.startsWith(ID_PREFIX) ? token.substring(7) : token;
    }

    private boolean tokenRefreshRequired(Context context, String newToken) {
        if (!TextUtils.isEmpty((CharSequence)newToken)) {
            String oldToken = ConfigurationProvider.getInstance(context).getFcmToken();
            return TextUtils.isEmpty((CharSequence)oldToken) || !newToken.equals(oldToken);
        }
        return false;
    }

    private void trackDeviceAttributeForRegistration(Context context, String pushRegisteredBy) {
        try {
            JSONObject attribute = new JSONObject();
            attribute.put("moe_p_reg", (Object)pushRegisteredBy);
            MoEDispatcher.getInstance(context).setDeviceAttribute(attribute);
        }
        catch (Exception e) {
            Logger.f("PushManager: trackDeviceAttributeForRegistration() : ", e);
        }
    }

    void setTokenListener(PushManager.OnTokenReceivedListener listener) {
        this.tokenListener = listener;
    }
}

