/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core.rest;

import android.support.annotation.Nullable;
import com.moengage.core.Logger;
import com.moengage.core.rest.Request;
import com.moengage.core.rest.RequestBuilder;
import com.moengage.core.rest.Response;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONObject;

public class RestClient {
    private String TAG = "";
    private Request request;
    private static final String ENCODING_CHARSET_UTF8 = "UTF-8";
    private static final String CHARACTER_SET = "Accept-Charset";
    private static final String CONTENT_TYPE = "Content-type";

    public RestClient(Request request) {
        this.request = request;
        this.TAG = "RestClient " + request.uri.getEncodedPath() + " " + (Object)((Object)request.requestType);
    }

    @Nullable
    public Response executeRequest() {
        return this.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response execute() {
        HttpURLConnection urlConnection = null;
        Response response = null;
        try {
            String urlString = this.request.uri.toString();
            URL url = new URL(urlString);
            Logger.v(this.TAG + " execute(): Request url: " + urlString);
            urlConnection = "https".equals(this.request.uri.getScheme()) ? (HttpsURLConnection)url.openConnection() : (HttpURLConnection)url.openConnection();
            this.addHeaders(urlConnection, this.request.headersMap);
            this.setContentType(urlConnection, this.request.contentType);
            this.setRequestType(urlConnection, this.request.requestType);
            this.addConnectionTimeOut(urlConnection, this.request.timeOut);
            if (this.request.requestBody != null && this.request.requestBody.length() > 0) {
                this.addBody(urlConnection, this.request.requestBody);
            }
            int responseCode = urlConnection.getResponseCode();
            Logger.v(this.TAG + " execute(): Response Code: " + responseCode);
            if (responseCode == 200) {
                String responseBody = this.convertStreamToString(urlConnection.getInputStream());
                Logger.v(this.TAG + " execute() : Response Body: " + responseBody);
                response = new Response(responseCode, responseBody);
            } else {
                String errorResponse = this.convertStreamToString(urlConnection.getErrorStream());
                Logger.f(this.TAG + " Response: API Failed:  response code :" + responseCode + "reason : " + errorResponse);
                Logger.e(this.TAG + " execute() : Error message: " + errorResponse);
                response = new Response(responseCode, errorResponse);
            }
        }
        catch (Exception e) {
            Logger.e(this.TAG + " execute() : Exception: ", e);
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
        return response;
    }

    private void addConnectionTimeOut(HttpURLConnection urlConnection, int timeOut) {
        urlConnection.setConnectTimeout(timeOut * 1000);
        urlConnection.setReadTimeout(timeOut * 1000);
    }

    private void setContentType(HttpURLConnection urlConnection, String contentType) {
        urlConnection.setRequestProperty(CONTENT_TYPE, contentType);
    }

    private void setRequestType(HttpURLConnection urlConnection, RequestBuilder.RequestType requestType) throws ProtocolException {
        urlConnection.setRequestMethod(requestType.toString());
    }

    private void addBody(HttpURLConnection urlConnection, JSONObject requestBody) throws IOException {
        urlConnection.setDoOutput(true);
        urlConnection.setRequestProperty(CHARACTER_SET, ENCODING_CHARSET_UTF8);
        urlConnection.setRequestProperty(CONTENT_TYPE, "application/json");
        OutputStream output = urlConnection.getOutputStream();
        if (requestBody != null) {
            Logger.v(this.TAG + " addBody(): Request Body: " + requestBody.toString());
            output.write(requestBody.toString().getBytes(ENCODING_CHARSET_UTF8));
        }
        output.close();
    }

    private void addHeaders(HttpURLConnection urlConnection, Map<String, String> headers) {
        Set<Map.Entry<String, String>> headerMap = headers.entrySet();
        for (Map.Entry<String, String> header : headerMap) {
            Logger.v(this.TAG + " addHeaders(): " + header.getKey() + " : " + header.getValue());
            urlConnection.addRequestProperty(header.getKey(), header.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String convertStreamToString(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return null;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line);
            }
        }
        finally {
            inputStream.close();
        }
        return stringBuilder.toString();
    }
}

