/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core.integrations.segment;

import android.content.Context;
import com.moe.pushlibrary.MoEHelper;
import com.moe.pushlibrary.PayloadBuilder;
import com.moengage.core.Logger;
import com.moengage.core.MoEUtils;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import java.util.Iterator;
import org.json.JSONObject;

public class TrackSegmentEventTask
extends SDKTask {
    private String eventName;
    private JSONObject eventAttributes;
    private static final String TAG = "TrackSegmentEventTask";

    public TrackSegmentEventTask(Context context, String eventName, JSONObject eventAttributes) {
        super(context);
        this.eventName = eventName;
        this.eventAttributes = eventAttributes;
    }

    @Override
    public TaskResult execute() {
        try {
            Logger.v("TrackSegmentEventTask execute() : Started Execution");
            MoEHelper.getInstance(this.context).trackEvent(this.eventName, this.transformEventAttributesToMoEngageFormat(this.eventAttributes));
            Logger.v("TrackSegmentEventTask execute() : Completed Execution");
        }
        catch (Exception e) {
            Logger.e("TrackSegmentEventTask execute() : Exception: ", e);
        }
        return null;
    }

    @Override
    public String getTaskTag() {
        return "TRACK_EVENT_SEGMENT";
    }

    @Override
    public boolean isSynchronous() {
        return false;
    }

    private JSONObject transformEventAttributesToMoEngageFormat(JSONObject eventAttributes) {
        try {
            Logger.v("TrackSegmentEventTask transformEventAttributesToMoEngageFormat() : Transforming track properties  to MoEngage format");
            PayloadBuilder builder = new PayloadBuilder();
            Iterator iterator = eventAttributes.keys();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                Object value = eventAttributes.get(key);
                if (value instanceof String) {
                    if (!MoEUtils.isDate((String)value)) {
                        builder.putAttrObject(key, value);
                        continue;
                    }
                    builder.putAttrISO8601Date(key, (String)value);
                    continue;
                }
                builder.putAttrObject(key, value);
            }
            return builder.build();
        }
        catch (Exception e) {
            Logger.f("TrackSegmentEventTask transformEventAttributesToMoEngageFormat() : ");
            return eventAttributes;
        }
    }
}

