/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core.executor;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.moengage.core.Logger;
import com.moengage.core.executor.ITask;
import com.moengage.core.executor.OnTaskCompleteListener;
import com.moengage.core.executor.Task;
import com.moengage.core.executor.TaskManager;
import com.moengage.core.executor.TaskResult;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;

public class TaskProcessor {
    private static final String TAG = "TaskProcessor";
    private BlockingDeque<ITask> taskQueue;
    private ExecutorService executorService = Executors.newCachedThreadPool();
    private ArrayList<WeakReference<OnTaskCompleteListener>> taskCompleteListeners;
    private ITask active;
    private final Object lock = new Object();
    private static TaskProcessor instance = null;

    private TaskProcessor() {
        this.taskQueue = new LinkedBlockingDeque<ITask>();
        this.taskCompleteListeners = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TaskProcessor getInstance() {
        if (instance != null) return instance;
        Class<TaskProcessor> clazz = TaskProcessor.class;
        synchronized (TaskProcessor.class) {
            if (instance != null) return instance;
            instance = new TaskProcessor();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void addTask(ITask task) {
        if (task != null) {
            this.taskQueue.add(task);
            this.startExecution();
        }
    }

    public void addTaskToFront(ITask task) {
        if (task != null) {
            this.taskQueue.addFirst(task);
            this.startExecution();
        }
    }

    private void startExecution() {
        if (this.active == null) {
            this.scheduleNext();
        }
    }

    private void scheduleNext() {
        this.active = this.taskQueue.poll();
        if (this.active != null) {
            this.executorService.submit(new Runnable(){

                @Override
                public void run() {
                    TaskProcessor.this.executeTask(TaskProcessor.this.active);
                    TaskProcessor.this.scheduleNext();
                }
            });
        }
    }

    public void runTask(final ITask task) {
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                TaskProcessor.this.executeTask(task);
            }
        });
    }

    private void executeTask(ITask task) {
        TaskResult result = task.execute();
        String action = task.getTaskTag();
        if (!TextUtils.isEmpty((CharSequence)action)) {
            this.notifyListener(action, result);
        }
    }

    public void removeOnTaskCompleteListener(@NonNull WeakReference<OnTaskCompleteListener> listener) {
        int index;
        if (this.taskCompleteListeners != null && listener != null && (index = this.taskCompleteListeners.indexOf(listener)) != -1) {
            this.taskCompleteListeners.remove(index);
        }
    }

    @Nullable
    public WeakReference<OnTaskCompleteListener> setOnTaskCompleteListener(@NonNull OnTaskCompleteListener listener) {
        if (listener == null) {
            return null;
        }
        WeakReference<OnTaskCompleteListener> reference = new WeakReference<OnTaskCompleteListener>(listener);
        this.taskCompleteListeners.add(reference);
        return reference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListener(String tag, TaskResult result) {
        if (this.taskCompleteListeners == null) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            for (WeakReference<OnTaskCompleteListener> taskCompleteListener : this.taskCompleteListeners) {
                if (taskCompleteListener.get() == null) continue;
                ((OnTaskCompleteListener)taskCompleteListener.get()).onTaskComplete(tag, result);
            }
            TaskManager.getInstance().removeTaskFromList(tag);
        }
    }

    @Deprecated
    public void execute(final @NonNull Task task) {
        if (task == null) {
            return;
        }
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    task.execute();
                }
                catch (Exception e) {
                    Logger.e("TaskProcessor run() : ", e);
                }
            }
        });
    }
}

