/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core;

import android.content.Context;
import com.moengage.core.DeviceAddTask;
import com.moengage.core.Logger;
import com.moengage.core.MoEDAO;
import com.moengage.core.executor.TaskManager;
import com.moengage.core.executor.TaskResult;
import com.moengage.core.model.RemoteConfig;
import com.moengage.core.model.TokenState;

public class DeviceAddManager {
    private static final String TAG = "DeviceAddManager";
    private boolean isDeviceAddInProgress;
    private boolean isFcmRegistrationPending;
    private boolean isSecondaryTokenRegistrationPending;
    private boolean isGdprRequestPending;

    public void registerGdprOptOut(Context context) {
        if (this.isDeviceAddInProgress) {
            Logger.v("DeviceAddManager registerGdprOptOut() : Device Add is in progress, will send gdpr opt-out after current request completes.");
            this.isGdprRequestPending = true;
        } else {
            Logger.v("DeviceAddManager registerGdprOptOut() : Initiating request to send GDPR opt out.");
            this.initiateDeviceAdd(context);
        }
    }

    public void registerFcmToken(Context context) {
        if (this.isDeviceAddInProgress) {
            Logger.v("DeviceAddManager registerFcmToken() : Device add in progress will send FCM token to server after current request completes.");
            this.isFcmRegistrationPending = true;
        } else {
            Logger.v("DeviceAddManager registerFcmToken() : Initiating request for sending FCM token to server.");
            this.initiateDeviceAdd(context);
        }
    }

    public void registerPushToken(Context context) {
        if (this.isDeviceAddInProgress) {
            Logger.v("DeviceAddManager registerPushToken() :: Device add is in progress will send token to server after current request is completed");
            this.isSecondaryTokenRegistrationPending = true;
            return;
        }
        Logger.v("DeviceAddManager registerPushToken() :: Initiating request for sending  token to server.");
        this.initiateDeviceAdd(context);
    }

    void retryDeviceRegistrationIfRequired(Context context) {
        if (!MoEDAO.getInstance(context).isDeviceRegistered()) {
            Logger.v("DeviceAddManager retryDeviceRegistrationIfRequired() : Device not registered yet. Will try to register device.");
            this.initiateDeviceAdd(context);
        }
    }

    void registerDevice(Context context) {
        if (this.isDeviceAddInProgress) {
            Logger.v("DeviceAddManager registerDevice() : Device add is already in progress, will not make another call.");
            return;
        }
        this.initiateDeviceAdd(context);
    }

    private void initiateDeviceAdd(Context context) {
        if (!RemoteConfig.getConfig().isAppEnabled) {
            Logger.e("DeviceAddManager initiateDeviceAdd() : App is disabled. Will not make device add call.");
            return;
        }
        if (!this.isDeviceAddInProgress) {
            this.isDeviceAddInProgress = true;
            MoEDAO.getInstance(context).setDeviceRegistrationState(false);
            TaskManager.getInstance().startTask(new DeviceAddTask(context, MoEDAO.getInstance(context).getDevicePreferences()));
        } else {
            Logger.v("DeviceAddManager initiateDeviceAdd() : Device Add is already in progress cannot schedule another one");
        }
    }

    void processTaskResult(Context context, TaskResult taskResult) {
        try {
            this.isDeviceAddInProgress = false;
            Logger.v("DeviceAddManager processTaskResult() : Device Add completed, processing response.");
            if (taskResult == null) {
                return;
            }
            MoEDAO.getInstance(context).setDeviceRegistrationState(taskResult.isSuccess());
            if (!taskResult.isSuccess()) {
                Logger.v("DeviceAddManager processTaskResult() : Device add failed recently");
                return;
            }
            TokenState tokenState = (TokenState)taskResult.getPayload();
            if (tokenState == null) {
                return;
            }
            if (this.isSecondaryTokenRegistrationPending && !tokenState.isSendingSecondaryToken) {
                this.isSecondaryTokenRegistrationPending = false;
                this.registerPushToken(context);
            }
            if (this.isFcmRegistrationPending && !tokenState.isSendingFcmToken) {
                this.isFcmRegistrationPending = false;
                this.registerFcmToken(context);
            }
            if (this.isGdprRequestPending) {
                this.isGdprRequestPending = false;
                this.registerGdprOptOut(context);
            }
        }
        catch (Exception e) {
            Logger.e("DeviceAddManager processTaskResult() : Exception ", e);
        }
    }
}

