/*
 * Decompiled with CFR 0.152.
 */
package com.moe.pushlibrary.providers;

import android.content.ContentProvider;
import android.content.ContentProviderOperation;
import android.content.ContentProviderResult;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.OperationApplicationException;
import android.content.UriMatcher;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteQueryBuilder;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.moe.pushlibrary.providers.MoEDataContract;
import com.moe.pushlibrary.providers.MoEDatabaseHelper;
import com.moengage.core.Logger;
import com.moengage.core.MoEConstants;
import com.moengage.core.storage.CardsDataContract;
import java.util.ArrayList;
import java.util.HashMap;

public class MoEProvider
extends ContentProvider {
    private static final String TAG = "MoEProvider";
    private static final int MESSAGES = 1;
    private static final int MESSAGE_ID = 2;
    private static final int DATAPOINTS = 3;
    private static final int DATAPOINT_ID = 4;
    private static final int INAPPS = 5;
    private static final int INAPP_ID = 6;
    private static final int USER_ATTRIBUTES = 9;
    private static final int USER_ATTRIBUTES_ID = 10;
    private static final int CAMPAIGN_IDS = 11;
    private static final int CAMPAIGN_ID = 12;
    private static final int DATA_BATCHES = 13;
    private static final int DATA_BATCH = 14;
    private static final int DEVICE_TRIGGERS = 15;
    private static final int DEVICE_TRIGGER = 16;
    private static final int ATTRIBUTE_CACHE = 17;
    private static final int ATTRIBUTE_CACHE_ID = 18;
    private static final int INAPPV3_CAMPAIGNS = 19;
    private static final int INAPPV3_CAMPAIGN = 20;
    private static final int INAPP_STATS = 21;
    private static final int INAPP_STAT = 22;
    private static final int CARD_CAMPAIGNS = 23;
    private static final int CARD_CAMPAIGN = 24;
    private static UriMatcher uriMatcher;
    private static HashMap<String, String> messageProjectionMap;
    private static HashMap<String, String> eventProjectionMap;
    private static HashMap<String, String> inAppProjectionMap;
    private static HashMap<String, String> userAttributeProjectionMap;
    private static HashMap<String, String> campaignListProjectionMap;
    private static HashMap<String, String> batchDataProjectionMap;
    private static HashMap<String, String> dTProjectionMap;
    private static HashMap<String, String> inAppV3ProjectionMap;
    private static HashMap<String, String> attributeCacheMap;
    private static HashMap<String, String> inAppStatsMap;
    private static HashMap<String, String> cardCampaignMap;
    private MoEDatabaseHelper databaseHelper = null;

    public boolean onCreate() {
        this.databaseHelper = new MoEDatabaseHelper(this.getContext());
        this.initializeUriMatcher();
        Logger.d("MoEProvider: Provider created");
        return true;
    }

    private void initializeUriMatcher() {
        uriMatcher = new UriMatcher(-1);
        Context context = this.getContext();
        uriMatcher.addURI(MoEDataContract.getAuthority(context), "messages", 1);
        uriMatcher.addURI(MoEDataContract.getAuthority(context), "messages/#", 2);
        uriMatcher.addURI(MoEDataContract.getAuthority(context), "datapoints", 3);
        uriMatcher.addURI(MoEDataContract.getAuthority(context), "datapoints/#", 4);
        uriMatcher.addURI(MoEDataContract.getAuthority(context), "inapps", 5);
        uriMatcher.addURI(MoEDataContract.getAuthority(context), "inapps/#", 6);
        uriMatcher.addURI(MoEDataContract.getAuthority(context), "userattributes/", 9);
        uriMatcher.addURI(MoEDataContract.getAuthority(context), "userattributes/#", 10);
        uriMatcher.addURI(MoEDataContract.getAuthority(context), "campaignlist/", 11);
        uriMatcher.addURI(MoEDataContract.getAuthority(context), "campaignlist/#", 12);
        uriMatcher.addURI(MoEDataContract.getAuthority(context), "batchdata/", 13);
        uriMatcher.addURI(MoEDataContract.getAuthority(context), "batchdata/#", 14);
        uriMatcher.addURI(MoEDataContract.getAuthority(context), "dtcampaign", 15);
        uriMatcher.addURI(MoEDataContract.getAuthority(context), "dtcampaign/#", 16);
        uriMatcher.addURI(MoEDataContract.getAuthority(context), "inappv3", 19);
        uriMatcher.addURI(MoEDataContract.getAuthority(context), "inappv3/#", 20);
        uriMatcher.addURI(MoEDataContract.getAuthority(context), "attributecache/", 17);
        uriMatcher.addURI(MoEDataContract.getAuthority(context), "attributecache/#", 18);
        uriMatcher.addURI(MoEDataContract.getAuthority(context), "inappstats", 21);
        uriMatcher.addURI(MoEDataContract.getAuthority(context), "inappstats/#", 22);
        uriMatcher.addURI(MoEDataContract.getAuthority(context), "cards/", 23);
        uriMatcher.addURI(MoEDataContract.getAuthority(context), "cards/#", 24);
    }

    public String getType(@NonNull Uri uri) {
        switch (uriMatcher.match(uri)) {
            case 1: {
                return "vnd.android.cursor.dir/vnd.moe.message";
            }
            case 2: {
                return "vnd.android.cursor.item/vnd.moe.message";
            }
            case 3: {
                return "vnd.android.cursor.dir/vnd.moe.datapoints";
            }
            case 4: {
                return "vnd.android.cursor.item/vnd.moe.datapoint";
            }
            case 5: {
                return "vnd.android.cursor.dir/vnd.moe.inapps";
            }
            case 6: {
                return "vnd.android.cursor.item/vnd.moe.inapp";
            }
            case 9: {
                return "vnd.android.cursor.dir/vnd.moe.userattributes";
            }
            case 10: {
                return "vnd.android.cursor.item/vnd.moe.userattributes";
            }
            case 11: {
                return "vnd.android.cursor.dir/vnd.moe.campaignlist";
            }
            case 12: {
                return "vnd.android.cursor.item/vnd.moe.campaignlist";
            }
            case 13: {
                return "vnd.android.cursor.dir/vnd.moe.batchdata";
            }
            case 14: {
                return "vnd.android.cursor.item/vnd.moe.batchdata";
            }
            case 15: {
                return "vnd.android.cursor.dir/vnd.moe.dtcampaign";
            }
            case 16: {
                return "vnd.android.cursor.item/vnd.moe.dtcampaign";
            }
            case 19: {
                return "vnd.android.cursor.dir/vnd.moe.inappv3";
            }
            case 20: {
                return "vnd.android.cursor.item/vnd.moe.inappv3";
            }
            case 17: {
                return "vnd.android.cursor.dir/vnd.moe.attributecache";
            }
            case 18: {
                return "vnd.android.cursor.item/vnd.moe.attributecache";
            }
            case 21: {
                return "vnd.android.cursor.dir/vnd.moe.inappstats";
            }
            case 22: {
                return "vnd.android.cursor.item/vnd.moe.inappstats";
            }
            case 23: {
                return "vnd.android.cursor.dir/vnd.moe.cards";
            }
            case 24: {
                return "vnd.android.cursor.item/vnd.moe.cards";
            }
        }
        Logger.e("No Matching URI found");
        return null;
    }

    public Cursor query(@NonNull Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        SQLiteDatabase db = this.databaseHelper.getReadableDatabase();
        this.updateIfRequired(db);
        SQLiteQueryBuilder qb = new SQLiteQueryBuilder();
        String orderBy = sortOrder;
        String limit = uri.getQueryParameter("LIMIT");
        switch (uriMatcher.match(uri)) {
            case 2: {
                qb.appendWhere((CharSequence)("_id=" + (String)uri.getPathSegments().get(1)));
            }
            case 1: {
                qb.setProjectionMap(messageProjectionMap);
                qb.setTables("MESSAGES");
                if (!TextUtils.isEmpty((CharSequence)sortOrder)) break;
                orderBy = "gtime DESC";
                break;
            }
            case 4: {
                qb.appendWhere((CharSequence)("_id=" + (String)uri.getPathSegments().get(1)));
            }
            case 3: {
                qb.setProjectionMap(eventProjectionMap);
                qb.setTables("DATAPOINTS");
                break;
            }
            case 6: {
                qb.appendWhere((CharSequence)("_id=" + (String)uri.getPathSegments().get(1)));
            }
            case 5: {
                qb.setProjectionMap(inAppProjectionMap);
                qb.setTables("INAPPMSG");
                if (!TextUtils.isEmpty((CharSequence)sortOrder)) break;
                orderBy = "priority DESC, gtime DESC";
                break;
            }
            case 9: {
                qb.setProjectionMap(userAttributeProjectionMap);
                qb.setTables("USERATTRIBUTES");
                break;
            }
            case 11: {
                qb.setProjectionMap(campaignListProjectionMap);
                qb.setTables("CAMPAIGNLIST");
                break;
            }
            case 13: {
                qb.setProjectionMap(batchDataProjectionMap);
                qb.setTables("BATCH_DATA");
                break;
            }
            case 15: {
                qb.setProjectionMap(dTProjectionMap);
                qb.setTables("DEVICE_TRIGGERS");
                break;
            }
            case 19: {
                qb.setProjectionMap(inAppV3ProjectionMap);
                qb.setTables("INAPP_V3");
                break;
            }
            case 17: {
                qb.setProjectionMap(attributeCacheMap);
                qb.setTables("ATTRIBUTE_CACHE");
                break;
            }
            case 21: {
                qb.setProjectionMap(inAppStatsMap);
                qb.setTables("INAPP_STATS");
                break;
            }
            case 23: {
                qb.setProjectionMap(cardCampaignMap);
                qb.setTables("CARDS");
                break;
            }
            default: {
                Logger.e("Unknown URI query() " + uri);
            }
        }
        Cursor c = null;
        try {
            c = qb.query(db, projection, selection, selectionArgs, null, null, orderBy, limit);
        }
        catch (Exception e) {
            Logger.e("MoEProvider query() : Exception: ", e);
        }
        return c;
    }

    public Uri insert(Uri uri, ContentValues values) {
        Uri newUri = null;
        try {
            if (null == values) {
                return null;
            }
            SQLiteDatabase db = this.databaseHelper.getWritableDatabase();
            this.updateIfRequired(db);
            long rowId = 0L;
            newUri = null;
            switch (uriMatcher.match(uri)) {
                case 1: {
                    rowId = db.insert("MESSAGES", null, values);
                    if (rowId <= 0L) break;
                    newUri = ContentUris.withAppendedId((Uri)MoEDataContract.MessageEntity.getContentUri(this.getContext()), (long)rowId);
                    break;
                }
                case 3: {
                    rowId = db.insert("DATAPOINTS", null, values);
                    if (rowId <= 0L) break;
                    newUri = ContentUris.withAppendedId((Uri)MoEDataContract.DatapointEntity.getContentUri(this.getContext()), (long)rowId);
                    break;
                }
                case 5: {
                    rowId = db.insert("INAPPMSG", null, values);
                    if (rowId <= 0L) break;
                    newUri = ContentUris.withAppendedId((Uri)MoEDataContract.InAppMessageEntity.getContentUri(this.getContext()), (long)rowId);
                    break;
                }
                case 9: {
                    rowId = db.insert("USERATTRIBUTES", null, values);
                    if (rowId <= 0L) break;
                    newUri = ContentUris.withAppendedId((Uri)MoEDataContract.UserAttributeEntity.getContentUri(this.getContext()), (long)rowId);
                    break;
                }
                case 11: {
                    rowId = db.insert("CAMPAIGNLIST", null, values);
                    if (rowId <= 0L) break;
                    newUri = ContentUris.withAppendedId((Uri)MoEDataContract.UserAttributeEntity.getContentUri(this.getContext()), (long)rowId);
                    break;
                }
                case 13: {
                    rowId = db.insert("BATCH_DATA", null, values);
                    if (rowId <= 0L) break;
                    newUri = ContentUris.withAppendedId((Uri)MoEDataContract.BatchDataEntity.getContentUri(this.getContext()), (long)rowId);
                    break;
                }
                case 15: {
                    rowId = db.insert("DEVICE_TRIGGERS", null, values);
                    if (rowId <= 0L) break;
                    newUri = ContentUris.withAppendedId((Uri)MoEDataContract.DTEntity.getContentUri(this.getContext()), (long)rowId);
                    break;
                }
                case 17: {
                    rowId = db.insert("ATTRIBUTE_CACHE", null, values);
                    if (rowId <= 0L) break;
                    newUri = ContentUris.withAppendedId((Uri)MoEDataContract.AttributeCacheEntity.getContentUri(this.getContext()), (long)rowId);
                    break;
                }
                case 19: {
                    rowId = db.insert("INAPP_V3", null, values);
                    if (rowId <= 0L) break;
                    newUri = ContentUris.withAppendedId((Uri)MoEDataContract.InAppV3Entity.getContentUri(this.getContext()), (long)rowId);
                    break;
                }
                case 21: {
                    rowId = db.insert("INAPP_STATS", null, values);
                    if (rowId <= 0L) break;
                    newUri = ContentUris.withAppendedId((Uri)MoEDataContract.InAppStatsEntity.getContentUri(this.getContext()), (long)rowId);
                    break;
                }
                case 23: {
                    rowId = db.insert("CARDS", null, values);
                    if (rowId <= 0L) break;
                    newUri = ContentUris.withAppendedId((Uri)CardsDataContract.CardsEntity.getContentUri(this.getContext()), (long)rowId);
                    break;
                }
                default: {
                    Logger.e("Unknown URI " + uri);
                }
            }
            if (null != newUri) {
                Logger.v("MoEProvider: Added new record : " + newUri.toString());
                this.getContext().getContentResolver().notifyChange(uri, null);
            } else {
                Logger.e("MoEProvider: Failed to add new record: " + uri);
            }
        }
        catch (Exception e) {
            Logger.e("MoEProvider insert() : ", e);
        }
        return newUri;
    }

    public void updateIfRequired(SQLiteDatabase db) {
        if (MoEConstants.dbUpdateRequired) {
            this.databaseHelper.addMSGTagIfRequiredInbox(db);
            this.databaseHelper.addTableIfRequired(db, "USERATTRIBUTES");
            this.databaseHelper.addTableIfRequired(db, "CAMPAIGNLIST");
            this.databaseHelper.addTableIfRequired(db, "BATCH_DATA");
            this.databaseHelper.addTableIfRequired(db, "DEVICE_TRIGGERS");
            this.databaseHelper.addTableIfRequired(db, "INAPP_V3");
            this.databaseHelper.addTableIfRequired(db, "ATTRIBUTE_CACHE");
            this.databaseHelper.addTableIfRequired(db, "INAPP_STATS");
            this.databaseHelper.addCampaignIdToMessageTable(db);
            this.databaseHelper.addTableIfRequired(db, "CARDS");
            MoEConstants.dbUpdateRequired = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public ContentProviderResult[] applyBatch(@NonNull ArrayList<ContentProviderOperation> operations) throws OperationApplicationException {
        ContentProviderResult[] result = new ContentProviderResult[operations.size()];
        int i = 0;
        SQLiteDatabase db = this.databaseHelper.getWritableDatabase();
        this.updateIfRequired(db);
        db.beginTransaction();
        try {
            for (ContentProviderOperation operation : operations) {
                result[i++] = operation.apply((ContentProvider)this, result, i);
            }
            db.setTransactionSuccessful();
        }
        catch (OperationApplicationException e) {
            Logger.e("MoEProvider : batch failed: ", e);
        }
        catch (Exception e) {
            Logger.e("MoEProvider : batch failed: ", e);
        }
        finally {
            db.endTransaction();
        }
        return result;
    }

    public int delete(Uri uri, String selection, String[] selectionArgs) {
        int count = 0;
        try {
            if (null == uri) {
                return 0;
            }
            SQLiteDatabase db = this.databaseHelper.getWritableDatabase();
            this.updateIfRequired(db);
            switch (uriMatcher.match(uri)) {
                case 1: {
                    count = db.delete("MESSAGES", selection, selectionArgs);
                    break;
                }
                case 2: {
                    String noteId = (String)uri.getPathSegments().get(1);
                    count = db.delete("MESSAGES", "_id=" + noteId + (!TextUtils.isEmpty((CharSequence)selection) ? " AND " + selection : ""), selectionArgs);
                    break;
                }
                case 3: {
                    count = db.delete("DATAPOINTS", selection, selectionArgs);
                    break;
                }
                case 4: {
                    String eventId = (String)uri.getPathSegments().get(1);
                    count = db.delete("DATAPOINTS", "_id = " + eventId + (!TextUtils.isEmpty((CharSequence)selection) ? " AND " + selection : ""), selectionArgs);
                    break;
                }
                case 5: {
                    count = db.delete("INAPPMSG", selection, selectionArgs);
                    break;
                }
                case 6: {
                    String inappId = (String)uri.getPathSegments().get(1);
                    count = db.delete("INAPPMSG", "_id=" + inappId + (!TextUtils.isEmpty((CharSequence)selection) ? " AND " + selection : ""), selectionArgs);
                    break;
                }
                case 9: {
                    count = db.delete("USERATTRIBUTES", selection, selectionArgs);
                    break;
                }
                case 10: {
                    String attributeId = (String)uri.getPathSegments().get(1);
                    count = db.delete("USERATTRIBUTES", "_id=" + attributeId + (!TextUtils.isEmpty((CharSequence)selection) ? " AND " + selection : ""), selectionArgs);
                    break;
                }
                case 11: {
                    count = db.delete("CAMPAIGNLIST", selection, selectionArgs);
                    break;
                }
                case 12: {
                    String campaignId = (String)uri.getPathSegments().get(1);
                    count = db.delete("CAMPAIGNLIST", "_id=" + campaignId + (!TextUtils.isEmpty((CharSequence)selection) ? " AND " + selection : ""), selectionArgs);
                    break;
                }
                case 13: {
                    count = db.delete("BATCH_DATA", selection, selectionArgs);
                    break;
                }
                case 14: {
                    String batchId = (String)uri.getPathSegments().get(1);
                    count = db.delete("BATCH_DATA", "_id=" + batchId + (!TextUtils.isEmpty((CharSequence)selection) ? " AND " + selection : ""), selectionArgs);
                    break;
                }
                case 15: {
                    count = db.delete("DEVICE_TRIGGERS", selection, selectionArgs);
                    break;
                }
                case 16: {
                    String triggerId = (String)uri.getPathSegments().get(1);
                    count = db.delete("DEVICE_TRIGGERS", "_id=" + triggerId + (!TextUtils.isEmpty((CharSequence)selection) ? " AND " + selection : ""), selectionArgs);
                    break;
                }
                case 17: {
                    count = db.delete("ATTRIBUTE_CACHE", selection, selectionArgs);
                    break;
                }
                case 18: {
                    String cachedAttributeId = (String)uri.getPathSegments().get(1);
                    count = db.delete("ATTRIBUTE_CACHE", "_id=" + cachedAttributeId + (!TextUtils.isEmpty((CharSequence)selection) ? " AND " + selection : ""), selectionArgs);
                    break;
                }
                case 19: {
                    count = db.delete("INAPP_V3", selection, selectionArgs);
                    break;
                }
                case 20: {
                    String inAppCamapignId = (String)uri.getPathSegments().get(1);
                    count = db.delete("INAPP_V3", "_id=" + inAppCamapignId + (!TextUtils.isEmpty((CharSequence)selection) ? " AND " + selection : ""), selectionArgs);
                    break;
                }
                case 21: {
                    count = db.delete("INAPP_STATS", selection, selectionArgs);
                    break;
                }
                case 22: {
                    String statId = (String)uri.getPathSegments().get(1);
                    count = db.delete("INAPP_STATS", "_id=" + statId + (!TextUtils.isEmpty((CharSequence)selection) ? " AND " + selection : ""), selectionArgs);
                    break;
                }
                case 23: {
                    count = db.delete("CARDS", selection, selectionArgs);
                    break;
                }
                case 24: {
                    String cardId = (String)uri.getPathSegments().get(1);
                    count = db.delete("CARDS", "_id=" + cardId + (!TextUtils.isEmpty((CharSequence)selection) ? " AND " + selection : ""), selectionArgs);
                    break;
                }
                default: {
                    Logger.e("Unknown URI " + uri);
                }
            }
            this.getContext().getContentResolver().notifyChange(uri, null);
            Logger.v("MoEProvider: Deleted " + count + " record(s) for URI: " + uri.toString());
        }
        catch (Exception e) {
            Logger.e("MoEProvider delete() : ", e);
        }
        return count;
    }

    public int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        int count = 0;
        try {
            SQLiteDatabase db = this.databaseHelper.getWritableDatabase();
            this.updateIfRequired(db);
            switch (uriMatcher.match(uri)) {
                case 1: {
                    count = db.update("MESSAGES", values, selection, selectionArgs);
                    break;
                }
                case 2: {
                    String msgId = (String)uri.getPathSegments().get(1);
                    count = db.update("MESSAGES", values, "_id=" + msgId + (!TextUtils.isEmpty((CharSequence)selection) ? " AND " + selection : ""), selectionArgs);
                    break;
                }
                case 3: {
                    count = db.update("DATAPOINTS", values, selection, selectionArgs);
                    break;
                }
                case 4: {
                    String eventId = (String)uri.getPathSegments().get(1);
                    count = db.update("DATAPOINTS", values, "_id=" + eventId + (!TextUtils.isEmpty((CharSequence)selection) ? " AND " + selection : ""), selectionArgs);
                    break;
                }
                case 5: {
                    count = db.update("INAPPMSG", values, selection, selectionArgs);
                    break;
                }
                case 6: {
                    String inAppId = (String)uri.getPathSegments().get(1);
                    count = db.update("INAPPMSG", values, "_id=" + inAppId + (!TextUtils.isEmpty((CharSequence)selection) ? " AND " + selection : ""), selectionArgs);
                    break;
                }
                case 9: {
                    count = db.update("USERATTRIBUTES", values, selection, selectionArgs);
                    break;
                }
                case 10: {
                    String attributeId = (String)uri.getPathSegments().get(1);
                    count = db.update("USERATTRIBUTES", values, "_id=" + attributeId + (!TextUtils.isEmpty((CharSequence)selection) ? " AND " + selection : ""), selectionArgs);
                    break;
                }
                case 11: {
                    count = db.update("CAMPAIGNLIST", values, selection, selectionArgs);
                    break;
                }
                case 12: {
                    String campaignId = (String)uri.getPathSegments().get(1);
                    count = db.update("CAMPAIGNLIST", values, "_id=" + campaignId + (!TextUtils.isEmpty((CharSequence)selection) ? " AND " + selection : ""), selectionArgs);
                    break;
                }
                case 13: {
                    count = db.update("BATCH_DATA", values, selection, selectionArgs);
                    break;
                }
                case 14: {
                    String batchId = (String)uri.getPathSegments().get(1);
                    count = db.update("BATCH_DATA", values, "_id=" + batchId + (!TextUtils.isEmpty((CharSequence)selection) ? " AND " + selection : ""), selectionArgs);
                    break;
                }
                case 15: {
                    count = db.update("DEVICE_TRIGGERS", values, selection, selectionArgs);
                    break;
                }
                case 16: {
                    String triggerId = (String)uri.getPathSegments().get(1);
                    count = db.update("DEVICE_TRIGGERS", values, "_id=" + triggerId + (!TextUtils.isEmpty((CharSequence)selection) ? " AND " + selection : ""), selectionArgs);
                    break;
                }
                case 17: {
                    count = db.update("ATTRIBUTE_CACHE", values, selection, selectionArgs);
                    break;
                }
                case 18: {
                    String cachedAttributeId = (String)uri.getPathSegments().get(1);
                    count = db.update("ATTRIBUTE_CACHE", values, "_id=" + cachedAttributeId + (!TextUtils.isEmpty((CharSequence)selection) ? " AND " + selection : ""), selectionArgs);
                    break;
                }
                case 19: {
                    count = db.update("INAPP_V3", values, selection, selectionArgs);
                    break;
                }
                case 20: {
                    String inAppCampaignId = (String)uri.getPathSegments().get(1);
                    count = db.update("INAPP_V3", values, "_id=" + inAppCampaignId + (!TextUtils.isEmpty((CharSequence)selection) ? " AND " + selection : ""), selectionArgs);
                    break;
                }
                case 21: {
                    count = db.update("INAPP_STATS", values, selection, selectionArgs);
                    break;
                }
                case 22: {
                    String statId = (String)uri.getPathSegments().get(1);
                    count = db.update("INAPP_STATS", values, "_id=" + statId + (!TextUtils.isEmpty((CharSequence)selection) ? " AND " + selection : ""), selectionArgs);
                    break;
                }
                case 23: {
                    count = db.update("CARDS", values, selection, selectionArgs);
                    break;
                }
                case 24: {
                    String cardId = (String)uri.getPathSegments().get(1);
                    count = db.update("CARDS", values, "_id=" + cardId + (!TextUtils.isEmpty((CharSequence)selection) ? " AND " + selection : ""), selectionArgs);
                    break;
                }
                default: {
                    Logger.e("Unknown URI " + uri);
                }
            }
            this.getContext().getContentResolver().notifyChange(uri, null);
            Logger.v("MoEProvider: Updated " + count + " record(s)");
        }
        catch (Exception e) {
            Logger.e("MoEProvider update() : ", e);
        }
        return count;
    }

    static {
        messageProjectionMap = new HashMap();
        messageProjectionMap.put("_id", "_id");
        messageProjectionMap.put("gtime", "gtime");
        messageProjectionMap.put("msg", "msg");
        messageProjectionMap.put("msgclicked", "msgclicked");
        messageProjectionMap.put("msgttl", "msgttl");
        messageProjectionMap.put("msg_tag", "msg_tag");
        messageProjectionMap.put("campaign_id", "campaign_id");
        eventProjectionMap = new HashMap();
        eventProjectionMap.put("_id", "_id");
        eventProjectionMap.put("gtime", "gtime");
        eventProjectionMap.put("details", "details");
        inAppProjectionMap = new HashMap();
        inAppProjectionMap.put("_id", "_id");
        inAppProjectionMap.put("gtime", "gtime");
        inAppProjectionMap.put("campaign_id", "campaign_id");
        inAppProjectionMap.put("align_type", "align_type");
        inAppProjectionMap.put("inapp_type", "inapp_type");
        inAppProjectionMap.put("ttl", "ttl");
        inAppProjectionMap.put("min_delay", "min_delay");
        inAppProjectionMap.put("max_times", "max_times");
        inAppProjectionMap.put("shown_count", "shown_count");
        inAppProjectionMap.put("persistent", "persistent");
        inAppProjectionMap.put("priority", "priority");
        inAppProjectionMap.put("context", "context");
        inAppProjectionMap.put("last_shown", "last_shown");
        inAppProjectionMap.put("is_clicked", "is_clicked");
        inAppProjectionMap.put("has_errors", "has_errors");
        inAppProjectionMap.put("auto_dismiss", "auto_dismiss");
        inAppProjectionMap.put("cancelable", "cancelable");
        inAppProjectionMap.put("content", "content");
        inAppProjectionMap.put("show_only_in", "show_only_in");
        inAppProjectionMap.put("status", "status");
        inAppProjectionMap.put("dim_style", "dim_style");
        userAttributeProjectionMap = new HashMap();
        userAttributeProjectionMap.put("_id", "_id");
        userAttributeProjectionMap.put("gtime", "gtime");
        userAttributeProjectionMap.put("attribute_name", "attribute_name");
        userAttributeProjectionMap.put("attribute_value", "attribute_value");
        campaignListProjectionMap = new HashMap();
        campaignListProjectionMap.put("_id", "_id");
        campaignListProjectionMap.put("campaign_id", "campaign_id");
        campaignListProjectionMap.put("ttl", "ttl");
        batchDataProjectionMap = new HashMap();
        batchDataProjectionMap.put("_id", "_id");
        batchDataProjectionMap.put("batch_data", "batch_data");
        dTProjectionMap = new HashMap();
        dTProjectionMap.put("_id", "_id");
        dTProjectionMap.put("campaign_id", "campaign_id");
        dTProjectionMap.put("event_name", "event_name");
        dTProjectionMap.put("payload", "payload");
        dTProjectionMap.put("campaign_payload", "campaign_payload");
        dTProjectionMap.put("campaign_type", "campaign_type");
        dTProjectionMap.put("max_count", "max_count");
        dTProjectionMap.put("minimum_delay", "minimum_delay");
        dTProjectionMap.put("should_show_offline", "should_show_offline");
        dTProjectionMap.put("max_sync_delay_time", "max_sync_delay_time");
        dTProjectionMap.put("expiry_time", "expiry_time");
        dTProjectionMap.put("priority", "priority");
        dTProjectionMap.put("last_show_time", "last_show_time");
        dTProjectionMap.put("show_count", "show_count");
        dTProjectionMap.put("last_updated_time", "last_updated_time");
        dTProjectionMap.put("status", "status");
        dTProjectionMap.put("should_ignore_dnd", "should_ignore_dnd");
        dTProjectionMap.put("delay_before_showing", "delay_before_showing");
        inAppV3ProjectionMap = new HashMap();
        inAppV3ProjectionMap.put("_id", "_id");
        inAppV3ProjectionMap.put("campaign_id", "campaign_id");
        inAppV3ProjectionMap.put("type", "type");
        inAppV3ProjectionMap.put("status", "status");
        inAppV3ProjectionMap.put("state", "state");
        inAppV3ProjectionMap.put("priority", "priority");
        inAppV3ProjectionMap.put("last_updated_time", "last_updated_time");
        inAppV3ProjectionMap.put("template_type", "template_type");
        inAppV3ProjectionMap.put("deletion_time", "deletion_time");
        inAppV3ProjectionMap.put("last_received_time", "last_received_time");
        inAppV3ProjectionMap.put("campaign_meta", "campaign_meta");
        attributeCacheMap = new HashMap();
        attributeCacheMap.put("_id", "_id");
        attributeCacheMap.put("name", "name");
        attributeCacheMap.put("value", "value");
        attributeCacheMap.put("last_tracked_time", "last_tracked_time");
        attributeCacheMap.put("datatype", "datatype");
        inAppStatsMap = new HashMap();
        inAppStatsMap.put("_id", "_id");
        inAppStatsMap.put("payload", "payload");
        inAppStatsMap.put("request_id", "request_id");
        inAppStatsMap.put("timestamp", "timestamp");
        cardCampaignMap = new HashMap();
        cardCampaignMap.put("_id", "_id");
        cardCampaignMap.put("card_id", "card_id");
        cardCampaignMap.put("category", "category");
        cardCampaignMap.put("campaign_state", "campaign_state");
        cardCampaignMap.put("visibility_status", "visibility_status");
        cardCampaignMap.put("last_updated_time", "last_updated_time");
        cardCampaignMap.put("campaign_payload", "campaign_payload");
        cardCampaignMap.put("is_pinned", "is_pinned");
        cardCampaignMap.put("deletion_time", "deletion_time");
        cardCampaignMap.put("is_new_card", "is_new_card");
        cardCampaignMap.put("is_deleted", "is_deleted");
        cardCampaignMap.put("priority", "priority");
    }
}

