package com.moengage.core.remoteconfig;

import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.moengage.core.Logger;
import com.moengage.core.model.RemoteConfig;
import com.moengage.core.rest.Response;
import org.json.JSONObject;

/**
 * @author Umang Chamaria
 */
class RemoteConfigResponseParser {

  private static final String TAG = "RemoteConfigResponseParser";

  @Nullable RemoteConfig parseConfigApiResponse(Response response) {
    try {
      if (TextUtils.isEmpty(response.responseBody)) return null;
      JSONObject responseJson = new JSONObject(response.responseBody);
      return RemoteConfig.fromJson(responseJson);
    } catch (Exception e) {
      Logger.f(TAG + " parseConfigApiResponse() : Exception ", e);
    }
    return null;
  }
}
