package com.moengage.core.model;

import android.support.annotation.RestrictTo;
import android.support.annotation.RestrictTo.Scope;
import com.moengage.core.ISO8601Utils;
import java.util.Date;

/**
 * @author Umang Chamaria
 */
@RestrictTo(Scope.LIBRARY_GROUP)
public class MoEAttribute {
  private String name;
  private String value;
  private long lastTrackedTime;
  private String dataType;

  public MoEAttribute(String name, String value, long lastTrackedTime, String dataType) {
    this.name = name;
    this.value = value;
    this.lastTrackedTime = lastTrackedTime;
    this.dataType = dataType;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getValue() {
    return value;
  }

  public void setValue(String value) {
    this.value = value;
  }

  public long getLastTrackedTime() {
    return lastTrackedTime;
  }

  public String getDataType() {
    return dataType;
  }

  @Override public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;

    MoEAttribute that = (MoEAttribute) o;

    if (!name.equals(that.name)) return false;
    return value.equals(that.value);
  }

  @Override public String toString() {
    return "MoEAttribute{"
        + "name='"
        + name
        + '\''
        + ", value='"
        + value
        + '\''
        + ", lastTrackedTime="
        + ISO8601Utils.format(new Date(lastTrackedTime))
        + ", dataType='"
        + dataType
        + '\''
        + '}';
  }
}
