/*
 * Copyright (c) 2014-2020 MoEngage Inc.
 *
 * All rights reserved.
 *
 *  Use of source code or binaries contained within MoEngage SDK is permitted only to enable use of the MoEngage platform by customers of MoEngage.
 *  Modification of source code and inclusion in mobile apps is explicitly allowed provided that all other conditions are met.
 *  Neither the name of MoEngage nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *  Redistribution of source code or binaries is disallowed except with specific prior written permission. Any such redistribution must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.moengage.core.cards;

import android.content.Context;
import com.moengage.core.Logger;

/**
 * @author Umang Chamaria
 * Date: 16/04/20
 */
public class CardManager {

  private static final String TAG = "CardManager";

  private static CardManager instance;
  private CardHandler handler;

  public static CardManager getInstance() {
    if (instance == null){
      synchronized (CardManager.class){
        if (instance == null) instance = new CardManager();
      }
    }
    return instance;
  }

  private CardManager(){
    loadHandler();
  }

  private void loadHandler(){
    try {
      Class clazz = Class.forName("com.moengage.cards.CardHandlerImpl");
      handler = (CardHandler) clazz.newInstance();
    } catch (Exception e) {
      Logger.e( TAG + " loadHandler() : Card module not found.");
    }
  }

  public void onAppOpen(Context context){
    if (handler != null){
      handler.onAppOpen(context);
    }
  }

  public void onLogout(Context context){
    if (handler != null){
      handler.onLogout(context);
    }
  }

}
