/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.push;

import android.content.Context;
import android.support.annotation.Nullable;
import com.moengage.core.Logger;
import com.moengage.push.PushBaseHandler;
import com.moengage.push.PushHandler;
import com.moengage.push.TokenHandler;

public class PushManager {
    private static final String TAG = "PushManager";
    private PushBaseHandler pushBaseHandler;
    private static PushManager instance = null;
    private PushHandler pushHandler;

    private PushManager() {
        this.loadPushHandler();
    }

    private void loadPushHandler() {
        try {
            Class<?> baseHandler = Class.forName("com.moengage.pushbase.PushBaseHandlerImpl");
            this.pushBaseHandler = (PushBaseHandler)baseHandler.newInstance();
            Class<?> handler = Class.forName("com.moengage.firebase.PushHandlerImpl");
            this.pushHandler = (PushHandler)handler.newInstance();
            Logger.v("PushManager:loadPushHandler FCM Enabled");
        }
        catch (Exception e) {
            Logger.e("PushManager loadPushHandler : did not find supported module: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PushManager getInstance() {
        if (instance != null) return instance;
        Class<PushManager> clazz = PushManager.class;
        synchronized (PushManager.class) {
            if (instance != null) return instance;
            instance = new PushManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Deprecated
    public void setMessageListener(Object messageListener) {
        if (this.pushBaseHandler != null) {
            this.pushBaseHandler.setPushMessageListener(messageListener);
        }
    }

    public void refreshToken(Context context, String token) {
        TokenHandler.getInstance().processToken(context, token, "App");
    }

    @Nullable
    public PushHandler getPushHandler() {
        return this.pushHandler;
    }

    public void setTokenObserver(OnTokenReceivedListener tokenObserver) {
        TokenHandler.getInstance().setTokenListener(tokenObserver);
    }

    public static interface OnTokenReceivedListener {
        public void onTokenReceived(String var1);
    }
}

