/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core;

import android.util.Log;
import com.moengage.core.MoEUtils;

public class Logger {
    public static final int VERBOSE = 5;
    public static final int DEBUG = 4;
    public static final int WARN = 3;
    public static final int ERROR = 2;
    public static final int INFO = 1;
    public static final int NO_LOGS = 0;
    static int LOG_LEVEL = 2;
    private static final String TAG = "MoEngage_v10003";
    static boolean isLoggingEnabled = false;

    private Logger() {
    }

    public static void v(String msg) {
        if (isLoggingEnabled && LOG_LEVEL >= 5) {
            if (msg.length() > 4000) {
                Log.v((String)TAG, (String)msg.substring(0, 4000));
                Logger.v(msg.substring(4000));
            } else {
                Log.v((String)TAG, (String)msg);
            }
        }
    }

    public static void v(String msg, Throwable tr) {
        if (isLoggingEnabled && LOG_LEVEL >= 5) {
            Log.v((String)TAG, (String)msg, (Throwable)tr);
        }
    }

    public static void d(String msg) {
        if (isLoggingEnabled && LOG_LEVEL >= 4) {
            Log.d((String)TAG, (String)msg);
        }
    }

    public static void d(String msg, Throwable tr) {
        if (isLoggingEnabled && LOG_LEVEL >= 4) {
            Log.d((String)TAG, (String)msg, (Throwable)tr);
        }
    }

    public static void i(String msg) {
        if (isLoggingEnabled && LOG_LEVEL >= 1) {
            Log.i((String)TAG, (String)msg);
        }
    }

    public static void i(String msg, Throwable tr) {
        if (isLoggingEnabled && LOG_LEVEL >= 1) {
            Log.i((String)TAG, (String)msg, (Throwable)tr);
        }
    }

    public static void w(String msg) {
        if (isLoggingEnabled && LOG_LEVEL >= 3) {
            Log.w((String)TAG, (String)msg);
        }
    }

    public static void w(String msg, Throwable tr) {
        if (isLoggingEnabled && LOG_LEVEL >= 3) {
            Log.w((String)TAG, (String)msg, (Throwable)tr);
        }
    }

    public static void e(String msg) {
        if (isLoggingEnabled && LOG_LEVEL >= 2) {
            Log.e((String)TAG, (String)msg);
        }
    }

    public static void e(String msg, Throwable tr) {
        if (isLoggingEnabled && LOG_LEVEL >= 2) {
            Log.e((String)TAG, (String)msg, (Throwable)tr);
        }
    }

    public static void f(String msg) {
        if (isLoggingEnabled && LOG_LEVEL >= 2) {
            Log.e((String)TAG, (String)msg);
        }
    }

    public static void f(String msg, Throwable tr) {
        if (isLoggingEnabled && LOG_LEVEL >= 2) {
            Log.e((String)TAG, (String)msg, (Throwable)tr);
        }
    }

    public static void setLogLevel(int logLevel) {
        LOG_LEVEL = logLevel;
    }

    public static void enableDebugLog() {
        try {
            isLoggingEnabled = MoEUtils.isDebugBuild || isLoggingEnabled;
        }
        catch (Exception e) {
            Logger.e("Logger : enableDebugLog", e);
        }
    }

    public static void setLogStatus(boolean value) {
        isLoggingEnabled = value;
    }
}

