package com.moengage.core.integrations.segment;

import android.content.Context;
import com.moe.pushlibrary.MoEHelper;
import com.moe.pushlibrary.PayloadBuilder;
import com.moengage.core.Logger;
import com.moengage.core.MoEUtils;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import java.util.Iterator;
import org.json.JSONObject;

/**
 * Transform Segment's event attribute format to MoEngage format and track an event.
 * @author Umang Chamaria
 * Date: 29/04/19
 */
public class TrackSegmentEventTask extends SDKTask {

  private String eventName;
  private JSONObject eventAttributes;

  private static final String TAG = "TrackSegmentEventTask";

  public TrackSegmentEventTask(Context context, String eventName, JSONObject eventAttributes) {
    super(context);
    this.eventName =  eventName;
    this.eventAttributes = eventAttributes;
  }

  @Override public TaskResult execute() {
    try{
      Logger.v(TAG + " execute() : Started Execution");
      MoEHelper.getInstance(context).trackEvent(eventName,
          transformEventAttributesToMoEngageFormat(eventAttributes));
      Logger.v(TAG + " execute() : Completed Execution");
    }catch (Exception e){
      Logger.e( TAG + " execute() : Exception: ", e);
    }
    return null;
  }

  @Override public String getTaskTag() {
    return TAG_TRACK_EVENT_SEGMENT;
  }

  @Override public boolean isSynchronous() {
    return false;
  }

  /**
   * Converts the Segment Properties to a format understood by MoEngage SDK.
   *
   * @param eventAttributes Properties passed by the Segment SDK.
   * @return {@link JSONObject} of properties converted to MoEngage Format.
   */
  private JSONObject transformEventAttributesToMoEngageFormat(JSONObject eventAttributes) {
    try {
      Logger.v(TAG + " transformEventAttributesToMoEngageFormat() : Transforming track properties "
          + " to MoEngage format");
      PayloadBuilder builder = new PayloadBuilder();
      Iterator iterator = eventAttributes.keys();
      while (iterator.hasNext()) {
        String key = (String) iterator.next();
        Object value = eventAttributes.get(key);
        if (value instanceof String) {
          if (!MoEUtils.isDate((String) value)) {
            builder.putAttrObject(key, value);
          } else {
            builder.putAttrISO8601Date(key, (String) value);
          }
        } else {
          builder.putAttrObject(key, value);
        }
      }
      return builder.build();
    } catch (Exception e) {
      Logger.f(TAG + " transformEventAttributesToMoEngageFormat() : ");
      return eventAttributes;
    }
  }
}
