package com.moengage.core.inapp;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import com.moe.pushlibrary.models.Event;
import com.moengage.core.model.InAppV2Meta;
import com.moengage.core.model.InAppV3Meta;

public interface InAppHandler {

  /**
   * (non-Javadoc)
   * Sync in-apps from the server
   *
   * @param context Application Context
   */
  void showInAppIfRequired(Context context);

  /**
   * (non-Javadoc)
   * Registers a smart event and tries to show in-app for it
   *
   * @param context Application Context
   * @param event Event
   */
  void showTriggerInAppIfPossible(Context context, Event event);

  /**
   * (non-Javadoc)
   * Register to show in-apps in the activity.<br>
   *
   * @param currentActivity Activity instance in which in-apps needs to be shown.
   */
  void registerInAppManager(Activity currentActivity);

  /**
   * (non-Javadoc)
   * Unregister to show in-apps in the activity.<br>
   *
   * @param currentActivity Activity instance in which in-apps needs to be shown.
   */
  void unregisterInAppManager(Activity currentActivity);

  /**
   * Store the in-app check failure counter as an event
   *
   * @param context Application Context
   */
  void onAppClose(Context context);

  /**
   * Clear in-app related preference data.
   *
   * @param context Application Context
   */
  void onLogout(Context context);

  /**
   * Syncs the in-app meta API if required.
   *
   * @param context instance of {@link Context}
   */
  void syncInAppIfRequired(Context context);

  /**
   * Generate payload to migrate v2 campaign to v3.
   *
   * @param inAppV2Meta instance of {@link InAppV2Meta}
   * @return instance of {@link InAppV3Meta}
   */
  InAppV3Meta generateMetaForV2Campaign(InAppV2Meta inAppV2Meta);

  void showInAppFromPush(Context context, Bundle pushPayload);
}