package com.moengage.core.events;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.RestrictTo;
import android.support.annotation.RestrictTo.Scope;
import android.support.annotation.WorkerThread;
import com.moe.pushlibrary.MoEHelper;
import com.moe.pushlibrary.PayloadBuilder;
import com.moe.pushlibrary.models.Event;
import com.moengage.core.Logger;
import com.moengage.core.MoEDAO;
import com.moengage.core.MoEDispatcher;
import com.moengage.core.model.RemoteConfig;
import java.util.Set;
import org.json.JSONObject;

/**
 * Central point for all event related processing, i.e. tracking, blacklisting, trigger-events
 *
 * @author Umang Chamaria
 */

public class MoEEventManager {

  private static final String TAG = "MoEEventManager";

  private static MoEEventManager instance = null;

  private Context context;

  private int eventCounter = 0;

  EventHandler eventHandler;

  private MoEEventManager(Context context) {
    this.context = context;
    eventHandler = new EventHandler();
  }

  public static MoEEventManager getInstance(Context context) {
    if (instance == null) {
      synchronized (MoEEventManager.class) {
        if (instance == null) instance = new MoEEventManager(context);
      }
    }
    return instance;
  }

  int getEventCounter() {
    return eventCounter;
  }

  void incrementEventCounter() {
    eventCounter++;
  }

  public void setEventCounter(int counter) {
    eventCounter = counter;
  }

  public void trackEvent(String action, JSONObject attributes) {
    trackEvent(eventHandler.transformToEventModel(action, attributes));
  }

  public void trackEvent(String action, PayloadBuilder attributes){
    trackEvent(new Event(action, attributes.build()));
  }

  public void trackEvent(Event event) {
    if (!RemoteConfig.getConfig().isAppEnabled) return;
    MoEDispatcher.getInstance(context).addTaskToQueue(new TrackEventTask(context, event));
  }



  private boolean isFlushEvent(String eventName) {
    Set<String> flushEvents =
        RemoteConfig.getConfig().flushEvents;
    return flushEvents!= null && flushEvents.contains(eventName);
  }

  void flushIfRequired(@NonNull Event event) {
    if (event.eventName != null && isFlushEvent(event.eventName)) {
      Logger.v(TAG + " flushIfRequired() flush event : " + event.eventName);
      MoEHelper.getInstance(context).syncInteractionDataNow();
    }
  }

  @WorkerThread @RestrictTo(Scope.LIBRARY_GROUP)
  public void writeDataPointToStorage(Event event) {
    MoEDAO.getInstance(context).addEvent(event);
  }

}
