package com.moengage.core;

import android.support.annotation.Nullable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

/**
 * @author Umang Chamaria
 */
public class ConfigurationCache {

  private HashMap<String, Object> configMap;

  private static ConfigurationCache instance;

  private ConfigurationCache() {
    configMap = new HashMap<>();
    sentScreenNames = new HashSet<>();
  }

  public static ConfigurationCache getInstance() {
    if (instance == null) {
      synchronized (ConfigurationCache.class) {
        if (instance == null) instance = new ConfigurationCache();
      }
    }
    return instance;
  }

  private Set<String> sentScreenNames;

  void initialiseSentScreens(Set<String> sentScreenNames){
    this.sentScreenNames.addAll(sentScreenNames);
  }

  void addScreenToSentList(String screenName){
    sentScreenNames.add(screenName);
  }

  Set<String> getSentScreenNames(){
    return sentScreenNames;
  }


  private static final String INTEGRATION_TYPE = "integration_type";

  public void setIntegrationType(String integrationType){
    configMap.put(INTEGRATION_TYPE, integrationType);
  }

  @Nullable public String getIntegrationType(){
   return configMap.containsKey(INTEGRATION_TYPE) ?
       String.valueOf(configMap.get(INTEGRATION_TYPE)) : null;
  }

  private static final String INTEGRATION_VERSION = "integration_version";

  // intentionally leaving this method here for legacy reasons.
  public void setIntegrationVersion(int integrationVersion){

  }

  public void setIntegrationVersion(String integrationVersion){
    configMap.put(INTEGRATION_VERSION, integrationVersion);
  }

  public String getIntegrationVersion(){
    return configMap.containsKey(INTEGRATION_VERSION) ?
        (String) configMap.get(INTEGRATION_VERSION): "";
  }

}
