/* ************************************************************************
 *
 * MOENGAGE CONFIDENTIAL
 * __________________
 *
 *  [2014] - [2015] MoEngage Inc.
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of MoEngage Inc. The intellectual and technical concepts
 * contained herein are proprietary to MoEngage Incorporated
 * and its suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from MoEngage Incorporated.
 */
package com.moe.pushlibrary.providers;

import android.content.ContentProvider;
import android.content.ContentProviderOperation;
import android.content.ContentProviderResult;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.OperationApplicationException;
import android.content.UriMatcher;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteQueryBuilder;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.moe.pushlibrary.providers.MoEDataContract.AttributeCacheEntity;
import com.moe.pushlibrary.providers.MoEDataContract.BatchDataEntity;
import com.moe.pushlibrary.providers.MoEDataContract.CampaignListEntity;
import com.moe.pushlibrary.providers.MoEDataContract.DTEntity;
import com.moe.pushlibrary.providers.MoEDataContract.DatapointEntity;
import com.moe.pushlibrary.providers.MoEDataContract.InAppMessageEntity;
import com.moe.pushlibrary.providers.MoEDataContract.InAppStatsEntity;
import com.moe.pushlibrary.providers.MoEDataContract.InAppV3Entity;
import com.moe.pushlibrary.providers.MoEDataContract.MessageEntity;
import com.moe.pushlibrary.providers.MoEDataContract.UserAttributeEntity;
import com.moengage.core.Logger;
import com.moengage.core.MoEConstants;
import java.util.ArrayList;
import java.util.HashMap;

/**
 * This is a content provider for accessing the MoEngage data.
 *
 * @author MoEngage (abhishek@moengage.com)
 * @since v5
 */
public class MoEProvider extends ContentProvider {

  private static final String TAG = "MoEProvider";

  /**
   * Denotes that the URI matched Messages
   */
  private static final int MESSAGES = 1;
  /**
   * Denotes that the URI matched a` single PromotionalMessage entry
   */
  private static final int MESSAGE_ID = 2;
  /**
   * Denotes that the URI matched Events
   */
  private static final int DATAPOINTS = 3;
  /**
   * Denotes that the URI matched a single Event entry
   */
  private static final int DATAPOINT_ID = 4;
  /**
   * Denotes that the URI matched InApps
   */
  private static final int INAPPS = 5;
  /**
   * Denotes that the URI matched a single InApp entry
   */
  private static final int INAPP_ID = 6;
  /**
   * Denotes that URI matched user attributes
   */
  private static final int USER_ATTRIBUTES = 9;
  /**
   * Denotes that URI matched a  user attribute
   */
  private static final int USER_ATTRIBUTES_ID = 10;
  /**
   * Denotes that URI matched campaign ids
   */
  private static final int CAMPAIGN_IDS = 11;
  /**
   * Denotes that URI matched a  campaign id
   */
  private static final int CAMPAIGN_ID = 12;
  /**
   * Denotes the uri matched to batches of data
   */
  private static final int DATA_BATCHES = 13;
  /**
   * Denotes the uri matched to a batch of data
   */
  private static final int DATA_BATCH = 14;

  private static final int DEVICE_TRIGGERS = 15;

  private static final int DEVICE_TRIGGER = 16;

  private static final int ATTRIBUTE_CACHE = 17;

  private static final int ATTRIBUTE_CACHE_ID = 18;

  private static final int INAPPV3_CAMPAIGNS = 19;

  private static final int INAPPV3_CAMPAIGN = 20;

  private static final int INAPP_STATS = 21;

  private static final int INAPP_STAT = 22;

  /**
   * Instance of {@link UriMatcher} used for getting the type of the URI
   */
  private static UriMatcher sUriMatcher;

  private static HashMap<String, String> sMessageProjectionMap;
  private static HashMap<String, String> sEventProjectionMap;
  private static HashMap<String, String> sInAppProjectionMap;
  private static HashMap<String, String> sUserAttributeProjectionMap;
  private static HashMap<String, String> sCampaignListProjectionMap;
  private static HashMap<String, String> sBatchDataProjectionMap;
  private static HashMap<String, String> sDTProjectionMap;
  private static HashMap<String, String> sInAppV3ProjectionMap;
  private static HashMap<String, String> sAttributeCacheMap;
  private static HashMap<String, String> sInAppStatsMap;

  static {

    sMessageProjectionMap = new HashMap<>();
    sMessageProjectionMap.put(MessageEntity._ID, MessageEntity._ID);
    sMessageProjectionMap.put(MessageEntity.GTIME, MessageEntity.GTIME);
    sMessageProjectionMap.put(MessageEntity.MSG_DETAILS, MessageEntity.MSG_DETAILS);
    sMessageProjectionMap.put(MessageEntity.MSG_CLICKED, MessageEntity.MSG_CLICKED);
    sMessageProjectionMap.put(MessageEntity.MSG_TTL, MessageEntity.MSG_TTL);
    sMessageProjectionMap.put(MessageEntity.MSG_TAG, MessageEntity.MSG_TAG);
    sMessageProjectionMap.put(MessageEntity.CAMPAIGN_ID, MessageEntity.CAMPAIGN_ID);

    sEventProjectionMap = new HashMap<>();
    sEventProjectionMap.put(DatapointEntity._ID, DatapointEntity._ID);
    sEventProjectionMap.put(DatapointEntity.GTIME, DatapointEntity.GTIME);
    sEventProjectionMap.put(DatapointEntity.DETAILS, DatapointEntity.DETAILS);

    sInAppProjectionMap = new HashMap<>();
    sInAppProjectionMap.put(InAppMessageEntity._ID, InAppMessageEntity._ID);
    sInAppProjectionMap.put(InAppMessageEntity.GTIME, InAppMessageEntity.GTIME);
    sInAppProjectionMap.put(InAppMessageEntity.MSG_CAMPAIGN_ID, InAppMessageEntity.MSG_CAMPAIGN_ID);
    sInAppProjectionMap.put(InAppMessageEntity.MSG_ALIGN_TYPE, InAppMessageEntity.MSG_ALIGN_TYPE);
    sInAppProjectionMap.put(InAppMessageEntity.MSG_INAPP_TYPE, InAppMessageEntity.MSG_INAPP_TYPE);
    sInAppProjectionMap.put(InAppMessageEntity.MSG_TTL, InAppMessageEntity.MSG_TTL);
    sInAppProjectionMap.put(InAppMessageEntity.MSG_MIN_DELAY, InAppMessageEntity.MSG_MIN_DELAY);
    sInAppProjectionMap.put(InAppMessageEntity.MSG_MAX_TIMES, InAppMessageEntity.MSG_MAX_TIMES);
    sInAppProjectionMap.put(InAppMessageEntity.MSG_SHOWN_COUNT, InAppMessageEntity.MSG_SHOWN_COUNT);
    sInAppProjectionMap.put(InAppMessageEntity.MSG_PERSISTENT, InAppMessageEntity.MSG_PERSISTENT);
    sInAppProjectionMap.put(InAppMessageEntity.MSG_PRIORITY, InAppMessageEntity.MSG_PRIORITY);
    sInAppProjectionMap.put(InAppMessageEntity.MSG_CONTEXT, InAppMessageEntity.MSG_CONTEXT);
    sInAppProjectionMap.put(InAppMessageEntity.MSG_LAST_SHOWN, InAppMessageEntity.MSG_LAST_SHOWN);
    sInAppProjectionMap.put(InAppMessageEntity.MSG_IS_CLICKED, InAppMessageEntity.MSG_IS_CLICKED);
    sInAppProjectionMap.put(InAppMessageEntity.MSG_HAS_ERRORS, InAppMessageEntity.MSG_HAS_ERRORS);
    sInAppProjectionMap.put(InAppMessageEntity.MSG_AUTODISMISS_TIME,
        InAppMessageEntity.MSG_AUTODISMISS_TIME);
    sInAppProjectionMap.put(InAppMessageEntity.MSG_CANCELABLE, InAppMessageEntity.MSG_CANCELABLE);
    sInAppProjectionMap.put(InAppMessageEntity.MSG_CONTENT, InAppMessageEntity.MSG_CONTENT);
    sInAppProjectionMap.put(InAppMessageEntity.MSG_SHOW_ONLY_IN,
        InAppMessageEntity.MSG_SHOW_ONLY_IN);
    sInAppProjectionMap.put(InAppMessageEntity.MSG_STATUS, InAppMessageEntity.MSG_STATUS);
    sInAppProjectionMap.put(InAppMessageEntity.MSG_CONTAINER_STYLE,
        InAppMessageEntity.MSG_CONTAINER_STYLE);

    sUserAttributeProjectionMap = new HashMap<>();
    sUserAttributeProjectionMap.put(UserAttributeEntity._ID, UserAttributeEntity._ID);
    sUserAttributeProjectionMap.put(UserAttributeEntity.GTIME, UserAttributeEntity.GTIME);
    sUserAttributeProjectionMap.put(UserAttributeEntity.ATTRIBUTE_NAME, UserAttributeEntity
        .ATTRIBUTE_NAME);
    sUserAttributeProjectionMap.put(UserAttributeEntity.ATTRIBUTE_VALUE, UserAttributeEntity
        .ATTRIBUTE_VALUE);

    sCampaignListProjectionMap = new HashMap<>();
    sCampaignListProjectionMap.put(CampaignListEntity._ID, CampaignListEntity._ID);
    sCampaignListProjectionMap.put(CampaignListEntity.CAMPAIGN_ID, CampaignListEntity.CAMPAIGN_ID);
    sCampaignListProjectionMap.put(CampaignListEntity.CAMPAIGN_ID_TTL,
        CampaignListEntity.CAMPAIGN_ID_TTL);

    sBatchDataProjectionMap = new HashMap<>();
    sBatchDataProjectionMap.put(BatchDataEntity._ID, BatchDataEntity._ID);
    sBatchDataProjectionMap.put(BatchDataEntity.BATCHED_DATA, BatchDataEntity.BATCHED_DATA);

    sDTProjectionMap = new HashMap<>();
    sDTProjectionMap.put(DTEntity._ID, DTEntity._ID);
    sDTProjectionMap.put(DTEntity.CAMPAIGN_ID, DTEntity.CAMPAIGN_ID);
    sDTProjectionMap.put(DTEntity.TRIGGER_EVENT_NAME, DTEntity.TRIGGER_EVENT_NAME);
    sDTProjectionMap.put(DTEntity.PAYLOAD, DTEntity.PAYLOAD);
    sDTProjectionMap.put(DTEntity.CAMPAIGN_PAYLOAD, DTEntity.CAMPAIGN_PAYLOAD);
    sDTProjectionMap.put(DTEntity.CAMPAIGN_TYPE, DTEntity.CAMPAIGN_TYPE);
    sDTProjectionMap.put(DTEntity.MAX_COUNT, DTEntity.MAX_COUNT);
    sDTProjectionMap.put(DTEntity.MINIMUM_DELAY, DTEntity.MINIMUM_DELAY);
    sDTProjectionMap.put(DTEntity.SHOULD_SHOW_OFFLINE, DTEntity.SHOULD_SHOW_OFFLINE);
    sDTProjectionMap.put(DTEntity.MAX_SYNC_DELAY_TIME, DTEntity.MAX_SYNC_DELAY_TIME);
    sDTProjectionMap.put(DTEntity.EXPIRY_TIME, DTEntity.EXPIRY_TIME);
    sDTProjectionMap.put(DTEntity.PRIORITY, DTEntity.PRIORITY);
    sDTProjectionMap.put(DTEntity.LAST_SHOW_TIME, DTEntity.LAST_SHOW_TIME);
    sDTProjectionMap.put(DTEntity.SHOW_COUNT, DTEntity.SHOW_COUNT);
    sDTProjectionMap.put(DTEntity.LAST_UPDATED_TIME, DTEntity.LAST_UPDATED_TIME);
    sDTProjectionMap.put(DTEntity.STATUS, DTEntity.STATUS);
    sDTProjectionMap.put(DTEntity.SHOULD_IGNORE_DND, DTEntity.SHOULD_IGNORE_DND);
    sDTProjectionMap.put(DTEntity.DELAY_BEFORE_SHOWING_NOTIFICATION, DTEntity
        .DELAY_BEFORE_SHOWING_NOTIFICATION);

    sInAppV3ProjectionMap = new HashMap<>();
    sInAppV3ProjectionMap.put(InAppV3Entity._ID, InAppV3Entity._ID);
    sInAppV3ProjectionMap.put(InAppV3Entity.CAMPAIGN_ID, InAppV3Entity.CAMPAIGN_ID);
    sInAppV3ProjectionMap.put(InAppV3Entity.CAMPAIGN_TYPE, InAppV3Entity.CAMPAIGN_TYPE);
    sInAppV3ProjectionMap.put(InAppV3Entity.CAMPAIGN_STATUS, InAppV3Entity.CAMPAIGN_STATUS);
    sInAppV3ProjectionMap.put(InAppV3Entity.CAMPAIGN_STATE, InAppV3Entity.CAMPAIGN_STATE);
    sInAppV3ProjectionMap.put(InAppV3Entity.PRIORITY, InAppV3Entity.PRIORITY);
    sInAppV3ProjectionMap.put(InAppV3Entity.LAST_UPDATED_TIME, InAppV3Entity.LAST_UPDATED_TIME);
    sInAppV3ProjectionMap.put(InAppV3Entity.TEMPLATE_TYPE, InAppV3Entity.TEMPLATE_TYPE);
    sInAppV3ProjectionMap.put(InAppV3Entity.DELETION_TIME, InAppV3Entity.DELETION_TIME);
    sInAppV3ProjectionMap.put(InAppV3Entity.LAST_RECEIVED_TIME, InAppV3Entity.LAST_RECEIVED_TIME);
    sInAppV3ProjectionMap.put(InAppV3Entity.CAMPAIGN_META, InAppV3Entity.CAMPAIGN_META);

    sAttributeCacheMap = new HashMap<>();
    sAttributeCacheMap.put(AttributeCacheEntity._ID, AttributeCacheEntity._ID);
    sAttributeCacheMap.put(AttributeCacheEntity.ATTRIBUTE_NAME,
        AttributeCacheEntity.ATTRIBUTE_NAME);
    sAttributeCacheMap.put(AttributeCacheEntity.ATTRIBUTE_VALUE,
        AttributeCacheEntity.ATTRIBUTE_VALUE);
    sAttributeCacheMap.put(AttributeCacheEntity.LAST_TRACKED_TIME,
        AttributeCacheEntity.LAST_TRACKED_TIME);
    sAttributeCacheMap.put(AttributeCacheEntity.DATA_TYPE, AttributeCacheEntity.DATA_TYPE);

    sInAppStatsMap = new HashMap<>();
    sInAppStatsMap.put(InAppStatsEntity._ID, InAppStatsEntity._ID);
    sInAppStatsMap.put(InAppStatsEntity.PAYLOAD, InAppStatsEntity.PAYLOAD);
    sInAppStatsMap.put(InAppStatsEntity.REQUEST_ID, InAppStatsEntity.REQUEST_ID);
    sInAppStatsMap.put(InAppStatsEntity.TIMESTAMP, InAppStatsEntity.TIMESTAMP);

  }

  /**
   * The database helper which is used to do all database related operations
   */
  private MoEDatabaseHelper mOpenHelper = null;

  /*
   * (non-Javadoc)
   *
   * @see android.content.ContentProvider#onCreate()
   */
  @Override public boolean onCreate() {
    mOpenHelper = new MoEDatabaseHelper(getContext());
    initializeUriMatcher();
    Logger.d("MoEProvider: Provider created");
    return true;
  }

  private void initializeUriMatcher() {
    sUriMatcher = new UriMatcher(UriMatcher.NO_MATCH);
    Context context = getContext();
    sUriMatcher.addURI(MoEDataContract.getAuthority(context), "messages", MESSAGES);
    sUriMatcher.addURI(MoEDataContract.getAuthority(context), "messages/#", MESSAGE_ID);
    sUriMatcher.addURI(MoEDataContract.getAuthority(context), "datapoints", DATAPOINTS);
    sUriMatcher.addURI(MoEDataContract.getAuthority(context), "datapoints/#", DATAPOINT_ID);
    sUriMatcher.addURI(MoEDataContract.getAuthority(context), "inapps", INAPPS);
    sUriMatcher.addURI(MoEDataContract.getAuthority(context), "inapps/#", INAPP_ID);
    sUriMatcher.addURI(MoEDataContract.getAuthority(context), "userattributes/", USER_ATTRIBUTES);
    sUriMatcher.addURI(MoEDataContract.getAuthority(context), "userattributes/#",
        USER_ATTRIBUTES_ID);
    sUriMatcher.addURI(MoEDataContract.getAuthority(context), "campaignlist/", CAMPAIGN_IDS);
    sUriMatcher.addURI(MoEDataContract.getAuthority(context), "campaignlist/#", CAMPAIGN_ID);
    sUriMatcher.addURI(MoEDataContract.getAuthority(context), "batchdata/", DATA_BATCHES);
    sUriMatcher.addURI(MoEDataContract.getAuthority(context), "batchdata/#", DATA_BATCH);
    sUriMatcher.addURI(MoEDataContract.getAuthority(context), "dtcampaign", DEVICE_TRIGGERS);
    sUriMatcher.addURI(MoEDataContract.getAuthority(context), "dtcampaign/#", DEVICE_TRIGGER);
    sUriMatcher.addURI(MoEDataContract.getAuthority(context), "inappv3", INAPPV3_CAMPAIGNS);
    sUriMatcher.addURI(MoEDataContract.getAuthority(context), "inappv3/#", INAPPV3_CAMPAIGN);
    sUriMatcher.addURI(MoEDataContract.getAuthority(context), "attributecache/", ATTRIBUTE_CACHE);
    sUriMatcher.addURI(MoEDataContract.getAuthority(context), "attributecache/#",
        ATTRIBUTE_CACHE_ID);
    sUriMatcher.addURI(MoEDataContract.getAuthority(context), "inappstats", INAPP_STATS);
    sUriMatcher.addURI(MoEDataContract.getAuthority(context), "inappstats/#", INAPP_STAT);
  }

  /*
   * (non-Javadoc)
   *
   * @see android.content.ContentProvider#getType(android.net.Uri)
   */
  @Override public String getType(@NonNull Uri uri) {
    switch (sUriMatcher.match(uri)) {
      case MESSAGES:
        return MessageEntity.CONTENT_TYPE;
      case MESSAGE_ID:
        return MessageEntity.CONTENT_ITEM_TYPE;
      case DATAPOINTS:
        return DatapointEntity.CONTENT_TYPE;
      case DATAPOINT_ID:
        return DatapointEntity.CONTENT_ITEM_TYPE;
      case INAPPS:
        return InAppMessageEntity.CONTENT_TYPE;
      case INAPP_ID:
        return InAppMessageEntity.CONTENT_ITEM_TYPE;
      case USER_ATTRIBUTES:
        return UserAttributeEntity.CONTENT_TYPE;
      case USER_ATTRIBUTES_ID:
        return UserAttributeEntity.CONTENT_ITEM_TYPE;
      case CAMPAIGN_IDS:
        return CampaignListEntity.CONTENT_TYPE;
      case CAMPAIGN_ID:
        return CampaignListEntity.CONTENT_ITEM_TYPE;
      case DATA_BATCHES:
        return BatchDataEntity.CONTENT_TYPE;
      case DATA_BATCH:
        return BatchDataEntity.CONTENT_ITEM_TYPE;
      case DEVICE_TRIGGERS:
        return DTEntity.CONTENT_TYPE;
      case DEVICE_TRIGGER:
        return DTEntity.CONTENT_ITEM_TYPE;
      case INAPPV3_CAMPAIGNS:
        return InAppV3Entity.CONTENT_TYPE;
      case INAPPV3_CAMPAIGN:
        return InAppV3Entity.CONTENT_ITEM_TYPE;
      case ATTRIBUTE_CACHE:
        return AttributeCacheEntity.CONTENT_TYPE;
      case ATTRIBUTE_CACHE_ID:
        return AttributeCacheEntity.CONTENT_ITEM_TYPE;
      case INAPP_STATS:
        return InAppStatsEntity.CONTENT_TYPE;
      case INAPP_STAT:
        return InAppStatsEntity.CONTENT_ITEM_TYPE;
      default:
        Logger.f("No Matching URI found");
        return null;
    }
  }

  public Cursor query(@NonNull Uri uri, String[] projection, String selection,
      String[] selectionArgs, String sortOrder) {
    // Get the database and run the query
    SQLiteDatabase db = mOpenHelper.getReadableDatabase();
    updateIfRequired(db);
    SQLiteQueryBuilder qb = new SQLiteQueryBuilder();
    // If no sort order is specified use the default
    String orderBy = sortOrder;
    String limit = uri.getQueryParameter(MoEDataContract.QUERY_PARAMETER_LIMIT);
    switch (sUriMatcher.match(uri)) {
      case MESSAGE_ID:
        qb.appendWhere(MessageEntity._ID + "=" + uri.getPathSegments().get(1));
      case MESSAGES:
        qb.setProjectionMap(sMessageProjectionMap);
        qb.setTables(MoEDatabaseHelper.TABLE_NAME_MSGS);
        if (TextUtils.isEmpty(sortOrder)) {
          orderBy = MessageEntity.DEFAULT_SORT_ORDER;
        }
        break;
      case DATAPOINT_ID:
        qb.appendWhere(DatapointEntity._ID + "=" + uri.getPathSegments().get(1));
      case DATAPOINTS:
        qb.setProjectionMap(sEventProjectionMap);
        qb.setTables(MoEDatabaseHelper.TABLE_NAME_DATAPOINTS);
        break;
      case INAPP_ID:
        qb.appendWhere(InAppMessageEntity._ID + "=" + uri.getPathSegments().get(1));
      case INAPPS:
        qb.setProjectionMap(sInAppProjectionMap);
        qb.setTables(MoEDatabaseHelper.TABLE_NAME_INAPPS);
        if (TextUtils.isEmpty(sortOrder)) {
          orderBy = InAppMessageEntity.DEFAULT_SORT_ORDER;
        }
        break;
      case USER_ATTRIBUTES:
        qb.setProjectionMap(sUserAttributeProjectionMap);
        qb.setTables(MoEDatabaseHelper.TABLE_NAME_USER_ATTRIBUTES);
        break;
      case CAMPAIGN_IDS:
        qb.setProjectionMap(sCampaignListProjectionMap);
        qb.setTables(MoEDatabaseHelper.TABLE_NAME_CAMPAIGN_LIST);
        break;
      case DATA_BATCHES:
        qb.setProjectionMap(sBatchDataProjectionMap);
        qb.setTables(MoEDatabaseHelper.TABLE_NAME_BATCH_DATA);
        break;
      case DEVICE_TRIGGERS:
        qb.setProjectionMap(sDTProjectionMap);
        qb.setTables(MoEDatabaseHelper.TABLE_NAME_DEVICE_TRIGGERS);
        break;
      case INAPPV3_CAMPAIGNS:
        qb.setProjectionMap(sInAppV3ProjectionMap);
        qb.setTables(MoEDatabaseHelper.TABLE_NAME_INAPP_V3);
        break;
      case ATTRIBUTE_CACHE:
        qb.setProjectionMap(sAttributeCacheMap);
        qb.setTables(MoEDatabaseHelper.TABLE_NAME_ATTRIBUTE_CACHE);
        break;
      case INAPP_STATS:
        qb.setProjectionMap(sInAppStatsMap);
        qb.setTables(MoEDatabaseHelper.TABLE_NAME_INAPP_STATS);
        break;
      default:
        Logger.f("Unknown URI query() " + uri);
    }
    Cursor c = null;
    try {
      c = qb.query(db, projection, selection, selectionArgs, null, null, orderBy, limit);
    } catch (Exception e) {
      Logger.e(TAG + " query() : Exception: ", e);
    }
    // Tell the cursor what uri to watch, so it knows when its source data
    // changes
    return c;
  }

  public Uri insert(Uri uri, ContentValues values) {
    Uri newUri = null;
    try {
      if (null == values) return null;
      SQLiteDatabase db = mOpenHelper.getWritableDatabase();
      updateIfRequired(db);
      long rowId = 0;
      newUri = null;
      switch (sUriMatcher.match(uri)) {
        case MESSAGES:
          rowId = db.insert(MoEDatabaseHelper.TABLE_NAME_MSGS, null, values);
          if (rowId > 0) {
            newUri = ContentUris.withAppendedId(MessageEntity.getContentUri(getContext()), rowId);
          }
          break;
        case DATAPOINTS:
          rowId = db.insert(MoEDatabaseHelper.TABLE_NAME_DATAPOINTS, null, values);
          if (rowId > 0) {
            newUri = ContentUris.withAppendedId(DatapointEntity.getContentUri(getContext()), rowId);
          }
          break;
        case INAPPS:
          rowId = db.insert(MoEDatabaseHelper.TABLE_NAME_INAPPS, null, values);
          if (rowId > 0) {
            newUri =
                ContentUris.withAppendedId(InAppMessageEntity.getContentUri(getContext()), rowId);
          }
          break;
        case USER_ATTRIBUTES:
          rowId = db.insert(MoEDatabaseHelper.TABLE_NAME_USER_ATTRIBUTES, null, values);
          if (rowId > 0) {
            newUri = ContentUris.withAppendedId(UserAttributeEntity.getContentUri(getContext()),
                rowId);
          }
          break;
        case CAMPAIGN_IDS:
          rowId = db.insert(MoEDatabaseHelper.TABLE_NAME_CAMPAIGN_LIST, null, values);
          if (rowId > 0) {
            newUri =
                ContentUris.withAppendedId(UserAttributeEntity.getContentUri(getContext()), rowId);
          }
          break;
        case DATA_BATCHES:
          rowId = db.insert(MoEDatabaseHelper.TABLE_NAME_BATCH_DATA, null, values);
          if (rowId > 0) {
            newUri = ContentUris.withAppendedId(BatchDataEntity.getContentUri(getContext()), rowId);
          }
          break;
        case DEVICE_TRIGGERS:
          rowId = db.insert(MoEDatabaseHelper.TABLE_NAME_DEVICE_TRIGGERS, null, values);
          if (rowId > 0) {
            newUri = ContentUris.withAppendedId(DTEntity.getContentUri(getContext()), rowId);
          }
          break;
        case ATTRIBUTE_CACHE:
          rowId = db.insert(MoEDatabaseHelper.TABLE_NAME_ATTRIBUTE_CACHE, null, values);
          if (rowId > 0) {
            newUri =
                ContentUris.withAppendedId(AttributeCacheEntity.getContentUri(getContext()), rowId);
          }
          break;
        case INAPPV3_CAMPAIGNS:
          rowId = db.insert(MoEDatabaseHelper.TABLE_NAME_INAPP_V3, null, values);
          if (rowId > 0) {
            newUri = ContentUris.withAppendedId(InAppV3Entity.getContentUri(getContext()), rowId);
          }
          break;
        case INAPP_STATS:
          rowId = db.insert(MoEDatabaseHelper.TABLE_NAME_INAPP_STATS, null, values);
          if (rowId > 0) {
            newUri =
                ContentUris.withAppendedId(InAppStatsEntity.getContentUri(getContext()), rowId);
          }
          break;
        default:
          Logger.f("Unknown URI " + uri);
      }
      if (null != newUri) {
        Logger.v("MoEProvider: Added new record : " + newUri.toString());
        getContext().getContentResolver().notifyChange(uri, null);
      } else {
        Logger.f("MoEProvider: Failed to add new record");
      }
    } catch (Exception e) {
      Logger.e(TAG + " insert() : ", e);
    }
    return newUri;
  }

  public void updateIfRequired(SQLiteDatabase db) {
    if (MoEConstants.dbUpdateRequired) {
      mOpenHelper.addMSGTagIfRequiredInbox(db);
      mOpenHelper.addUserAttributesTableIfRequired(db);
      mOpenHelper.addCampaignListTableIfRequired(db);
      mOpenHelper.addBatchDataTableIfRequired(db);
      mOpenHelper.addDeviceTriggerTableIfRequired(db);
      mOpenHelper.addInAppV3TableIfRequired(db);
      mOpenHelper.addAttributeCacheTableIfRequired(db);
      mOpenHelper.addInAppStatsTableIfRequired(db);
      mOpenHelper.addCampaignIdToMessageTable(db);
      MoEConstants.dbUpdateRequired = false;
    }
  }


  @Override @NonNull public ContentProviderResult[] applyBatch(
      @NonNull ArrayList<ContentProviderOperation> operations)
      throws OperationApplicationException {
    ContentProviderResult[] result = new ContentProviderResult[operations.size()];
    int i = 0;
    // Opens the database object in "write" mode.
    SQLiteDatabase db = mOpenHelper.getWritableDatabase();
    // Begin a transaction
    updateIfRequired(db);
    db.beginTransaction();
    try {
      for (ContentProviderOperation operation : operations) {
        // Chain the result for back references
        result[i++] = operation.apply(this, result, i);
      }
      db.setTransactionSuccessful();
    } catch (OperationApplicationException e) {
      Logger.f("MoEProvider : batch failed: ", e);
    } catch (Exception e) {
      Logger.f("MoEProvider : batch failed: ", e);
    } finally {
      db.endTransaction();
    }
    return result;
  }

  /*
   * (non-Javadoc)
   *
   * @see android.content.ContentProvider#delete(android.net.Uri,
   * java.lang.String, java.lang.String[])
   */
  public int delete(Uri uri, String selection, String[] selectionArgs) {
    int count = 0;
    try {
      if (null == uri) return 0;
      SQLiteDatabase db = mOpenHelper.getWritableDatabase();
      updateIfRequired(db);
      switch (sUriMatcher.match(uri)) {
        case MESSAGES:
          count = db.delete(MoEDatabaseHelper.TABLE_NAME_MSGS, selection, selectionArgs);
          break;
        case MESSAGE_ID:
          String noteId = uri.getPathSegments().get(1);
          count = db.delete(MoEDatabaseHelper.TABLE_NAME_MSGS,
              MessageEntity._ID + "=" + noteId + (!TextUtils.isEmpty(selection) ? " AND "
                  + selection
                  : ""), selectionArgs);
          break;
        case DATAPOINTS:
          count = db.delete(MoEDatabaseHelper.TABLE_NAME_DATAPOINTS, selection, selectionArgs);
          break;
        case DATAPOINT_ID:
          String eventId = uri.getPathSegments().get(1);
          count = db.delete(MoEDatabaseHelper.TABLE_NAME_DATAPOINTS,
              DatapointEntity._ID + " = " + eventId + (!TextUtils.isEmpty(selection) ? " AND "
                  + selection : ""), selectionArgs);
          break;
        case INAPPS:
          count = db.delete(MoEDatabaseHelper.TABLE_NAME_INAPPS, selection, selectionArgs);
          break;
        case INAPP_ID:
          String inappId = uri.getPathSegments().get(1);
          count = db.delete(MoEDatabaseHelper.TABLE_NAME_INAPPS,
              DatapointEntity._ID + "=" + inappId + (!TextUtils.isEmpty(selection) ? " AND "
                  + selection : ""), selectionArgs);
          break;
        case USER_ATTRIBUTES:
          count = db.delete(MoEDatabaseHelper.TABLE_NAME_USER_ATTRIBUTES, selection, selectionArgs);
          break;
        case USER_ATTRIBUTES_ID:
          String attributeId = uri.getPathSegments().get(1);
          count = db.delete(MoEDatabaseHelper.TABLE_NAME_USER_ATTRIBUTES,
              UserAttributeEntity._ID + "=" + attributeId + (!TextUtils.isEmpty(selection) ? " AND "
                  + selection : ""), selectionArgs);
          break;
        case CAMPAIGN_IDS:
          count = db.delete(MoEDatabaseHelper.TABLE_NAME_CAMPAIGN_LIST, selection, selectionArgs);
          break;
        case CAMPAIGN_ID:
          String campaignId = uri.getPathSegments().get(1);
          count = db.delete(MoEDatabaseHelper.TABLE_NAME_CAMPAIGN_LIST,
              CampaignListEntity._ID + "=" + campaignId + (!TextUtils.isEmpty(selection) ? " AND "
                  + selection : ""), selectionArgs);
          break;
        case DATA_BATCHES:
          count = db.delete(MoEDatabaseHelper.TABLE_NAME_BATCH_DATA, selection, selectionArgs);
          break;
        case DATA_BATCH:
          String batchId = uri.getPathSegments().get(1);
          count = db.delete(MoEDatabaseHelper.TABLE_NAME_BATCH_DATA,
              BatchDataEntity._ID + "=" + batchId + (!TextUtils.isEmpty(selection) ? " AND "
                  + selection : ""), selectionArgs);
          break;
        case DEVICE_TRIGGERS:
          count = db.delete(MoEDatabaseHelper.TABLE_NAME_DEVICE_TRIGGERS, selection, selectionArgs);
          break;
        case DEVICE_TRIGGER:
          String triggerId = uri.getPathSegments().get(1);
          count = db.delete(MoEDatabaseHelper.TABLE_NAME_DEVICE_TRIGGERS,
              DTEntity._ID + "=" + triggerId + (!TextUtils.isEmpty(selection) ? " AND "
                  + selection : ""), selectionArgs);
          break;
        case ATTRIBUTE_CACHE:
          count = db.delete(MoEDatabaseHelper.TABLE_NAME_ATTRIBUTE_CACHE, selection, selectionArgs);
          break;
        case ATTRIBUTE_CACHE_ID:
          String cachedAttributeId = uri.getPathSegments().get(1);
          count = db.delete(MoEDatabaseHelper.TABLE_NAME_ATTRIBUTE_CACHE,
              AttributeCacheEntity._ID + "=" + cachedAttributeId + (!TextUtils.isEmpty(selection) ?
                  " AND "
                      + selection : ""), selectionArgs);
          break;
        case INAPPV3_CAMPAIGNS:
          count = db.delete(MoEDatabaseHelper.TABLE_NAME_INAPP_V3, selection, selectionArgs);
          break;
        case INAPPV3_CAMPAIGN:
          String inAppCamapignId = uri.getPathSegments().get(1);
          count = db.delete(MoEDatabaseHelper.TABLE_NAME_INAPP_V3,
              InAppV3Entity._ID + "=" + inAppCamapignId + (!TextUtils.isEmpty(selection) ? " AND "
                  + selection
                  : ""), selectionArgs);
          break;
        case INAPP_STATS:
          count = db.delete(MoEDatabaseHelper.TABLE_NAME_INAPP_STATS, selection, selectionArgs);
          break;
        case INAPP_STAT:
          String statId = uri.getPathSegments().get(1);
          count = db.delete(MoEDatabaseHelper.TABLE_NAME_INAPP_STATS,
              InAppStatsEntity._ID + "=" + statId + (!TextUtils.isEmpty(selection) ?
                  " AND "
                      + selection : ""), selectionArgs);
          break;
        default:
          Logger.f("Unknown URI " + uri);
      }
      getContext().getContentResolver().notifyChange(uri, null);
      Logger.v("MoEProvider: Deleted " + count + " record(s) for URI: " + uri.toString());
    } catch (Exception e) {
      Logger.e(TAG + " delete() : ", e);
    }
    return count;
  }

  /*
   * (non-Javadoc)
   *
   * @see android.content.ContentProvider#update(android.net.Uri,
   * android.content.ContentValues, java.lang.String, java.lang.String[])
   */
  public int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
    int count = 0;
    try {
      SQLiteDatabase db = mOpenHelper.getWritableDatabase();
      updateIfRequired(db);
      switch (sUriMatcher.match(uri)) {
        case MESSAGES:
          count = db.update(MoEDatabaseHelper.TABLE_NAME_MSGS, values, selection, selectionArgs);
          break;
        case MESSAGE_ID:
          String msgId = uri.getPathSegments().get(1);
          count = db.update(MoEDatabaseHelper.TABLE_NAME_MSGS, values,
              DatapointEntity._ID + "=" + msgId + (!TextUtils.isEmpty(selection) ? " AND "
                  + selection
                  : ""), selectionArgs);
          break;
        case DATAPOINTS:
          count =
              db.update(MoEDatabaseHelper.TABLE_NAME_DATAPOINTS, values, selection, selectionArgs);
          break;
        case DATAPOINT_ID:
          String eventId = uri.getPathSegments().get(1);
          count = db.update(MoEDatabaseHelper.TABLE_NAME_DATAPOINTS, values,
              DatapointEntity._ID + "=" + eventId + (!TextUtils.isEmpty(selection) ? " AND "
                  + selection : ""), selectionArgs);
          break;
        case INAPPS:
          count = db.update(MoEDatabaseHelper.TABLE_NAME_INAPPS, values, selection, selectionArgs);
          break;
        case INAPP_ID:
          String inAppId = uri.getPathSegments().get(1);
          count = db.update(MoEDatabaseHelper.TABLE_NAME_INAPPS, values,
              InAppMessageEntity._ID + "=" + inAppId + (!TextUtils.isEmpty(selection) ? " AND "
                  + selection : ""), selectionArgs);
          break;
        case USER_ATTRIBUTES:
          count = db.update(MoEDatabaseHelper.TABLE_NAME_USER_ATTRIBUTES, values, selection,
              selectionArgs);
          break;
        case USER_ATTRIBUTES_ID:
          String attributeId = uri.getPathSegments().get(1);
          count = db.update(MoEDatabaseHelper.TABLE_NAME_USER_ATTRIBUTES, values,
              UserAttributeEntity._ID + "=" + attributeId + (!TextUtils.isEmpty(selection) ? " AND "
                  + selection : ""), selectionArgs);
          break;
        case CAMPAIGN_IDS:
          count =
              db.update(MoEDatabaseHelper.TABLE_NAME_CAMPAIGN_LIST, values, selection,
                  selectionArgs);
          break;
        case CAMPAIGN_ID:
          String campaignId = uri.getPathSegments().get(1);
          count = db.update(MoEDatabaseHelper.TABLE_NAME_CAMPAIGN_LIST, values,
              CampaignListEntity._ID + "=" + campaignId + (!TextUtils.isEmpty(selection) ? " AND "
                  + selection : ""), selectionArgs);
          break;
        case DATA_BATCHES:
          count =
              db.update(MoEDatabaseHelper.TABLE_NAME_BATCH_DATA, values, selection, selectionArgs);
          break;
        case DATA_BATCH:
          String batchId = uri.getPathSegments().get(1);
          count = db.update(MoEDatabaseHelper.TABLE_NAME_BATCH_DATA, values,
              BatchDataEntity._ID + "=" + batchId + (!TextUtils.isEmpty(selection) ? " AND "
                  + selection : ""), selectionArgs);
          break;
        case DEVICE_TRIGGERS:
          count = db.update(MoEDatabaseHelper.TABLE_NAME_DEVICE_TRIGGERS, values, selection,
              selectionArgs);
          break;
        case DEVICE_TRIGGER:
          String triggerId = uri.getPathSegments().get(1);
          count = db.update(MoEDatabaseHelper.TABLE_NAME_DEVICE_TRIGGERS, values,
              DTEntity._ID + "=" + triggerId + (!TextUtils.isEmpty(selection) ? " AND "
                  + selection : ""), selectionArgs);
          break;
        case ATTRIBUTE_CACHE:
          count = db.update(MoEDatabaseHelper.TABLE_NAME_ATTRIBUTE_CACHE, values, selection,
              selectionArgs);
          break;
        case ATTRIBUTE_CACHE_ID:
          String cachedAttributeId = uri.getPathSegments().get(1);
          count = db.update(MoEDatabaseHelper.TABLE_NAME_ATTRIBUTE_CACHE, values,
              AttributeCacheEntity._ID + "=" + cachedAttributeId + (!TextUtils.isEmpty(selection) ?
                  " AND "
                      + selection : ""), selectionArgs);
          break;
        case INAPPV3_CAMPAIGNS:
          count =
              db.update(MoEDatabaseHelper.TABLE_NAME_INAPP_V3, values, selection, selectionArgs);
          break;
        case INAPPV3_CAMPAIGN:
          String inAppCampaignId = uri.getPathSegments().get(1);
          count = db.update(MoEDatabaseHelper.TABLE_NAME_INAPP_V3, values,
              InAppV3Entity._ID + "=" + inAppCampaignId + (!TextUtils.isEmpty(selection) ? " AND "
                  + selection : ""), selectionArgs);
          break;
        case INAPP_STATS:
          count =
              db.update(MoEDatabaseHelper.TABLE_NAME_INAPP_STATS, values, selection, selectionArgs);
          break;
        case INAPP_STAT:
          String statId = uri.getPathSegments().get(1);
          count = db.update(MoEDatabaseHelper.TABLE_NAME_INAPP_STATS, values,
              InAppStatsEntity._ID + "=" + statId + (!TextUtils.isEmpty(selection) ? " AND "
                  + selection : ""), selectionArgs);
          break;
        default:
          Logger.f("Unknown URI " + uri);
      }
      getContext().getContentResolver().notifyChange(uri, null);
      Logger.v("MoEProvider: Updated " + count + " record(s)");
    } catch (Exception e) {
      Logger.e(TAG + " update() : ", e);
    }
    return count;
  }
}
