package com.moengage.push;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import java.util.Map;

public interface PushHandler {

    /**
     * (non-JavaDoc)
     *
     * @param context Instance of the application {@link Context}
     * @return GCM token
     * <b>Note : This method should not be called from the main thread</b>
     */
    @WorkerThread String registerForPushToken(Context context);

    /**
     * (non-JavaDoc)
     *
     * Use MoEPushHelper.getInstance().handlePushPayload(Context, Map)
     */
    @Deprecated
    void handlePushPayload(Context context, Bundle extras);

    /**
     * (non-JavaDoc)
     * Starts intent service to offload task from main thread
     *
     * @param context Application Context
     * @param extra parameter which decides the task to be performed
     */
    void offLoadToWorker(Context context, String extra);


    /**
     * Set an alarm to register for push if no token is found on app open
     *
     * @param context Application context
     */
    void setPushRegistrationFallback(Context context);

    /**
     * Use MoEPushHelper.getInstance().handlePushPayload(Context, Map)
     */
    @Deprecated void handlePushPayload(Context context, Map<String, String> pushPayload);

    @Nullable @WorkerThread String getPushToken(Context context);

  }