package com.moengage.core.listeners;

/**
 * Callback listener trigger whenever the application goes to background.
 * Usage: <br>
 * Setting listener
 * <pre>
 *   <code>
 *     MoEHelper.getInstance(context).registerAppBackgroundListener(listener);
 *   </code>
 * </pre>
 * Remove Listener
 * <pre>
 *   <code>
 *     MoEHelper.getInstance(context).unregisterAppBackgroundListener()
 *   </code>
 * </pre>
 *
 * @author Umang Chamaria
 * @since 9.2.01
 */
public interface OnAppBackgroundListener {
  void goingToBackground();
}
