package com.moengage.core;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Bitmap.CompressFormat;
import android.support.annotation.NonNull;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

/**
 * @author Umang Chamaria
 */
public class MoEFileManager {

  private static final String TAG = "MoEFileManager";

  private final String FILE_PATH_SEPARATOR = "/";

  private final String MOENGAGE_SUBFOLDER = "moengage";

  private Context context;

  public MoEFileManager(Context context) {
    this.context = context;
    createBaseFolderIfRequired();
  }

  public void saveImageFile(@NonNull String directoryName,
      @NonNull String fileName, @NonNull Bitmap bitmap) {
    if (!doesDirectoryExists(directoryName)) createDirectory(directoryName);
    FileOutputStream fileOutputStream = null;
    try {
      fileOutputStream = new FileOutputStream(basePath() +
          FILE_PATH_SEPARATOR + directoryName + FILE_PATH_SEPARATOR + fileName);
      bitmap.compress(CompressFormat.PNG, 100, fileOutputStream);
    } catch (Exception e) {
      Logger.f(TAG + " saveImageFile() : ", e);
    } finally {
      try {
        if (fileOutputStream != null) {
          fileOutputStream.close();
        }
      } catch (IOException e) {
        Logger.e(TAG + " saveImageFile() : ", e);
      }
    }
  }

  public boolean doesDirectoryExists(String directoryName) {
    try {
      File file =
          new File(basePath() + FILE_PATH_SEPARATOR + directoryName);
      return file.exists();
    } catch (Exception e) {
      Logger.e(TAG + " doesDirectoryExists() : Directory with name " + directoryName + " does "
          + "not exist.");
    }
    return false;
  }

  public boolean createDirectory(String directoryName) {
    File file =
        new File(basePath() + FILE_PATH_SEPARATOR + directoryName);
    return file.mkdir();
  }

  public void deleteFolder(String folder) {
    File directory = new File(basePath() + FILE_PATH_SEPARATOR + folder);
    deleteDirectory(directory);
  }

  public boolean fileExistsInDirectory(String campaignId, String fileName) {
    File file = new File(basePath() + FILE_PATH_SEPARATOR +
        campaignId + FILE_PATH_SEPARATOR + fileName);
    return file.exists();
  }

  public String getPathForFile(String campaignId, String fileName) {
    File file = new File(basePath() + FILE_PATH_SEPARATOR +
        campaignId + FILE_PATH_SEPARATOR + fileName);
    return file.getAbsolutePath();
  }

  @NonNull private String basePath() {
    return context.getFilesDir().getAbsolutePath() + FILE_PATH_SEPARATOR + MOENGAGE_SUBFOLDER;
  }

  private void createBaseFolderIfRequired() {
    File file = new File(basePath());
    if (!file.exists()) {
      Logger.v(TAG + " createBaseFolderIfRequired() : MoEngage base folder does not exist. Will "
          + "create it.");
      file.mkdir();
    } else {
      Logger.v(TAG + " createBaseFolderIfRequired() : MoEngage base folder exists. Need not "
          + "create another one.");
    }
  }

  public void clearMoEngageFiles() {
    File file = new File(basePath());
    if (!file.exists()) return;
    if (file.isDirectory()) {
      deleteDirectory(file);
    }
  }

  private void deleteDirectory(File directory) {
    File[] fileList = directory.listFiles();
    if (fileList == null) {
      directory.delete();
      return;
    }
    for (File file : fileList) {
      if (file.isDirectory()) {
        deleteDirectory(file);
      } else {
        file.delete();
      }
    }
    directory.delete();
  }

  public File saveGif(String directoryName, String fileName, InputStream gifStream) {
    try {
      if (!doesDirectoryExists(directoryName)) createDirectory(directoryName);
      int bufferLength = 0;
      byte[] buffer = new byte[1024];
      File file =
          new File(basePath() + FILE_PATH_SEPARATOR + directoryName + FILE_PATH_SEPARATOR + fileName);
      FileOutputStream fileOutput = new FileOutputStream(file);
      while ((bufferLength = gifStream.read(buffer)) > 0) {
        fileOutput.write(buffer, 0, bufferLength);
      }
      fileOutput.close();
      return file;
    } catch (Exception e) {
      Logger.e( TAG + " saveGif() : ", e);
    }
    return null;
  }

  public File getFileByName(String directory, String fileName){
    return new File(basePath() + FILE_PATH_SEPARATOR + directory, fileName);
  }
}