/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core.remoteconfig;

import android.content.Context;
import android.text.TextUtils;
import com.moengage.core.APIManager;
import com.moengage.core.Logger;
import com.moengage.core.MoEUtils;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import com.moengage.core.remoteconfig.RemoteConfigResponseHandler;
import com.moengage.core.rest.Response;
import com.moengage.core.utils.RestUtils;
import org.json.JSONObject;

public class ConfigApiNetworkTask
extends SDKTask {
    private static final String TAG = "ConfigApiNetworkTask";

    public ConfigApiNetworkTask(Context context) {
        super(context);
    }

    @Override
    public TaskResult execute() {
        Logger.v("ConfigApiNetworkTask : executing Task");
        try {
            String appId = MoEUtils.getAppId();
            if (TextUtils.isEmpty((CharSequence)appId)) {
                Logger.e("ConfigApiNetworkTask execute(): Cannot make config api sync request without app id.");
                return this.taskResult;
            }
            JSONObject requestBody = new JSONObject();
            requestBody.put("query_params", (Object)RestUtils.getDefaultParams(this.context).build());
            Response response = APIManager.configApi(appId, requestBody);
            RemoteConfigResponseHandler handler = new RemoteConfigResponseHandler();
            boolean status = handler.handleConfigApiResponse(this.context, response);
            this.taskResult.setIsSuccess(status);
        }
        catch (Exception e) {
            Logger.f("ConfigApiNetworkTask : execute", e);
        }
        Logger.v("ConfigApiNetworkTask : execution completed");
        return this.taskResult;
    }

    @Override
    public String getTaskTag() {
        return "SYNC_CONFIG";
    }

    @Override
    public boolean isSynchronous() {
        return true;
    }
}

