/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core;

import android.content.Context;
import android.net.Uri;
import android.support.annotation.Nullable;
import com.moe.pushlibrary.exceptions.SDKNotInitializedException;
import com.moengage.core.Logger;
import com.moengage.core.MoEUtils;
import com.moengage.core.SdkConfig;
import com.moengage.core.model.DeRegisterIntegrationDeviceRequest;
import com.moengage.core.model.RegisterIntegrationDeviceRequest;
import com.moengage.core.model.RemoteConfig;
import com.moengage.core.rest.Request;
import com.moengage.core.rest.RequestBuilder;
import com.moengage.core.rest.Response;
import com.moengage.core.rest.RestClient;
import com.moengage.core.rest.exceptions.UTF8EncodingException;
import com.moengage.core.utils.JsonBuilder;
import com.moengage.core.utils.RestUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONException;
import org.json.JSONObject;

public final class APIManager {
    private APIManager() {
    }

    static void uploadLogsToLogEntries(String api, JSONObject jsonObject) {
        try {
            URL url = new URL(api);
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)url.openConnection();
            httpsURLConnection.setDoOutput(true);
            httpsURLConnection.setRequestProperty("Accept-Charset", "UTF-8");
            httpsURLConnection.setRequestProperty("Content-type", "application/json");
            OutputStream output = httpsURLConnection.getOutputStream();
            output.write(jsonObject.toString().getBytes("UTF-8"));
            output.close();
            Logger.v("API Manager : uploadLogsToLogEntries : response" + httpsURLConnection.getResponseCode());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Nullable
    public static Response deviceTriggerSyncRequest(Context context, String path, HashMap<String, String> paramsMap, JSONObject requestBody) {
        try {
            if (!RemoteConfig.getConfig().isRealTimeTriggerEnabled || !RemoteConfig.getConfig().isAppEnabled || MoEUtils.isEmptyString(SdkConfig.getConfig().appId)) {
                return null;
            }
            Uri.Builder uriBuilder = RestUtils.getBaseUriBuilder().appendEncodedPath(path);
            RequestBuilder requestBuilder = RestUtils.getBaseRequestBuilder(uriBuilder.build(), RequestBuilder.RequestType.POST, MoEUtils.getAppId());
            JsonBuilder queryParams = RestUtils.getDefaultParams(context);
            queryParams.putString("device_tz", TimeZone.getDefault().getID());
            if (paramsMap != null) {
                for (Map.Entry<String, String> entry : paramsMap.entrySet()) {
                    queryParams.putString(entry.getKey(), entry.getValue());
                }
            }
            if (requestBody == null) {
                requestBody = new JSONObject();
            }
            requestBody.put("query_params", (Object)queryParams.build());
            requestBuilder.addBody(requestBody);
            RestClient restClient = new RestClient(requestBuilder.build());
            return restClient.executeRequest();
        }
        catch (Exception e) {
            Logger.f("MoERestClient: deviceTriggerSyncRequest() : Exception ", e);
            return null;
        }
    }

    static boolean isHttpStatusOk(int responseCode) {
        return 200 == responseCode;
    }

    @Nullable
    static Response reportAdd(String appId, String path, String requestId, JSONObject body) throws IOException, SDKNotInitializedException {
        Uri.Builder uriBuilder = RestUtils.getBaseUriBuilder().appendEncodedPath(path);
        RequestBuilder requestBuilder = RestUtils.getBaseRequestBuilder(uriBuilder.build(), RequestBuilder.RequestType.POST, appId).addHeader("MOE-REQUEST-ID", requestId).addBody(body);
        RestClient restClient = new RestClient(requestBuilder.build());
        return restClient.executeRequest();
    }

    @Nullable
    public static Response configApi(String appId, JSONObject requestBody) throws IOException, SDKNotInitializedException {
        Uri.Builder uriBuilder = RestUtils.getBaseUriBuilder().appendEncodedPath("v3/sdkconfig/android/").appendEncodedPath(appId);
        Request request = RestUtils.getBaseRequestBuilder(uriBuilder.build(), RequestBuilder.RequestType.POST, appId).addBody(requestBody).build();
        RestClient restClient = new RestClient(request);
        return restClient.executeRequest();
    }

    public static Response deviceAdd(String appId, JSONObject requestBody, String requestId) throws SDKNotInitializedException, UTF8EncodingException {
        Uri.Builder uriBuilder = RestUtils.getBaseUriBuilder().appendEncodedPath("v2/sdk/device").appendPath(appId);
        RequestBuilder requestBuilder = RestUtils.getBaseRequestBuilder(uriBuilder.build(), RequestBuilder.RequestType.POST, appId).addBody(requestBody).addHeader("MOE-REQUEST-ID", requestId);
        RestClient restClient = new RestClient(requestBuilder.build());
        return restClient.executeRequest();
    }

    static Response registerIntegrationDevice(RegisterIntegrationDeviceRequest request) throws JSONException, SDKNotInitializedException, UTF8EncodingException {
        Uri.Builder uriBuilder = RestUtils.getBaseUriBuilder().appendEncodedPath("integration/register_device");
        request.defaultParams.putString("lat", String.valueOf(request.location.latitude)).putString("lng", String.valueOf(request.location.longitude)).putString("manufacturer", request.manufacturer).putString("push_id", request.pushId).putString("model", request.model);
        JSONObject requestBody = new JSONObject();
        requestBody.put("query_params", (Object)request.defaultParams.build());
        RequestBuilder requestBuilder = RestUtils.getBaseRequestBuilder(uriBuilder.build(), RequestBuilder.RequestType.POST, request.appId).addBody(requestBody);
        RestClient restClient = new RestClient(requestBuilder.build());
        return restClient.executeRequest();
    }

    static Response deRegisterIntegrationDevice(DeRegisterIntegrationDeviceRequest request) throws JSONException, SDKNotInitializedException, UTF8EncodingException {
        Uri.Builder uriBuilder = RestUtils.getBaseUriBuilder().appendEncodedPath("integration/unregister_device");
        JSONObject requestBody = new JSONObject();
        requestBody.put("query_params", (Object)request.defaultParams.build());
        RequestBuilder requestBuilder = RestUtils.getBaseRequestBuilder(uriBuilder.build(), RequestBuilder.RequestType.POST, request.appId).addBody(requestBody);
        RestClient restClient = new RestClient(requestBuilder.build());
        return restClient.executeRequest();
    }
}

