package com.moengage.core;

import android.content.Context;
import com.moe.pushlibrary.providers.MoEDataContract;
import com.moe.pushlibrary.providers.MoEDataContract.UserAttributeEntity;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import com.moengage.location.GeoManager;

/**
 * Called when the end user opts-out of data tracking.
 * Flushes out user attributes, events
 *
 * @author Umang Chamaria
 */
class DataTrackingOptOutTask extends SDKTask{

  DataTrackingOptOutTask(Context context) {
    super(context);
  }

  @Override public TaskResult execute() {
    MoEDAO.getInstance(context).deleteAllEvents();
    MoEDAO.getInstance(context).deleteAllBatches();
    context.getContentResolver()
        .delete(MoEDataContract.UserAttributeEntity.getContentUri(context), UserAttributeEntity
                .ATTRIBUTE_NAME + " != ?", new String[]{"APP_UUID"});
    GeoManager.getInstance().removeGeoFences(context);
    return null;
  }

  @Override public String getTaskTag() {
    return TAG_DATA_TRACKING_OPT_OUT_TASK;
  }

  @Override public boolean isSynchronous() {
    return true;
  }
}
