/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core.utils;

import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import com.moe.pushlibrary.exceptions.SDKNotInitializedException;
import com.moengage.core.AdvertisingIdClient;
import com.moengage.core.ConfigurationCache;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.MoEUtils;
import com.moengage.core.SdkConfig;
import com.moengage.core.model.BaseRequest;
import com.moengage.core.rest.RequestBuilder;
import com.moengage.core.utils.JsonBuilder;
import java.util.TimeZone;
import org.json.JSONException;

public class RestUtils {
    public static String getAuthority() {
        switch (SdkConfig.getConfig().dataRegion) {
            case REGION_EU: {
                return "apiv2eu.moengage.com";
            }
            case REGION_INDIA: {
                return "apiv2mumbai.moengage.com";
            }
        }
        return "apiv2.moengage.com";
    }

    public static RequestBuilder getBaseRequestBuilder(Uri uri, RequestBuilder.RequestType requestType, String appId) throws SDKNotInitializedException {
        if (TextUtils.isEmpty((CharSequence)appId)) {
            throw new SDKNotInitializedException("App ID has not been set");
        }
        return new RequestBuilder(uri, requestType).addHeader("MOE-APPKEY", appId);
    }

    public static JsonBuilder getDefaultParams(Context context) throws JSONException {
        JsonBuilder params = new JsonBuilder();
        ConfigurationProvider provider = ConfigurationProvider.getInstance(context);
        long currentTime = MoEUtils.currentTime();
        params.putString("os", "ANDROID").putString("app_id", MoEUtils.getAppId()).putString("sdk_ver", String.valueOf(10001)).putString("unique_id", provider.getCurrentUserId()).putString("device_ts", String.valueOf(currentTime)).putString("device_tz_offset", String.valueOf(TimeZone.getDefault().getOffset(currentTime))).putString("app_ver", Integer.toString(provider.getAppVersion()));
        String integrationType = ConfigurationCache.getInstance().getIntegrationType();
        String integrationVersion = ConfigurationCache.getInstance().getIntegrationVersion();
        if (!MoEUtils.isEmptyString(integrationType) && !MoEUtils.isEmptyString(integrationVersion)) {
            params.putString("integration_type", integrationType).putString("integration_version", integrationVersion);
        }
        if (!provider.isDataTrackingOptedOut()) {
            params.putString("app_version_name", provider.getAppVersionName());
            if (!SdkConfig.getConfig().isGaidTrackingOptedOut) {
                AdvertisingIdClient.AdInfo adInfo;
                String gaid = provider.getStoredGAID();
                if (TextUtils.isEmpty((CharSequence)gaid) && (adInfo = MoEUtils.getAdvertisementInfo(context)) != null) {
                    gaid = adInfo.getId();
                    provider.storeGAID(gaid);
                }
                if (!TextUtils.isEmpty((CharSequence)gaid)) {
                    params.putString("moe_gaid", gaid);
                }
            }
        }
        params.putString("moe_push_ser", provider.getPushService());
        return params;
    }

    public static Uri.Builder getBaseUriBuilder() {
        return new Uri.Builder().scheme("https").encodedAuthority(RestUtils.getAuthority());
    }

    public static BaseRequest getBaseRequest(Context context) throws JSONException {
        return new BaseRequest(MoEUtils.getAppId(), RestUtils.getDefaultParams(context), ConfigurationProvider.getInstance(context).getCurrentUserId());
    }
}

