/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core.rest;

import android.support.annotation.Nullable;
import com.moengage.core.Logger;
import com.moengage.core.rest.Request;
import com.moengage.core.rest.RequestBuilder;
import com.moengage.core.rest.Response;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONObject;

public class RestClient {
    private static final String TAG = "RestClient";
    private Request request;
    private String path;
    private static final String ENCODING_CHARSET_UTF8 = "UTF-8";
    private static final String CHARACTER_SET = "Accept-Charset";
    private static final String CONTENT_TYPE = "Content-type";

    public RestClient(Request request) {
        this.request = request;
        this.path = " " + request.uri.getEncodedPath();
    }

    @Nullable
    public Response executeRequest() {
        return this.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response execute() {
        HttpURLConnection urlConnection = null;
        Response response = null;
        try {
            String urlString = this.request.uri.toString();
            URL url = new URL(urlString);
            Logger.v(TAG + this.path + " execute(): Request url: " + urlString);
            urlConnection = "https".equals(this.request.uri.getScheme()) ? (HttpsURLConnection)url.openConnection() : (HttpURLConnection)url.openConnection();
            this.addHeaders(urlConnection, this.request.headersMap);
            this.setContentType(urlConnection, this.request.contentType);
            this.setRequestType(urlConnection, this.request.requestType);
            this.addConnectionTimeOut(urlConnection, this.request.timeOut);
            if (this.request.requestType == RequestBuilder.RequestType.POST || this.request.requestType == RequestBuilder.RequestType.PUT) {
                this.addBody(urlConnection, this.request.requestBody);
            }
            int responseCode = urlConnection.getResponseCode();
            Logger.v(TAG + this.path + " execute(): Response Code: " + responseCode);
            if (responseCode == 200) {
                String responseBody = this.convertStreamToString(urlConnection.getInputStream());
                Logger.v(TAG + this.path + " execute() : Response Body: " + responseBody);
                response = new Response(responseCode, responseBody);
            } else {
                String errorResponse = this.convertStreamToString(urlConnection.getErrorStream());
                Logger.f(TAG + this.path + " Response: API Failed:  response code :" + responseCode + "reason : " + errorResponse);
                Logger.e(TAG + this.path + " execute() : Error message: " + errorResponse);
                response = new Response(responseCode, errorResponse);
            }
        }
        catch (Exception e) {
            Logger.e(TAG + this.path + " execute() : Exception: ", e);
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
        return response;
    }

    private void addConnectionTimeOut(HttpURLConnection urlConnection, int timeOut) {
        urlConnection.setConnectTimeout(timeOut * 1000);
        urlConnection.setReadTimeout(timeOut * 1000);
    }

    private void setContentType(HttpURLConnection urlConnection, String contentType) {
        urlConnection.setRequestProperty(CONTENT_TYPE, contentType);
    }

    private void setRequestType(HttpURLConnection urlConnection, RequestBuilder.RequestType requestType) throws ProtocolException {
        urlConnection.setRequestMethod(requestType.toString());
    }

    private void addBody(HttpURLConnection urlConnection, JSONObject requestBody) throws IOException {
        urlConnection.setDoOutput(true);
        urlConnection.setRequestProperty(CHARACTER_SET, ENCODING_CHARSET_UTF8);
        urlConnection.setRequestProperty(CONTENT_TYPE, "application/json");
        OutputStream output = urlConnection.getOutputStream();
        if (requestBody != null) {
            Logger.v(TAG + this.path + " addBody(): Request Body: " + requestBody.toString());
            output.write(requestBody.toString().getBytes(ENCODING_CHARSET_UTF8));
        }
        output.close();
    }

    private void addHeaders(HttpURLConnection urlConnection, Map<String, String> headers) {
        Set<Map.Entry<String, String>> headerMap = headers.entrySet();
        for (Map.Entry<String, String> header : headerMap) {
            Logger.v(TAG + this.path + " addHeaders(): " + header.getKey() + " : " + header.getValue());
            urlConnection.addRequestProperty(header.getKey(), header.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String convertStreamToString(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return null;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line);
            }
        }
        finally {
            inputStream.close();
        }
        return stringBuilder.toString();
    }
}

