/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core.model;

import android.support.annotation.Nullable;
import com.moengage.core.Logger;
import com.moengage.core.MoEUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.json.JSONObject;

public class TrafficSource {
    private static final String TAG = "TrafficSource";
    @Nullable
    private String source;
    @Nullable
    private String medium;
    @Nullable
    private String campaignName;
    @Nullable
    private String campaignId;
    @Nullable
    private String sourceUrl;
    @Nullable
    private String content;
    @Nullable
    private String term;
    private HashMap<String, String> extras = new HashMap();
    private static final String SOURCE = "source";
    private static final String MEDIUM = "medium";
    private static final String CAMPAIGN_NAME = "campaign_name";
    private static final String CAMPAIGN_ID = "campaign_id";
    private static final String SOURCE_URL = "source_url";
    private static final String CONTENT = "content";
    private static final String TERM = "term";
    private static final String EXTRAS = "extras";

    @Nullable
    public String getSource() {
        return this.source;
    }

    public void setSource(@Nullable String source) {
        this.source = source;
    }

    @Nullable
    public String getMedium() {
        return this.medium;
    }

    public void setMedium(@Nullable String medium) {
        this.medium = medium;
    }

    @Nullable
    public String getCampaignName() {
        return this.campaignName;
    }

    public void setCampaignName(@Nullable String campaignName) {
        this.campaignName = campaignName;
    }

    @Nullable
    public String getCampaignId() {
        return this.campaignId;
    }

    public void setCampaignId(@Nullable String campaignId) {
        this.campaignId = campaignId;
    }

    @Nullable
    public String getSourceUrl() {
        return this.sourceUrl;
    }

    public void setSourceUrl(@Nullable String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    @Nullable
    public String getContent() {
        return this.content;
    }

    public void setContent(@Nullable String content) {
        this.content = content;
    }

    @Nullable
    public String getTerm() {
        return this.term;
    }

    public void setTerm(@Nullable String term) {
        this.term = term;
    }

    public HashMap<String, String> getExtras() {
        return this.extras;
    }

    public void setExtras(HashMap<String, String> extras) {
        this.extras = extras;
    }

    @Nullable
    public static JSONObject toJson(TrafficSource source) {
        try {
            if (source == null) {
                return null;
            }
            JSONObject jsonObject = new JSONObject();
            if (source.getSource() != null) {
                jsonObject.put(SOURCE, (Object)source.getSource());
            }
            if (source.getMedium() != null) {
                jsonObject.put(MEDIUM, (Object)source.getMedium());
            }
            if (source.getCampaignName() != null) {
                jsonObject.put(CAMPAIGN_NAME, (Object)source.getCampaignName());
            }
            if (source.getCampaignId() != null) {
                jsonObject.put(CAMPAIGN_ID, (Object)source.getCampaignId());
            }
            if (source.getSourceUrl() != null) {
                jsonObject.put(SOURCE_URL, (Object)source.getSourceUrl());
            }
            if (source.getContent() != null) {
                jsonObject.put(CONTENT, (Object)source.getContent());
            }
            if (source.getTerm() != null) {
                jsonObject.put(TERM, (Object)source.getTerm());
            }
            JSONObject extrasJson = new JSONObject();
            Set<Map.Entry<String, String>> entrySet = source.getExtras().entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                extrasJson.put(entry.getKey(), (Object)entry.getValue());
            }
            if (extrasJson.length() > 0) {
                jsonObject.put(EXTRAS, (Object)extrasJson);
            }
            return jsonObject;
        }
        catch (Exception e) {
            Logger.e("TrafficSource toJson() : Exception ", e);
            return null;
        }
    }

    public static boolean isEmpty(TrafficSource source) {
        if (source == null) {
            return true;
        }
        return MoEUtils.isEmptyString(source.getSource()) && MoEUtils.isEmptyString(source.getMedium()) && MoEUtils.isEmptyString(source.getCampaignName()) && MoEUtils.isEmptyString(source.getCampaignId()) && MoEUtils.isEmptyString(source.getContent()) && MoEUtils.isEmptyString(source.getTerm()) && source.getExtras().isEmpty();
    }

    @Nullable
    public static TrafficSource fromJson(JSONObject sourceJson) {
        try {
            TrafficSource source = new TrafficSource();
            source.setSource(sourceJson.optString(SOURCE, null));
            source.setMedium(sourceJson.optString(MEDIUM, null));
            source.setCampaignName(sourceJson.optString(CAMPAIGN_NAME, null));
            source.setCampaignId(sourceJson.optString(CAMPAIGN_ID, null));
            source.setSourceUrl(sourceJson.optString(SOURCE_URL, null));
            source.setContent(sourceJson.optString(CONTENT, null));
            source.setTerm(sourceJson.optString(TERM, null));
            if (sourceJson.has(EXTRAS)) {
                JSONObject extrasJson = sourceJson.getJSONObject(EXTRAS);
                Iterator iterator = extrasJson.keys();
                HashMap<String, String> extras = new HashMap<String, String>();
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    String value = extrasJson.getString(key);
                    extras.put(key, value);
                }
                source.setExtras(extras);
            }
            return source;
        }
        catch (Exception e) {
            Logger.e("TrafficSource fromJson() : Exception: ", e);
            return null;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrafficSource source1 = (TrafficSource)o;
        if (this.source != null ? !this.source.equals(source1.source) : source1.source != null) {
            return false;
        }
        if (this.medium != null ? !this.medium.equals(source1.medium) : source1.medium != null) {
            return false;
        }
        if (this.campaignName != null ? !this.campaignName.equals(source1.campaignName) : source1.campaignName != null) {
            return false;
        }
        if (this.campaignId != null ? !this.campaignId.equals(source1.campaignId) : source1.campaignId != null) {
            return false;
        }
        if (this.content != null ? !this.content.equals(source1.content) : source1.content != null) {
            return false;
        }
        if (this.term != null ? !this.term.equals(source1.term) : source1.term != null) {
            return false;
        }
        return this.extras.equals(source1.extras);
    }

    public String toString() {
        return "{source : '" + this.source + '\'' + ", medium : '" + this.medium + '\'' + ", campaignName : '" + this.campaignName + '\'' + ", campaignId : '" + this.campaignId + '\'' + ", sourceUrl : '" + this.sourceUrl + '\'' + ", content : '" + this.content + '\'' + ", term : '" + this.term + '\'' + ", extras : " + this.extras.toString() + '}';
    }
}

