/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core;

import android.content.Context;
import com.moengage.core.ConfigurationCache;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.Logger;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import com.moengage.core.model.RemoteConfig;
import java.util.Set;
import org.json.JSONObject;

public class LoadConfigurationFromDiskTask
extends SDKTask {
    private static final String TAG = "LoadConfigurationFromDiskTask";

    LoadConfigurationFromDiskTask(Context context) {
        super(context);
    }

    @Override
    public TaskResult execute() {
        this.loadRemoteConfigFromDisk();
        return null;
    }

    private void loadRemoteConfigFromDisk() {
        try {
            RemoteConfig storedConfig;
            String configurationString = ConfigurationProvider.getInstance(this.context).getRemoteConfiguration();
            RemoteConfig configuration = new RemoteConfig();
            if (configurationString != null && (storedConfig = RemoteConfig.fromJson(new JSONObject(configurationString))) != null) {
                configuration = storedConfig;
            }
            RemoteConfig.setRemoteConfig(configuration);
            Set<String> savedScreenNames = ConfigurationProvider.getInstance(this.context).getSentScreenNames();
            if (savedScreenNames != null) {
                ConfigurationCache.getInstance().initialiseSentScreens(savedScreenNames);
            }
            if (ConfigurationProvider.getInstance(this.context).isDebugLogEnabled()) {
                Logger.isLoggingEnabled = true;
                Logger.setLogLevel(5);
            }
        }
        catch (Exception e) {
            Logger.e("LoadConfigurationFromDiskTask loadRemoteConfigFromDisk() : Exception ", e);
        }
    }

    @Override
    public String getTaskTag() {
        return "LOAD_CONFIGURATION_FROM_DISK";
    }

    @Override
    public boolean isSynchronous() {
        return true;
    }
}

