/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core;

import android.content.Context;
import android.os.Build;
import com.moe.pushlibrary.exceptions.SDKNotInitializedException;
import com.moe.pushlibrary.models.GeoLocation;
import com.moengage.core.APIManager;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.Logger;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import com.moengage.core.model.DeRegisterIntegrationDeviceRequest;
import com.moengage.core.model.RegisterIntegrationDeviceRequest;
import com.moengage.core.rest.Response;
import com.moengage.core.rest.exceptions.UTF8EncodingException;
import com.moengage.core.utils.RestUtils;
import org.json.JSONException;

public class IntegrationVerificationNetworkCallTask
extends SDKTask {
    private TASK_TYPE task_type;

    public IntegrationVerificationNetworkCallTask(Context context, TASK_TYPE task_type) {
        super(context);
        this.task_type = task_type;
    }

    @Override
    public TaskResult execute() {
        try {
            switch (this.task_type) {
                case REGISTER_DEVICE: {
                    this.createResult(this.registerDevice());
                    break;
                }
                case UNREGISTER_DEVICE: {
                    this.createResult(this.unregisterDevice());
                    break;
                }
                default: {
                    Logger.e("IntegrationVerificationNetworkCallTask: invalid case");
                    break;
                }
            }
        }
        catch (Exception e) {
            Logger.f("IntegrationVerificationNetworkCallTask: Exception ", e);
        }
        return this.taskResult;
    }

    private Response unregisterDevice() throws JSONException, SDKNotInitializedException, UTF8EncodingException {
        return APIManager.deRegisterIntegrationDevice(new DeRegisterIntegrationDeviceRequest(RestUtils.getBaseRequest(this.context)));
    }

    private Response registerDevice() throws JSONException, SDKNotInitializedException, UTF8EncodingException {
        GeoLocation geoLocation = ConfigurationProvider.getInstance(this.context).getSavedLocation();
        if (geoLocation == null) {
            geoLocation = new GeoLocation(0.0, 0.0);
        }
        return APIManager.registerIntegrationDevice(new RegisterIntegrationDeviceRequest(RestUtils.getBaseRequest(this.context), geoLocation, Build.MANUFACTURER, ConfigurationProvider.getInstance(this.context).getFcmToken(), Build.MODEL));
    }

    @Override
    public String getTaskTag() {
        return "INTEGRATION_VERIFICATION_NETWORK_TASK";
    }

    @Override
    public boolean isSynchronous() {
        return true;
    }

    private void createResult(Response apiResponse) {
        this.taskResult.setPayload(apiResponse);
    }

    public static enum TASK_TYPE {
        REGISTER_DEVICE,
        UNREGISTER_DEVICE;

    }
}

