/*
 * Decompiled with CFR 0.152.
 */
package com.moe.pushlibrary.providers;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import com.moe.pushlibrary.utils.MoEHelperUtils;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.Logger;
import com.moengage.core.MoEUtils;
import com.moengage.core.inapp.InAppManager;
import com.moengage.core.model.DataTypes;
import com.moengage.core.model.InAppV2Meta;
import com.moengage.core.model.InAppV3Meta;
import java.util.ArrayList;
import org.json.JSONObject;

class MoEDatabaseHelper
extends SQLiteOpenHelper {
    private static final String TAG = "DatabaseHelper";
    private static final String DATABASE_NAME = "MOEInteractions";
    private static final int DATABASE_VERSION = 16;
    private Context context;
    static final String TABLE_NAME_MSGS = "MESSAGES";
    static final String TABLE_NAME_DATAPOINTS = "DATAPOINTS";
    static final String TABLE_NAME_INAPPS = "INAPPMSG";
    static final String TABLE_NAME_OLD_INAPPS = "INAPPS";
    static final String TABLE_NAME_USER_ATTRIBUTES = "USERATTRIBUTES";
    static final String TABLE_NAME_CAMPAIGN_LIST = "CAMPAIGNLIST";
    static final String TABLE_NAME_BATCH_DATA = "BATCH_DATA";
    static final String TABLE_NAME_DEVICE_TRIGGERS = "DEVICE_TRIGGERS";
    static final String TABLE_NAME_ATTRIBUTE_CACHE = "ATTRIBUTE_CACHE";
    static final String TABLE_NAME_INAPP_V3 = "INAPP_V3";
    static final String TABLE_NAME_INAPP_STATS = "INAPP_STATS";

    public MoEDatabaseHelper(Context context) {
        super(context, DATABASE_NAME, null, 16);
        this.context = context;
    }

    public void onCreate(SQLiteDatabase db) {
        String DDL_DATAPOINTS = "CREATE TABLE IF NOT EXISTS DATAPOINTS ( _id INTEGER PRIMARY KEY, gtime INTEGER, details TEXT ); ";
        this.createMessagesTable(db);
        this.createInAppTable(db);
        this.createUserAttributeTable(db);
        this.createCampaignListTable(db);
        db.execSQL(DDL_DATAPOINTS);
        this.createBatchDataTable(db);
        this.createDeviceTriggerTable(db);
        this.createAttributeCacheTableIfRequired(db);
        this.createInAppStatsTable(db);
        this.createInAppV3Table(db);
        Logger.i("DatabaseHelper: Database created");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tableExists(SQLiteDatabase db, String tableName) {
        Cursor cursor = null;
        try {
            cursor = db.rawQuery("select DISTINCT tbl_name from sqlite_master where tbl_name = '" + tableName + "'", null);
            boolean bl = cursor != null && cursor.getCount() > 0;
            return bl;
        }
        finally {
            if (null != cursor) {
                cursor.close();
            }
        }
    }

    public boolean isTableExists(SQLiteDatabase db, String tableName) {
        int count = 0;
        try {
            if (tableName == null || db == null || !db.isOpen()) {
                return false;
            }
            Cursor cursor = db.rawQuery("SELECT COUNT(*) FROM sqlite_master WHERE type = ? AND name = ?", new String[]{"table", tableName});
            if (!cursor.moveToFirst()) {
                return false;
            }
            count = cursor.getInt(0);
            cursor.close();
        }
        catch (Exception e) {
            Logger.f("DatabaseHelper: isTableExists Exception " + e.toString());
        }
        return count > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        Logger.v("DatabaseHelper: Provider upgrading DB ");
        block41: for (int upgradeTo = oldVersion + 1; upgradeTo <= newVersion; ++upgradeTo) {
            switch (upgradeTo) {
                case 3: {
                    db.beginTransaction();
                    try {
                        this.createDataPointsTable(db);
                        this.createMessagesTable(db);
                        this.createInAppTable(db);
                        this.portDataFromv2(db);
                        db.execSQL("DROP TABLE IF EXISTS moeints");
                        db.execSQL("DROP TABLE IF EXISTS moemsgs");
                        db.execSQL("DROP TABLE IF EXISTS moeinappmsgs");
                        db.setTransactionSuccessful();
                        continue block41;
                    }
                    catch (Exception e) {
                        Logger.e("DatabaseHelper: failed to port data. FROM V2.", e);
                        continue block41;
                    }
                    finally {
                        db.endTransaction();
                    }
                }
                case 4: {
                    continue block41;
                }
                case 5: {
                    db.beginTransaction();
                    try {
                        db.execSQL("DROP TABLE IF EXISTS CHATS");
                        db.setTransactionSuccessful();
                        continue block41;
                    }
                    catch (Exception e) {
                        Logger.e(": failed to port data.. FOR UBOX", e);
                        continue block41;
                    }
                    finally {
                        db.endTransaction();
                    }
                }
                case 6: {
                    db.beginTransaction();
                    try {
                        if (this.isTableExists(db, TABLE_NAME_OLD_INAPPS)) {
                            String ALTER_INAPP = " ALTER TABLE INAPPS ADD COLUMN TYPE INTEGER";
                            db.execSQL(ALTER_INAPP);
                        }
                        db.setTransactionSuccessful();
                        continue block41;
                    }
                    catch (Exception e) {
                        Logger.e("DatabaseHelper: failed to add column INAPPS", e);
                        continue block41;
                    }
                    finally {
                        db.endTransaction();
                    }
                }
                case 7: {
                    db.beginTransaction();
                    try {
                        this.createDataPointsTable(db);
                        this.populateDatapoints(db);
                        db.execSQL("DROP TABLE IF EXISTS EVENTS");
                        db.setTransactionSuccessful();
                        continue block41;
                    }
                    catch (Exception e) {
                        Logger.e("DatabaseHelper: failed to populate Datapoints ", e);
                        continue block41;
                    }
                    finally {
                        db.endTransaction();
                    }
                }
                case 8: {
                    String ALTER_INBOX;
                    db.beginTransaction();
                    try {
                        if (!this.isFieldExist(TABLE_NAME_MSGS, "msg_tag", db)) {
                            ALTER_INBOX = " ALTER TABLE MESSAGES ADD COLUMN msg_tag TEXT";
                            db.execSQL(ALTER_INBOX);
                        }
                        db.setTransactionSuccessful();
                        continue block41;
                    }
                    catch (Exception e) {
                        Logger.e("DatabaseHelper failed to add columns to MESSAGES", e);
                        continue block41;
                    }
                    finally {
                        db.endTransaction();
                    }
                }
                case 9: {
                    db.execSQL("DROP TABLE IF EXISTS INAPPS");
                    this.createInAppTable(db);
                    if (this.isFieldExist(TABLE_NAME_MSGS, "msg_tag", db)) continue block41;
                    String ALTER_INBOX = " ALTER TABLE MESSAGES ADD COLUMN msg_tag TEXT";
                    db.execSQL(ALTER_INBOX);
                    continue block41;
                }
                case 10: {
                    this.createUserAttributeTable(db);
                    continue block41;
                }
                case 11: {
                    this.createCampaignListTable(db);
                    continue block41;
                }
                case 12: {
                    this.createBatchDataTable(db);
                    continue block41;
                }
                case 13: {
                    this.createDeviceTriggerTable(db);
                    continue block41;
                }
                case 14: {
                    this.createAttributeCacheTableIfRequired(db);
                    this.portUserAttributeUniqueId(db);
                    continue block41;
                }
                case 15: {
                    this.addCampaignIdToMessageTable(db);
                    continue block41;
                }
                case 16: {
                    this.createInAppV3Table(db);
                    this.portInAppV2ToV3(db);
                    this.createInAppStatsTable(db);
                    continue block41;
                }
                default: {
                    Logger.v("DatabaseHelperFailed to upgrade from DB version" + oldVersion + "to DB version" + newVersion);
                }
            }
        }
        Logger.v("DatabaseHelper Database Upgraded");
    }

    private void createDataPointsTable(SQLiteDatabase db) {
        String DDL_DATAPOINTS = "CREATE TABLE IF NOT EXISTS DATAPOINTS ( _id INTEGER PRIMARY KEY, gtime INTEGER, details TEXT ); ";
        db.execSQL(DDL_DATAPOINTS);
    }

    private void createMessagesTable(SQLiteDatabase db) {
        String DDL_MSGS = "CREATE TABLE IF NOT EXISTS MESSAGES ( _id INTEGER PRIMARY KEY, msg TEXT, msgclicked INTEGER DEFAULT 0, msgttl INTEGER, gtime INTEGER, msg_tag TEXT, campaign_id TEXT )";
        db.execSQL(DDL_MSGS);
    }

    private void createInAppTable(SQLiteDatabase db) {
        String DDL_INAPP = "CREATE TABLE IF NOT EXISTS INAPPMSG ( _id INTEGER PRIMARY KEY, gtime INTEGER, campaign_id TEXT, align_type TEXT, inapp_type TEXT, ttl INTEGER DEFAULT 0, min_delay INTEGER DEFAULT 0, max_times INTEGER DEFAULT 0, shown_count INTEGER DEFAULT 0, persistent INTEGER DEFAULT 0, priority INTEGER DEFAULT 0, context TEXT, last_shown INTEGER DEFAULT 0, is_clicked INTEGER DEFAULT 0, has_errors INTEGER DEFAULT 0, auto_dismiss INTEGER DEFAULT 0, cancelable INTEGER DEFAULT 0, content TEXT, show_only_in TEXT, status TEXT, dim_style TEXT );";
        db.execSQL(DDL_INAPP);
    }

    public void addMSGTagIfRequiredInbox(SQLiteDatabase db) {
        if (!this.isFieldExist(TABLE_NAME_MSGS, "msg_tag", db)) {
            Logger.v("DatabaseHelper : addMSGTagIfRequiredInbox : updating inbox table");
            String ALTER_UBOX = " ALTER TABLE MESSAGES ADD COLUMN msg_tag TEXT";
            db.execSQL(ALTER_UBOX);
        }
    }

    public void addUserAttributesTableIfRequired(SQLiteDatabase db) {
        if (!this.tableExists(db, TABLE_NAME_USER_ATTRIBUTES)) {
            Logger.v("DatabaseHelperDatabaseHelper : addUserAttributesTableIfRequired creating missing  user attribute table");
            this.createUserAttributeTable(db);
        } else {
            Logger.v("DatabaseHelper  : addUserAttributesTableIfRequired user attribute table already present");
        }
    }

    public void addCampaignListTableIfRequired(SQLiteDatabase db) {
        if (!this.tableExists(db, TABLE_NAME_CAMPAIGN_LIST)) {
            Logger.v("DatabaseHelper  : addCampaignListTableIfRequired creating missing  campaign list table");
            this.createUserAttributeTable(db);
        } else {
            Logger.v("DatabaseHelper  : addCampaignListTableIfRequired campaign list table already present");
        }
    }

    private void createUserAttributeTable(SQLiteDatabase db) {
        String DDL_USER_ATTRIBUTES = "CREATE TABLE IF NOT EXISTS USERATTRIBUTES ( _id INTEGER PRIMARY KEY, attribute_name TEXT, attribute_value TEXT ); ";
        db.execSQL(DDL_USER_ATTRIBUTES);
    }

    private void createCampaignListTable(SQLiteDatabase db) {
        String DDL_CAMPAIGN_LIST = "CREATE TABLE IF NOT EXISTS CAMPAIGNLIST ( _id INTEGER PRIMARY KEY, campaign_id TEXT, ttl INTEGER );";
        db.execSQL(DDL_CAMPAIGN_LIST);
    }

    private void createBatchDataTable(SQLiteDatabase db) {
        String DDL_BATCH_DATA = "CREATE TABLE IF NOT EXISTS BATCH_DATA ( _id INTEGER PRIMARY KEY, batch_data TEXT );";
        db.execSQL(DDL_BATCH_DATA);
    }

    void addBatchDataTableIfRequired(SQLiteDatabase db) {
        if (!this.tableExists(db, TABLE_NAME_BATCH_DATA)) {
            Logger.v("DatabaseHelper addBatchDataTableIfRequired creating missing  campaign list table");
            this.createBatchDataTable(db);
        } else {
            Logger.v("DatabaseHelper addBatchDataTableIfRequired batch data table is already present");
        }
    }

    void createDeviceTriggerTable(SQLiteDatabase db) {
        String DDL_DEVICE_TRIGGERS = "CREATE TABLE IF NOT EXISTS DEVICE_TRIGGERS ( _id INTEGER PRIMARY KEY, campaign_id TEXT, event_name TEXT, payload TEXT, campaign_payload TEXT, campaign_type TEXT, max_count INTEGER DEFAULT 0, minimum_delay INTEGER DEFAULT 0, should_show_offline INTEGER DEFAULT 0, max_sync_delay_time INTEGER DEFAULT 0, expiry_time INTEGER, priority INTEGER DEFAULT 3, last_show_time INTEGER DEFAULT 0, show_count INTEGER DEFAULT 0, last_updated_time INTEGER DEFAULT 0, status TEXT, should_ignore_dnd INTEGER DEFAULT 0, delay_before_showing INTEGER DEFAULT 0  ) ";
        db.execSQL(DDL_DEVICE_TRIGGERS);
    }

    void addDeviceTriggerTableIfRequired(SQLiteDatabase db) {
        if (!this.tableExists(db, TABLE_NAME_DEVICE_TRIGGERS)) {
            Logger.v("DatabaseHelper addDeviceTriggerTableIfRequired creating missing  device trigger table");
            this.createDeviceTriggerTable(db);
        } else {
            Logger.v("DatabaseHelper addDeviceTriggerTableIfRequired device trigger table is already present");
        }
    }

    void createAttributeCacheTableIfRequired(SQLiteDatabase database) {
        String DDL_ATTRIBUTE_CACHE = "CREATE TABLE IF NOT EXISTS ATTRIBUTE_CACHE ( _id INTEGER PRIMARY KEY, name TEXT, value TEXT, last_tracked_time INTEGER DEFAULT 0, datatype TEXT  ) ";
        database.execSQL(DDL_ATTRIBUTE_CACHE);
    }

    void createInAppV3Table(SQLiteDatabase db) {
        String DDL_INAPP_V3 = "CREATE TABLE IF NOT EXISTS INAPP_V3 ( _id INTEGER PRIMARY KEY, campaign_id TEXT, type TEXT, status TEXT, state TEXT, priority INTEGER, last_updated_time INTEGER, template_type TEXT, deletion_time INTEGER, last_received_time INTEGER DEFAULT 0, campaign_meta TEXT  ) ";
        db.execSQL(DDL_INAPP_V3);
    }

    void createInAppStatsTable(SQLiteDatabase database) {
        String DDL_INAPP_STATS = "CREATE TABLE IF NOT EXISTS INAPP_STATS ( _id INTEGER PRIMARY KEY, timestamp INTEGER, payload TEXT, request_id TEXT  ) ";
        database.execSQL(DDL_INAPP_STATS);
    }

    void addAttributeCacheTableIfRequired(SQLiteDatabase db) {
        if (!this.tableExists(db, TABLE_NAME_ATTRIBUTE_CACHE)) {
            Logger.v("DatabaseHelper addAttributeCacheTableIfRequired() creating missing  attribute cache table");
            this.createAttributeCacheTableIfRequired(db);
        } else {
            Logger.v("DatabaseHelper addAttributeCacheTableIfRequired() attribute cache table is already present");
        }
    }

    void addCampaignIdToMessageTable(SQLiteDatabase db) {
        if (!this.isFieldExist(TABLE_NAME_MSGS, "campaign_id", db)) {
            Logger.v("DatabaseHelper addMSGTagIfRequiredInbox()  updating inbox table");
            String ALTER_MESSAGES_TABLE = " ALTER TABLE MESSAGES ADD COLUMN campaign_id TEXT";
            db.execSQL(ALTER_MESSAGES_TABLE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void portUserAttributeUniqueId(SQLiteDatabase db) {
        try {
            Logger.v("DatabaseHelper portUserAttributeUniqueId(): Will try to port USER_ATTRIBUTE_UNIQUE_ID to another storage.");
            if (!this.tableExists(db, TABLE_NAME_USER_ATTRIBUTES)) {
                Logger.v("DatabaseHelper portUserAttributeUniqueId() : User attribute table does not exist");
                return;
            }
            db.beginTransaction();
            String QUERY_GET_USER_ATTRIBUTE_UNIQUE_ID = "SELECT attribute_name, attribute_value FROM USERATTRIBUTES WHERE attribute_name = ?";
            Cursor cursor = db.rawQuery(QUERY_GET_USER_ATTRIBUTE_UNIQUE_ID, new String[]{"USER_ATTRIBUTE_UNIQUE_ID"});
            if (cursor == null) {
                Logger.v("DatabaseHelper portUserAttributeUniqueId(): USER_ATTRIBUTE_UNIQUE_ID not present. Cursor is null");
                return;
            }
            if (!cursor.moveToFirst()) {
                Logger.v("DatabaseHelper portUserAttributeUniqueId(): USER_ATTRIBUTE_UNIQUE_ID not present. Cursor does not have a 1st element.");
                return;
            }
            String uniqueId = cursor.getString(1);
            cursor.close();
            ConfigurationProvider.getInstance(this.context).saveUserAttributeUniqueId(uniqueId);
            if (!this.tableExists(db, TABLE_NAME_ATTRIBUTE_CACHE)) {
                Logger.v("DatabaseHelper portUserAttributeUniqueId() : Attribute Cache does not exist. Cannot port data");
                return;
            }
            ContentValues contentValue = new ContentValues();
            contentValue.put("name", "USER_ATTRIBUTE_UNIQUE_ID");
            contentValue.put("value", uniqueId);
            contentValue.put("last_tracked_time", Integer.valueOf(0));
            contentValue.put("datatype", DataTypes.STRING.toString());
            db.insert(TABLE_NAME_ATTRIBUTE_CACHE, null, contentValue);
            db.setTransactionSuccessful();
        }
        catch (Exception e) {
            Logger.f("DatabaseHelper portUserAttributeUniqueId(): Exception ", e);
        }
        finally {
            db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void portDataFromv2(SQLiteDatabase db) {
        try {
            db.beginTransaction();
            String QUERY_GET_MSGS = "SELECT * FROM moemsgs";
            Cursor cursor = db.rawQuery(QUERY_GET_MSGS, null);
            if (null != cursor && cursor.moveToFirst()) {
                do {
                    ContentValues values = new ContentValues();
                    values.put("msg", cursor.getString(1));
                    values.put("msgclicked", Integer.valueOf(cursor.getInt(2)));
                    values.put("msgttl", Long.valueOf(Long.parseLong(cursor.getString(3))));
                    values.put("gtime", Long.valueOf(Long.parseLong(cursor.getString(4))));
                    long row = db.insert(TABLE_NAME_MSGS, null, values);
                    Logger.v(":onUpgrade: Porting message data: " + row);
                } while (cursor.moveToNext());
                cursor.close();
                cursor = null;
            }
            db.setTransactionSuccessful();
        }
        catch (Exception e) {
            Logger.e("DatabaseHelper portDatafromv2", e);
        }
        finally {
            if (null != db) {
                db.endTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateDatapoints(SQLiteDatabase db) {
        if (null == db) {
            return;
        }
        try {
            Logger.d("DatabaseHelperStarted porting DATA - FOR DATAPOINTS");
            db.beginTransaction();
            String QUERY_GET_EVENTS = "SELECT _id, action, attrs, gtime, ltime FROM EVENTS";
            Cursor cursor = db.rawQuery(QUERY_GET_EVENTS, null);
            if (null != cursor && cursor.moveToFirst()) {
                do {
                    ContentValues values = new ContentValues();
                    JSONObject details = MoEHelperUtils.getDatapointJSON(cursor.getString(1), new JSONObject(cursor.getString(2)), Long.toString(cursor.getLong(3)), cursor.getString(4));
                    if (null == details) continue;
                    values.put("details", details.toString());
                    values.put("gtime", Long.valueOf(cursor.getLong(3)));
                    long row = db.insert(TABLE_NAME_DATAPOINTS, null, values);
                    Logger.v("DatabaseHelper Porting event data: " + row);
                } while (cursor.moveToNext());
                cursor.close();
            }
            db.setTransactionSuccessful();
        }
        catch (Exception e) {
            Logger.e("DatabaseHelper: populateDatapoints", e);
        }
        finally {
            db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFieldExist(String tableName, String fieldName, SQLiteDatabase db) {
        boolean isExist = false;
        ArrayList<String> columnNameList = new ArrayList<String>();
        try (Cursor res = db.rawQuery("PRAGMA table_info(" + tableName + ")", null);){
            if (res != null && res.moveToFirst()) {
                do {
                    String columnName = res.getString(res.getColumnIndex("name"));
                    columnNameList.add(columnName);
                } while (res.moveToNext());
            }
        }
        if (columnNameList.contains(fieldName)) {
            isExist = true;
        }
        return isExist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void portInAppV2ToV3(SQLiteDatabase db) {
        try {
            ConfigurationProvider.getInstance(this.context).setLastInAppShownTime(ConfigurationProvider.getInstance(this.context).getLastInAppShownTime() / 1000L);
            if (!this.tableExists(db, TABLE_NAME_INAPP_V3)) {
                Logger.e("DatabaseHelper portInAppV2ToV3() : InAppV3 table does not exist. Cannot migrate data");
                return;
            }
            if (!this.tableExists(db, TABLE_NAME_INAPPS)) {
                Logger.e("DatabaseHelper portInAppV2ToV3(): InAppV2 table does not exist. Cannot migrate data");
                return;
            }
            String QUERY_IN_APP_V2 = "SELECT campaign_id, shown_count, last_shown, is_clicked, status, ttl, priority FROM INAPPMSG";
            db.beginTransaction();
            Cursor cursor = db.rawQuery(QUERY_IN_APP_V2, null);
            if (cursor != null && cursor.moveToFirst()) {
                do {
                    ContentValues values = new ContentValues();
                    String campaignId = cursor.getString(0);
                    long expiryTime = cursor.getLong(5) / 1000L;
                    InAppV2Meta inAppV2Meta = new InAppV2Meta(campaignId, cursor.getLong(5), cursor.getLong(6), cursor.getLong(1), cursor.getLong(2), cursor.getInt(3));
                    InAppV3Meta inAppV3Meta = InAppManager.getInstance().generateMetaForV2Campaign(inAppV2Meta);
                    if (inAppV3Meta == null || inAppV3Meta.campaignState == null || inAppV3Meta.campaignMeta == null) {
                        Logger.v("DatabaseHelper portInAppV2ToV3() : Could generate in-appv3 payload. Will not migrate the campaign.");
                        continue;
                    }
                    long deletionTime = expiryTime > MoEUtils.currentSeconds() + 5184000L ? expiryTime : MoEUtils.currentSeconds() + 5184000L;
                    values.put("state", inAppV3Meta.campaignState.toString());
                    values.put("campaign_meta", inAppV3Meta.campaignMeta.toString());
                    values.put("campaign_id", campaignId);
                    values.put("status", "IN_ACTIVE");
                    values.put("type", "general");
                    values.put("deletion_time", Long.valueOf(deletionTime));
                    db.insert(TABLE_NAME_INAPP_V3, null, values);
                } while (cursor.moveToNext());
            }
            if (cursor != null) {
                cursor.close();
            }
            db.setTransactionSuccessful();
        }
        catch (Exception e) {
            Logger.e("DatabaseHelper portInAppV2ToV3() : Exception ", e);
        }
        finally {
            db.endTransaction();
        }
    }

    void addInAppV3TableIfRequired(SQLiteDatabase db) {
        if (!this.tableExists(db, TABLE_NAME_INAPP_V3)) {
            Logger.v("DatabaseHelper addInAppV3TableIfRequired creating missing  inappv3 table");
            this.createInAppV3Table(db);
        } else {
            Logger.v("DatabaseHelper addInAppV3TableIfRequired inappv3 table is already present");
        }
    }

    void addInAppStatsTableIfRequired(SQLiteDatabase db) {
        if (!this.tableExists(db, TABLE_NAME_INAPP_STATS)) {
            Logger.v("DatabaseHelper addInAppStatsTableIfRequired() : creating missing inappstats table.");
            this.createInAppStatsTable(db);
        } else {
            Logger.v("DatabaseHelper addInAppStatsTableIfRequired() : inappstats table already present");
        }
    }
}

