package com.moengage.core.utils;

import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import com.moe.pushlibrary.exceptions.SDKNotInitializedException;
import com.moe.pushlibrary.utils.MoEHelperConstants;
import com.moengage.core.AdvertisingIdClient;
import com.moengage.core.ConfigurationCache;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.MoEConstants;
import com.moengage.core.MoEUtils;
import com.moengage.core.SdkConfig;
import com.moengage.core.model.BaseRequest;
import com.moengage.core.rest.RequestBuilder;
import com.moengage.core.rest.RequestBuilder.RequestType;
import com.moengage.core.rest.RestConstants;
import java.util.TimeZone;
import org.json.JSONException;

public class RestUtils {

  public static String getAuthority() {
    switch (SdkConfig.getConfig().dataRegion) {
      case REGION_EU:
        return MoEConstants.AUTHORITY_API_V2_EU;
      case REGION_INDIA:
        return MoEConstants.AUTHORITY_API_V2_INDIA;
      default:
        return MoEConstants.AUTHORITY_API_V2_US;
    }
  }

  public static RequestBuilder getBaseRequestBuilder(Uri uri, RequestType
      requestType, String appId) throws SDKNotInitializedException {
    if (TextUtils.isEmpty(appId)) throw new SDKNotInitializedException("App ID has not been set");
    return new RequestBuilder(uri, requestType).addHeader(
        MoEConstants.REQUEST_HEADER_APP_KEY, appId);
  }


  public static JsonBuilder getDefaultParams(Context context) throws JSONException {
    JsonBuilder params = new JsonBuilder();
    ConfigurationProvider provider = ConfigurationProvider.getInstance(context);
    long currentTime = MoEUtils.currentTime();
    params.putString(MoEConstants.GENERIC_PARAM_V2_KEY_OS, MoEConstants.GENERIC_PARAM_V2_VALUE_OS)
        .putString(MoEConstants.GENERIC_PARAM_V2_KEY_APP_ID, MoEUtils.getAppId())
        .putString(MoEConstants.GENERIC_PARAM_V2_KEY_SDK_VERSION,
            String.valueOf(MoEHelperConstants.LIB_VERSION))
        .putString(MoEConstants.GENERIC_PARAM_V2_KEY_UUID,
            provider.getCurrentUserId())
        .putString(MoEConstants.GENERIC_PARAM_V2_KEY_TIMESTAMP, String.valueOf(currentTime))
        .putString(MoEConstants.GENERIC_PARAM_V2_KEY_TIMEZONE_OFFSET,
            String.valueOf(TimeZone.getDefault().getOffset(currentTime)))
        .putString(MoEConstants.GENERIC_PARAM_V2_KEY_APP_VERSION, Integer.toString
            (provider.getAppVersion()));

    String integrationType = ConfigurationCache.getInstance().getIntegrationType();
    String integrationVersion = ConfigurationCache.getInstance().getIntegrationVersion();
    if (!MoEUtils.isEmptyString(integrationType) && !MoEUtils.isEmptyString(integrationVersion)) {
      params.putString(MoEConstants.GENERIC_PARAM_V2_KEY_INTEGRATION_TYPE, integrationType)
          .putString(MoEConstants.GENERIC_PARAM_V2_KEY_INTEGRATION_VERSION, integrationVersion);

    }

    if (!provider.isDataTrackingOptedOut()) {
      params.putString(MoEConstants.GENERIC_PARAM_V2_KEY_APP_VERSION_NAME,
          provider.getAppVersionName());
      if (!SdkConfig.getConfig().isGaidTrackingOptedOut) {
        String gaid = provider.getStoredGAID();
        if (TextUtils.isEmpty(gaid)) {
          AdvertisingIdClient.AdInfo adInfo = MoEUtils.getAdvertisementInfo(context);
          if (adInfo != null) {
            gaid = adInfo.getId();
            provider.storeGAID(gaid);
          }
        }
        if (!TextUtils.isEmpty(gaid)) {
          params.putString(MoEConstants.GENERIC_PARAM_V2_KEY_GAID, gaid);
        }
      }
    }

    params.putString(MoEConstants.GENERIC_PARAM_V2_KEY_PUSH_SERVER, provider.getPushService());
    return params;
  }

  public static Uri.Builder getBaseUriBuilder(){
    return new Uri.Builder()
        .scheme(RestConstants.SCHEME_HTTPS)
        .encodedAuthority(RestUtils.getAuthority());
  }

  public static BaseRequest getBaseRequest(Context context) throws JSONException {
    return new BaseRequest(MoEUtils.getAppId(), RestUtils.getDefaultParams(context),
        ConfigurationProvider.getInstance(context).getCurrentUserId());
  }
}