package com.moengage.core.pushamp;

import android.content.Context;

/**
 * @author Umang Chamaria
 * Date: 10/04/19
 */
public interface PushAmpHandler {
  /**
   * Immediately do a server sync
   *
   * @param context Application Context
   * @param fromAppOpen true if call is made on app open, else false
   */
  void foregroundServerSync(Context context, boolean fromAppOpen);

  /**
   * Schedule a message pull after a given time interval
   *
   * @param context Application Context
   */
  void scheduleServerSync(Context context);

}
