package com.moengage.core;

import android.content.Context;
import com.moengage.core.analytics.AnalyticsHelper;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import com.moengage.core.inapp.InAppManager;
import com.moengage.push.PushHandler;
import com.moengage.push.PushManager;

/**
 * @author Umang Chamaria
 * Date: 2019-11-17
 */
public class LogoutTask extends SDKTask {

  private static final String TAG = "LogoutTask";

  public LogoutTask(Context context) {
    super(context);
  }

  @Override public TaskResult execute() {
    try {
      Logger.v(TAG + " execute() : Executing Logout task.");
      InAppManager.getInstance().onLogout(context);
      MoEDAO.getInstance(context).clearDataOnLogout();
      new MoEFileManager(context).clearMoEngageFiles();
      AnalyticsHelper.getInstance(context).onLogout(context);
      PushHandler pushHandler = PushManager.getInstance().getPushHandler();
      if (pushHandler != null) {
        pushHandler.registerForPushToken(context);
      }
      MoEDispatcher dispatcher = MoEDispatcher.getInstance(context);
      dispatcher.getDeviceAddManager().registerDevice(context);
      dispatcher.notifyLogoutCompleteListener();
      dispatcher.clearDataOnLogout();
      dispatcher.shouldClearData = false;
      Logger.v(TAG + " execute() : Completed Logout task");
    }catch (Exception e){
      Logger.e( TAG + " execute() : ", e);
    }
    return null;
  }

  @Override public String getTaskTag() {
    return TAG_LOGOUT_TASK;
  }

  @Override public boolean isSynchronous() {
    return true;
  }
}
