package com.moengage.core;

import android.content.Context;
import com.moe.pushlibrary.PayloadBuilder;
import com.moe.pushlibrary.utils.MoEHelperConstants;
import com.moengage.core.events.MoEEventManager;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import com.moengage.core.model.AppStatus;
import com.moengage.core.model.RemoteConfig;
import java.util.Date;

/**
 * @author Umang Chamaria
 * Date: 16/01/20
 */
public class TrackInstallUpdateTask extends SDKTask {

  private static final String TAG = "TrackInstallUpdateTask";

  private AppStatus appStatus;

  public TrackInstallUpdateTask(Context context, AppStatus appStatus) {
    super(context);
    this.appStatus = appStatus;
  }

  @Override public TaskResult execute() {
    try {
      Logger.v(TAG + " execute() : executing task.");
      if (!RemoteConfig.getConfig().isAppEnabled) return taskResult;
      Logger.v(TAG + " execute() : Tracked App Status: " + appStatus);
      int currentVersion = ConfigurationProvider.getInstance(context).getAppVersion();
      switch (appStatus) {
        case UPDATE:
          trackUpdateEventIfRequired(currentVersion);
          break;
        case INSTALL:
          trackInstallEventIfRequired(currentVersion);
          break;
      }
      ConfigurationProvider.getInstance(context).storeAppVersion(currentVersion);
      Logger.v(TAG + " execute() : completed task.");
    } catch (Exception e) {
      Logger.e(TAG + " execute() : ", e);
    }
    return taskResult;
  }

  private void trackInstallEventIfRequired(int currentVersion) {
    if (ConfigurationProvider.getInstance(context).isInstallRegistered()) {
      Logger.e(TAG + " execute() : Install event is already tracked will not track again.");
      return;
    }
    Logger.v(TAG + " execute() : Will track install.");
    PayloadBuilder attributes = new PayloadBuilder();
    attributes.putAttrInt(MoEHelperConstants.VERSION, currentVersion)
        .putAttrInt(MoEConstants.GENERIC_PARAM_V2_KEY_SDK_VERSION,
            MoEHelperConstants.LIB_VERSION)
        .putAttrLong(MoEHelperConstants.TIME_OF_INSTALL, System.currentTimeMillis())
        .putAttrString(MoEConstants.GENERIC_PARAM_V2_KEY_OS,
            MoEConstants.GENERIC_PARAM_V2_VALUE_OS);
    MoEEventManager.getInstance(context)
        .trackEvent(MoEHelperConstants.EVENT_APP_INSTALL, attributes);
    ConfigurationProvider.getInstance(context).setInstallRegistered();
    taskResult.setIsSuccess(true);
  }

  private void trackUpdateEventIfRequired(int currentVersion) {
    int prevVersion = ConfigurationProvider.getInstance(context).getStoredAppVersion();
    if (currentVersion == prevVersion) {
      Logger.e(TAG + " trackUpdateEventIfRequired() : Update is already tracked for this version.");
      return;
    }
    Logger.v(TAG + " trackUpdateEventIfRequired() : Will track update.");
    PayloadBuilder eventObj =
        new PayloadBuilder().putAttrInt(MoEHelperConstants.FROM_VERSION, prevVersion)
            .putAttrInt(MoEHelperConstants.TO_VERSION, currentVersion)
            .putAttrDate(MoEHelperConstants.TIME_OF_UPDATE, new Date());
    MoEEventManager.getInstance(context)
        .trackEvent(MoEHelperConstants.EVENT_APP_UPD, eventObj);
    taskResult.setIsSuccess(true);
  }

  @Override public String getTaskTag() {
    return TAG_INSTALL_UPDATE_TASK;
  }

  @Override public boolean isSynchronous() {
    return true;
  }
}
