/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.location;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.moengage.core.ConfigurationCache;
import com.moengage.core.Logger;
import com.moengage.core.SdkConfig;
import com.moengage.location.LocationHandler;

public final class GeoManager {
    private LocationHandler handler;
    private static GeoManager instance;

    private GeoManager() {
        this.loadHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GeoManager getInstance() {
        if (instance != null) return instance;
        Class<GeoManager> clazz = GeoManager.class;
        synchronized (GeoManager.class) {
            if (instance != null) return instance;
            instance = new GeoManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private void loadHandler() {
        try {
            this.handler = (LocationHandler)Class.forName("com.moengage.geofence.LocationHandlerImpl").newInstance();
        }
        catch (ClassNotFoundException e) {
            Logger.e("Location Handler class Not Found Exception");
        }
        catch (Exception e) {
            Logger.e("Exception", e);
        }
    }

    @Nullable
    public LocationHandler getHandler(@NonNull Context context) {
        if (context == null) {
            return null;
        }
        if (!ConfigurationCache.getInstance().getRemoteConfiguration().isAppEnabled()) {
            return null;
        }
        if (!ConfigurationCache.getInstance().getRemoteConfiguration().isGeofenceEnabled()) {
            return null;
        }
        if (SdkConfig.getConfig().isLocationServiceEnabled) {
            return this.handler;
        }
        return null;
    }

    public void updateFenceAndLocation(Context context) {
        LocationHandler handler = this.getHandler(context);
        if (handler != null) {
            handler.updateFenceAndLocation(context);
        }
    }

    public void removeGeoFences(Context context) {
        LocationHandler handler = this.getHandler(context);
        if (handler != null) {
            handler.removeGeoFences(context);
        }
    }

    public void scheduleBackgroundSync(Context context) {
        LocationHandler handler = this.getHandler(context);
        if (handler != null) {
            handler.scheduleBackgroundSync(context);
        }
    }
}

