/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core.utils;

import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import com.moe.pushlibrary.exceptions.SDKNotInitializedException;
import com.moengage.core.ConfigurationCache;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.MoEUtils;
import com.moengage.core.model.BaseRequest;
import com.moengage.core.rest.RequestBuilder;
import com.moengage.core.utils.JsonBuilder;
import java.util.TimeZone;
import org.json.JSONException;

public class RestUtils {
    public static String getAuthority() {
        int region = ConfigurationCache.getInstance().getMoEDataRegion();
        switch (region) {
            case 1003: {
                return "apiv2.moengage.com";
            }
            case 1002: {
                return "apiv2eu.moengage.com";
            }
            case 1001: {
                return "apiv2mumbai.moengage.com";
            }
        }
        return "apiv2.moengage.com";
    }

    public static RequestBuilder getBaseRequestBuilder(Uri uri, RequestBuilder.RequestType requestType, String appId) throws SDKNotInitializedException {
        if (TextUtils.isEmpty((CharSequence)appId)) {
            throw new SDKNotInitializedException("App ID has not been set");
        }
        return new RequestBuilder(uri, requestType).addHeader("MOE-APPKEY", appId);
    }

    public static JsonBuilder getDefaultParams(Context context) throws JSONException {
        JsonBuilder params = new JsonBuilder();
        ConfigurationProvider provider = ConfigurationProvider.getInstance(context);
        long currentTime = MoEUtils.currentTime();
        params.putString("os", "ANDROID").putString("app_id", MoEUtils.getAppId(context)).putString("sdk_ver", String.valueOf(9804)).putString("unique_id", provider.getCurrentUserId()).putString("device_ts", String.valueOf(currentTime)).putString("device_tz_offset", String.valueOf(TimeZone.getDefault().getOffset(currentTime))).putString("app_ver", Integer.toString(provider.getAppVersion()));
        String integrationType = ConfigurationCache.getInstance().getIntegrationType();
        String integrationVersion = ConfigurationCache.getInstance().getIntegrationVersion();
        if (!MoEUtils.isEmptyString(integrationType) && !MoEUtils.isEmptyString(integrationVersion)) {
            params.putString("integration_type", integrationType).putString("integration_version", integrationVersion);
        }
        if (!provider.isDataTrackingOptedOut()) {
            params.putString("app_version_name", provider.getAppVersionName());
        }
        params.putString("moe_push_ser", provider.getPushService());
        return params;
    }

    public static Uri.Builder getBaseUriBuilder() {
        return new Uri.Builder().scheme("https").encodedAuthority(RestUtils.getAuthority());
    }

    public static BaseRequest getBaseRequest(Context context) throws JSONException {
        return new BaseRequest(MoEUtils.getAppId(context), RestUtils.getDefaultParams(context), ConfigurationProvider.getInstance(context).getCurrentUserId());
    }
}

