/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core.model;

import android.support.annotation.Nullable;
import com.moengage.core.Logger;
import com.moengage.core.MoEUtils;
import com.moengage.core.model.TrafficSource;
import com.moengage.core.utils.JsonBuilder;
import org.json.JSONArray;
import org.json.JSONObject;

public class UserSession {
    private static final String TAG = "UserSession";
    private String sessionId;
    private String startTime;
    private TrafficSource trafficSource;
    private long lastInteractionTime;
    private boolean isBackgroundInitiated;
    private static final String SESSION_ID = "session_id";
    private static final String START_TIME = "start_time";
    public static final String LAST_INTERACTION_TIME = "last_interaction_time";
    public static final String SOURCE_ARRAY = "source_array";
    public static final String INITIATED_IN_BACKGROUND = "background_initiated";

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public long getLastInteractionTime() {
        return this.lastInteractionTime;
    }

    public void setLastInteractionTime(long lastInteractionTime) {
        this.lastInteractionTime = lastInteractionTime;
    }

    public TrafficSource getSource() {
        return this.trafficSource;
    }

    public void setSource(TrafficSource trafficSource) {
        this.trafficSource = trafficSource;
    }

    public boolean isBackgroundInitiated() {
        return this.isBackgroundInitiated;
    }

    public void setBackgroundInitiated(boolean isBackgroundInitiated) {
        this.isBackgroundInitiated = isBackgroundInitiated;
    }

    @Nullable
    public static JSONObject toJson(UserSession userSession) {
        try {
            JsonBuilder builder = new JsonBuilder();
            builder.putString(SESSION_ID, userSession.getSessionId()).putString(START_TIME, userSession.getStartTime()).putLong(LAST_INTERACTION_TIME, userSession.getLastInteractionTime()).putInt(INITIATED_IN_BACKGROUND, userSession.isBackgroundInitiated() ? 1 : 0);
            JSONArray sourceArray = new JSONArray();
            JSONObject sourceJson = TrafficSource.toJson(userSession.getSource());
            if (MoEUtils.hasKeys(sourceJson)) {
                sourceArray.put((Object)sourceJson);
            }
            if (sourceArray.length() > 0) {
                builder.putJsonArray(SOURCE_ARRAY, sourceArray);
            }
            return builder.build();
        }
        catch (Exception e) {
            Logger.e("UserSession toJson() : Exception: ", e);
            return null;
        }
    }

    @Nullable
    public static UserSession fromJsonString(String jsonString) {
        try {
            JSONArray sourceArray;
            JSONObject sourceJson;
            TrafficSource source;
            if (MoEUtils.isNullOrEmpty(jsonString)) {
                return null;
            }
            JSONObject jsonObject = new JSONObject(jsonString);
            UserSession session = new UserSession();
            session.setSessionId(jsonObject.getString(SESSION_ID));
            session.setStartTime(jsonObject.getString(START_TIME));
            session.setLastInteractionTime(jsonObject.getLong(LAST_INTERACTION_TIME));
            if (jsonObject.has(SOURCE_ARRAY) && (source = TrafficSource.fromJson(sourceJson = (sourceArray = jsonObject.getJSONArray(SOURCE_ARRAY)).getJSONObject(0))) != null) {
                session.setSource(source);
            }
            session.setBackgroundInitiated(jsonObject.getInt(INITIATED_IN_BACKGROUND) == 1);
            return session;
        }
        catch (Exception e) {
            Logger.e("UserSession fromJsonString() : Exception: ", e);
            return null;
        }
    }

    public String toString() {
        return "{sessionId : '" + this.sessionId + '\'' + ", startTime : '" + this.startTime + '\'' + ", trafficSource : " + this.trafficSource + ", lastInteractionTime : " + this.lastInteractionTime + ", isBackgroundInitiated : " + this.isBackgroundInitiated + '}';
    }
}

