/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core;

import android.content.Context;
import android.text.TextUtils;
import com.moengage.core.APIManager;
import com.moengage.core.ConfigurationCache;
import com.moengage.core.Logger;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import com.moengage.inapp.InAppController;
import java.util.HashMap;
import org.json.JSONObject;

public class InAppNetworkCallsTask
extends SDKTask {
    private HashMap<String, String> paramsMap;
    String API;
    private JSONObject requestBody;
    private InAppController.NETWORK_CALL_TYPE networkCallType;

    public InAppNetworkCallsTask(Context context, String API, HashMap<String, String> paramsMap, JSONObject requestBody, InAppController.NETWORK_CALL_TYPE networkCallType) {
        super(context);
        this.API = API;
        this.paramsMap = paramsMap;
        this.requestBody = requestBody;
        this.networkCallType = networkCallType;
    }

    @Override
    public TaskResult execute() {
        Logger.v("InAppNetworkCallsTask : started execution, Task Type : " + (Object)((Object)this.networkCallType));
        String response = null;
        try {
            if (!ConfigurationCache.getInstance().getRemoteConfiguration().isInAppEnabled() || !ConfigurationCache.getInstance().getRemoteConfiguration().isAppEnabled()) {
                return null;
            }
            switch (this.networkCallType) {
                case AUTO_TRIGGER_EVENT: {
                    Logger.v("InAppNetworkCallsTask: executing auto-trigger in-apps");
                    response = APIManager.logASmartEvent(this.context, this.API, this.paramsMap, this.requestBody);
                    if (TextUtils.isEmpty((CharSequence)response)) break;
                    JSONObject jsonResponse = new JSONObject(response);
                    InAppController.getInstance().tryShowAutoTriggerInApp(this.context, jsonResponse);
                    break;
                }
                case SINGLE_FETCH: {
                    Logger.v("InAppNetworkCallsTask: executing single fetch in-apps");
                    response = APIManager.fetchSingleInApp(this.context, this.API, this.paramsMap);
                    if (!TextUtils.isEmpty((CharSequence)response)) {
                        JSONObject jsonResponse = new JSONObject(response);
                        InAppController.getInstance().showLinkedInApp(this.context, jsonResponse, this.paramsMap);
                        break;
                    }
                    String errorString = "Network Error Could not show test in-app.\n CampaignId : " + this.paramsMap.get("campaign_id") + ".\nPlease try again or contact MoEngage Support with the screenshot.";
                    InAppController.getInstance().showTestInAppErrorDialog(this.context, errorString);
                }
            }
        }
        catch (Exception e) {
            Logger.f("InAppNetworkCallsTask : execute JSONException", e);
        }
        Logger.v("InAppNetworkCallsTask : completed execution");
        return this.taskResult;
    }

    @Override
    public String getTaskTag() {
        return "INAPP_NETWORK_TASK";
    }

    @Override
    public boolean isSynchronous() {
        return false;
    }
}

