package com.moengage.push;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import java.util.Map;

public interface PushHandler {

    /**
     * (non-JavaDoc)
     *
     * @param context Instance of the application {@link Context}
     * @return GCM token
     * <b>Note : This method should not be called from the main thread</b>
     */
    @WorkerThread String registerForPushToken(Context context);

    /**
     * (non-JavaDoc)
     *
     * Use MoEPushHelper.getInstance().handlePushPayload(Context, Map)
     */
    @Deprecated void handlePushPayload(Context context, Bundle extras);

    /**
     * (non-JavaDoc)
     * No longer supported by the SDK need to remove
     * @param context Instance of the application {@link Context}
     * @param intent {@link Intent} extras which is passed along with the GCM payload
     */
    @Deprecated
    void handlePushPayload(Context context, Intent intent);

    /**
     * (non-JavaDoc)
     * Deletes the gcm token.<br> <b>Note : This method should not be called from the main thread.
     * <br>Should only be called whenever the user is logged out</b>
     *
     * @param context Instance of the application {@link Context}
     * @param senderId SenderId or ProjectId from Developer's Console
     */
    @WorkerThread void deleteToken(Context context, String senderId);

    /**
     * (non-JavaDoc)
     * Starts intent service to offload task from main thread
     *
     * @param context Application Context
     * @param extra parameter which decides the task to be performed
     */
    void offLoadToWorker(Context context, String extra);

    /**
     * (non-JavaDoc)
     * Log Notification click event. used in cases where people handle everything on there own
     *
     * @param context Application Context
     * @param intent Calling intent
     */
    void logNotificationClicked(Context context, Intent intent);

    /**
     * (non-JavaDoc)
     * Set Customized Push Message Listener
     *
     * @param messageListener Object of a class extending PushMessageListener
     */
    void setMessageListener(Object messageListener);

    /**
     * Set an alarm to register for push if no token is found on app open
     *
     * @param context Application context
     */
    void setPushRegistrationFallback(Context context);

    /**
     * Returns an instance of PushMessageListener
     *
     * @return instance of PushMessageListener, either default or custom
     */
    Object getMessageListener();

    /**
     * Use MoEPushHelper.getInstance().handlePushPayload(Context, Map)
     */
    @Deprecated void handlePushPayload(Context context, Map<String, String> pushPayload);

    @Nullable @WorkerThread String getPushToken(Context context);

    /**
     *
     * @param context Instance of the application context {@link Context}
     * @param pushPayload String which is passed along with the Baidu payload
     */
    void handlePushPayload(Context context, String pushPayload);
  }