/*
 * Copyright (c) 2014-2020 MoEngage Inc.
 * All rights reserved.
 *  Use of source code or binaries contained within MoEngage SDK is permitted only to enable use of the MoEngage platform by customers of MoEngage.
 *  Modification of source code and inclusion in mobile apps is explicitly allowed provided that all other conditions are met.
 *  Neither the name of MoEngage nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *  Redistribution of source code or binaries is disallowed except with specific prior written permission. Any such redistribution must retain the above copyright notice, this list of conditions and the following disclaimer.
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.moengage.core.executor;

import android.content.Context;

/**
 * @author Umang Chamaria on 11/17/15.
 */
public abstract class SDKTask implements ITask {

  protected static final String TAG_CHECK_IN_APPS = "CHECK_IN_APPS";
  public static final String TAG_ACTIVITY_START = "START_ACTIVITY";
  protected static final String TAG_SHOW_IN_APP_ON_CONFIG_CHANGE = "SHOW_IN_APP_ON_CONFIG_CHANGE";
  protected static final String TAG_NOTIFICATION_CLICKED = "NOTIFICATION_CLICKED";
  protected static final String TAG_TRACK_EVENT = "TRACK_EVENT";
  protected static final String TAG_LOG_IN_APP_CLICKED = "IN_APP_CLICKED";
  public static final String TAG_DEVICE_ADD = "DEVICE_ADD";
  protected static final String TAG_SHOW_LINKED_IN_APP = "SHOW_LINKED_IN_APP";
  public static final String TAG_SEND_INTERACTION_DATA = "SEND_INTERACTION_DATA";
  protected static final String TAG_ACTIVITY_STOP = "ACTIVITY_STOP";
  public static final String TAG_INAPP_NETWORK_TASK = "INAPP_NETWORK_TASK";
  protected static final String TAG_SHOW_SELF_HANDLED_INAPP = "SHOW_SELF_HANDLED_INAPP";
  protected static final String TAG_SEND_LOG = "SEND_LOG";
  public static final String TAG_SYNC_CONFIG_API = "SYNC_CONFIG";
  protected static final String TAG_FETCH_MESSAGES = "FETCH_MESSAGES";
  public static final String TAG_INTEGRATION_VERIFICATION_NETWORK_TASK =
      "INTEGRATION_VERIFICATION_NETWORK_TASK";
  protected static final String TAG_SET_ALIAS = "SET_ALIAS";
  protected static final String TAG_SET_DEVICE_ATTRIBUTES = "SET_DEVICE_ATTRIBUTES";
  protected static final String TAG_MOE_WORKER_TASK = "MOE_WORKER_TASK";
  protected static final String TAG_MOE_PUSH_WORKER_TASK = "MOE_PUSH_WORKER_TASK";
  protected static final String TAG_CHECK_AND_SHOW_DT = "CHECK_AND_SHOW_DT";
  protected static final String TAG_DT_NETWORK_CALL_TASK = "DT_NETWORK_CALL_TASK";
  protected static final String TAG_DATA_TRACKING_OPT_OUT_TASK = "DATA_TRACKING_OPT_OUT_TASK";
  public static final String TAG_TRACK_ATTRIBUTE = "TRACK_ATTRIBUTE";
  public static final String TAG_PUSH_AMP_SERVER_SYNC_TASK = "PUSH_AMP_SERVER_SYNC_TASK";
  protected static final String TAG_TRACK_EVENT_SEGMENT = "TRACK_EVENT_SEGMENT";
  protected static final String TAG_TRACK_USER_ATTRIBUTE_SEGMENT = "TRACK_USER_ATTRIBUTE_SEGMENT";
  protected static final String TAG_LOAD_CONFIGURATION_FROM_DISK = "LOAD_CONFIGURATION_FROM_DISK";
  protected static final String TAG_LOG_NOTIFICATION_CLICK = "LOG_NOTIFICATION_CLICK";
  protected static final String TAG_TRACK_APP_STATUS = "TRACK_APP_STATUS";
  protected static final String TAG_GEOFENCE_FETCH = "GEOFENCE_FETCH";


  protected Context context;
  protected TaskResult taskResult;

  public SDKTask(Context context) {
    this.context = context;
    taskResult = new TaskResult();
    taskResult.setIsSuccess(false);
  }

  @Override public void onPostExecute(TaskResult result) {

  }

  public TaskResult createTaskResult(Object payload, boolean taskState){
    taskResult.setPayload(payload);
    taskResult.setIsSuccess(taskState);
    return taskResult;
  }
}