package com.moengage.core.events;

import com.moe.pushlibrary.PayloadBuilder;
import com.moe.pushlibrary.models.Event;
import com.moe.pushlibrary.utils.MoEHelperUtils;
import com.moengage.core.Logger;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.json.JSONObject;


/**
 * @author Umang Chamaria
 * Date: 2019-05-28
 */
class EventHandler {

  private static final String TAG = "EventHandler";

  Event transformToEventModel(String eventName, JSONObject attributes){
    if (attributes != null
        && (attributes.has(MoEHelperUtils.EVENT_ATTRS) || attributes.has(
        MoEHelperUtils.EVENT_ATTRS_CUST))
        && attributes.has(MoEHelperUtils.EVENT_L_TIME)
        && attributes.has(MoEHelperUtils.EVENT_G_TIME)) {
      // payload already built via payload builder directly cast to model
      return new Event(eventName, attributes);
    } else {
      PayloadBuilder payloadBuilder = new PayloadBuilder();
      if (attributes != null) {
        Iterator<String> iterator = attributes.keys();
        while (iterator.hasNext()) {
          try {
            String key = iterator.next();
            payloadBuilder.putAttrObject(key, attributes.get(key));
          } catch (Exception e) {
            Logger.e(TAG + " trackEvent() : Exception ", e);
          }
        }
      }
     return new Event(eventName, payloadBuilder.build());
    }
  }

  /**
   * Checks whether event should be tracked or not.
   *
   * @param isDataTrackingOptedOut data tracking status
   * @param gdprWhitelistEvent list of whitelisted events for gdpr
   * @param blackListEvents list of events which are black listed
   * @param eventName name of the event to be tracked
   * @return true if event should be tracked else false
   */
  boolean shouldTrackEvent(boolean isDataTrackingOptedOut, Set<String> gdprWhitelistEvent,
      List<String> blackListEvents, String eventName){
    if (isDataTrackingOptedOut){
      if (gdprWhitelistEvent == null) return false;
      return gdprWhitelistEvent.contains(eventName);
    }else {
      if (blackListEvents == null) return true;
      return !blackListEvents.contains(eventName);
    }
  }
}
