/*
 * Copyright (c) 2014-2020 MoEngage Inc.
 * All rights reserved.
 *  Use of source code or binaries contained within MoEngage SDK is permitted only to enable use of the MoEngage platform by customers of MoEngage.
 *  Modification of source code and inclusion in mobile apps is explicitly allowed provided that all other conditions are met.
 *  Neither the name of MoEngage nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *  Redistribution of source code or binaries is disallowed except with specific prior written permission. Any such redistribution must retain the above copyright notice, this list of conditions and the following disclaimer.
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.moengage.core;

import android.content.Context;
import android.os.Build;
import com.moe.pushlibrary.models.GeoLocation;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import java.util.HashMap;

/**
 * @author Umang Chamaria
 */

public class IntegrationVerificationNetworkCallTask extends SDKTask {
  private TASK_TYPE task_type;

  public IntegrationVerificationNetworkCallTask(Context context, TASK_TYPE task_type) {
    super(context);
    this.task_type = task_type;
  }

  @Override public TaskResult execute() {
    try {
      switch (task_type) {
        case REGISTER_DEVICE:
         createResult(registerDevice());
          break;
        case UNREGISTER_DEVICE:
          createResult(unregisterDevice());
          break;
        default:
          Logger.e("IntegrationVerificationNetworkCallTask: invalid case");
      }
    } catch (Exception e) {
      Logger.f("IntegrationVerificationNetworkCallTask: Exception ", e);
    }
    return taskResult;
  }

  private APIResponse unregisterDevice() {
    String API = MoEUtils.getAPIRoute(context)
        + MoEConstants.API_ENDPOINT_INTEGRATION_VERIFICATION_UNLINK_DEVICE;
    return APIManager.registerUnregisterDeviceForIntegrationVerification(context, API, null);
  }

  private APIResponse registerDevice() {
    String API = MoEUtils.getAPIRoute(context)
        + MoEConstants.API_ENDPOINT_INTEGRATION_VERIFICATION_DEVICE_REGISTRATION;
    GeoLocation geoLocation =
        ConfigurationProvider.getInstance(context).getSavedLocation();
    if (geoLocation == null) {
      geoLocation = new GeoLocation(0.0, 0.0);
    }
    HashMap<String, String> paramsMap = new HashMap<>();
    paramsMap.put("lat", String.valueOf(geoLocation.latitude));
    paramsMap.put("lng", String.valueOf(geoLocation.longitude));
    paramsMap.put("manufacturer", Build.MANUFACTURER);
    return APIManager.registerUnregisterDeviceForIntegrationVerification
        (context, API, paramsMap);
  }

  @Override public String getTaskTag() {
    return TAG_INTEGRATION_VERIFICATION_NETWORK_TASK;
  }

  @Override public boolean isSynchronous() {
    return true;
  }

  public enum TASK_TYPE {
    REGISTER_DEVICE, UNREGISTER_DEVICE
  }

  private void createResult(APIResponse apiResponse) {
    taskResult.setPayload(apiResponse);
  }
}
