/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.inapp;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.moe.pushlibrary.models.Event;
import com.moengage.core.ConfigurationCache;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.Logger;
import java.util.HashMap;
import org.json.JSONObject;

public class InAppController {
    private InAppHandler inAppHandler;
    private int mActivityOrientation = -1;
    private String mActivityName = null;
    private static InAppController _INSTANCE;
    public static String SYNC_API_FAILURE;
    public static String SMART_API_FAILURE;
    public static String SINGLE_API_FAILURE;

    private InAppController() {
        this.loadInAppHandler();
    }

    private void loadInAppHandler() {
        try {
            Class<?> handler = Class.forName("com.moengage.inapp.InAppHandlerImpl");
            this.inAppHandler = (InAppHandler)handler.newInstance();
            Logger.v("InAppController:loadInAppHandler InApp Module present");
        }
        catch (Exception e) {
            Logger.e("InAppController : loadInAppHandler : InApp Module not present " + e.getMessage());
        }
    }

    @Deprecated
    public InAppHandler getInAppHandler() {
        return this.inAppHandler;
    }

    @Nullable
    private InAppHandler getInAppHandler(Context context) {
        ConfigurationProvider provider = ConfigurationProvider.getInstance(context);
        if (provider.isInAppOptedOut() || !ConfigurationCache.getInstance().getRemoteConfiguration().isInAppEnabled()) {
            return null;
        }
        return this.inAppHandler;
    }

    public static InAppController getInstance() {
        if (_INSTANCE == null) {
            _INSTANCE = new InAppController();
        }
        return _INSTANCE;
    }

    public String getActivityName() {
        return this.mActivityName;
    }

    public void setActivityName(String activityName) {
        this.mActivityName = activityName;
    }

    public int getActivityOrientation() {
        return this.mActivityOrientation;
    }

    public void setActivityOrientation(int activityOrientation) {
        this.mActivityOrientation = activityOrientation;
    }

    public void trackAPIFailure(String apiType) {
        InAppHandler inAppHandler = this.getInAppHandler();
        if (inAppHandler != null) {
            inAppHandler.logInAppAPIFailure(apiType);
        }
    }

    public void writeInAppCheckFailureCounterToStorage(Context context) {
        InAppHandler inAppHandler = this.getInAppHandler(context);
        if (inAppHandler != null) {
            inAppHandler.writeInAppCheckFailureCounterToStorage(context);
        }
    }

    public void registerInAppManager(Activity activity) {
        InAppHandler inAppHandler = this.getInAppHandler(activity.getApplicationContext());
        if (inAppHandler != null) {
            inAppHandler.registerInAppManager(activity);
        }
    }

    public void unregisterInAppManager(Activity activity) {
        InAppHandler inAppHandler = this.getInAppHandler(activity.getApplicationContext());
        if (inAppHandler != null) {
            inAppHandler.unregisterInAppManager(activity);
        }
    }

    public void showInAppIfEligible(Context context) {
        InAppHandler inAppHandler = this.getInAppHandler(context);
        if (inAppHandler != null) {
            inAppHandler.showInAppIfEligible(context);
        }
    }

    public void showInAppOnConfigurationChange(Context context) {
        InAppHandler inAppHandler = this.getInAppHandler(context);
        if (inAppHandler != null) {
            inAppHandler.showInAppOnConfigurationChange(context);
        }
    }

    public void fetchLinkedInApp(Context context, String campaignId) {
        InAppHandler inAppHandler = this.getInAppHandler(context);
        if (inAppHandler != null) {
            inAppHandler.fetchLinkedInApp(context, campaignId);
        }
    }

    public void registerAutoTriggerEvent(Context context, Event event) {
        InAppHandler inAppHandler = this.getInAppHandler(context);
        if (inAppHandler != null) {
            inAppHandler.registerAutoTriggerEvent(context, event);
        }
    }

    public void parseAndSaveInApps(Context context, JSONObject jsonResponse) {
        InAppHandler inAppHandler = this.getInAppHandler(context);
        if (inAppHandler != null) {
            inAppHandler.parseAndSaveInApps(jsonResponse, context);
        }
    }

    public void tryShowAutoTriggerInApp(Context context, JSONObject jsonResponse) {
        InAppHandler inAppHandler = this.getInAppHandler(context);
        if (inAppHandler != null) {
            inAppHandler.tryShowAutoTriggerInApp(context, jsonResponse);
        }
    }

    public void showLinkedInApp(Context context, JSONObject jsonResponse, HashMap<String, String> paramsMap) {
        InAppHandler inAppHandler = this.getInAppHandler(context);
        if (inAppHandler != null) {
            inAppHandler.showLinkedInApp(context, jsonResponse, paramsMap);
        }
    }

    public void showTestInAppErrorDialog(Context context, String errorString) {
        InAppHandler inAppHandler = this.getInAppHandler(context);
        if (inAppHandler != null) {
            inAppHandler.showTestInAppErrorDialog(errorString);
        }
    }

    public void syncInAppIfRequired(Context context) {
        InAppHandler inAppHandler = this.getInAppHandler(context);
        if (inAppHandler != null) {
            inAppHandler.syncInAppsIfRequired(context);
        }
    }

    static {
        SYNC_API_FAILURE = "sync_api_fail";
        SMART_API_FAILURE = "smart_api_fail";
        SINGLE_API_FAILURE = "single_fetch_api_failure";
    }

    public static interface InAppHandler {
        public void showInAppOnConfigurationChange(Context var1);

        public void showInAppIfEligible(Context var1);

        @WorkerThread
        public void tryShowAutoTriggerInApp(Context var1, JSONObject var2);

        public void parseAndSaveInApps(JSONObject var1, Context var2);

        public void registerAutoTriggerEvent(Context var1, Event var2);

        public void registerInAppManager(Activity var1);

        public void unregisterInAppManager(Activity var1);

        public void fetchLinkedInApp(Context var1, String var2);

        public void showLinkedInApp(Context var1, JSONObject var2, HashMap<String, String> var3);

        public void showTestInAppErrorDialog(String var1);

        public void writeInAppCheckFailureCounterToStorage(Context var1);

        public void logInAppAPIFailure(String var1);

        public void syncInAppsIfRequired(Context var1);
    }

    public static enum NETWORK_CALL_TYPE {
        AUTO_TRIGGER_EVENT,
        SINGLE_FETCH;

    }
}

