/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core;

import android.content.Context;
import com.moe.pushlibrary.PayloadBuilder;
import com.moengage.core.ConfigurationCache;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.Logger;
import com.moengage.core.events.MoEEventManager;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import java.util.Date;

public class TrackAppStatus
extends SDKTask {
    private static final String TAG = "TrackAppStatus";
    private boolean existing;

    public TrackAppStatus(Context context, boolean existing) {
        super(context);
        this.existing = existing;
    }

    @Override
    public TaskResult execute() {
        try {
            Logger.v("TrackAppStatus execute() : Tracking App status.");
            if (!ConfigurationCache.getInstance().getRemoteConfiguration().isAppEnabled()) {
                return this.taskResult;
            }
            ConfigurationProvider configProvider = ConfigurationProvider.getInstance(this.context);
            boolean installRegistered = ConfigurationProvider.getInstance(this.context).isInstallRegistered();
            int currentVersion = configProvider.getAppVersion();
            if (this.existing) {
                int prevVersion = configProvider.getStoredAppVersion();
                if (currentVersion == prevVersion) {
                    return this.taskResult;
                }
                configProvider.storeAppVersion(currentVersion);
                PayloadBuilder eventObj = new PayloadBuilder().putAttrInt("VERSION_FROM", prevVersion).putAttrInt("VERSION_TO", currentVersion).putAttrDate("UPDATED_ON", new Date());
                MoEEventManager.getInstance(this.context).trackEvent("UPDATE", eventObj);
                Logger.v("TrackAppStatus execute() : Tracking Update");
            } else if (!installRegistered) {
                configProvider.storeAppVersion(currentVersion);
                PayloadBuilder builder = new PayloadBuilder();
                builder.putAttrInt("VERSION", currentVersion).putAttrInt("sdk_ver", 9803).putAttrLong("INSTALLED_TIME", System.currentTimeMillis()).putAttrString("os", "ANDROID");
                MoEEventManager.getInstance(this.context).trackEvent("INSTALL", builder);
                Logger.v("TrackAppStatus execute() : Tracking Install");
            }
            Logger.v("TrackAppStatus execute() : Completed tracking app status.");
        }
        catch (Exception e) {
            Logger.e("TrackAppStatus execute() : ", e);
        }
        return this.taskResult;
    }

    @Override
    public String getTaskTag() {
        return "TRACK_APP_STATUS";
    }

    @Override
    public boolean isSynchronous() {
        return true;
    }
}

