/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.preference.PreferenceManager;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.delight.pushlibrary.R;
import com.moe.pushlibrary.models.GeoLocation;
import com.moe.pushlibrary.models.UserAttribute;
import com.moe.pushlibrary.utils.MoEHelperUtils;
import com.moengage.core.ConfigurationCache;
import com.moengage.core.Logger;
import com.moengage.core.MoEDAO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;

public final class ConfigurationProvider {
    private HashMap<String, Object> configMap;
    private boolean initialized = false;
    private boolean isPushRegistrationEnabled = true;
    private static long INAPP_DELAY_DURATION = 900L;
    private static final String PREF_NAME = "pref_moe";
    private static final String SENDER_ID = "SENDER_ID";
    private static final String APP_ID = "APP_ID";
    private static final String SKIP_GCM_REGISTRATION = "SKIP_GCM_REGISTRATION";
    private static final String NOTIFICATION_ICON = "NOTIFICATION_ICON";
    private static final String NOTIFICATION_LARGE_ICON = "NOTIFICATION_LARGE_ICON";
    private static final String NOTIFICATION_TONE = "NOTIFICATION_TONE";
    private static final String NOTIFICATION_COLOR = "NOTIFICATION_COLOR";
    private static final String NOTIFICATION_TYPE = "NOTIFICATION_TYPE";
    private static final String CURRENT_APP_VERSION = "APP_VERSION";
    private static final String PREF_KEY_LAST_CAMPAIGN_ID = "MOE_LAST_CAMPAIGN_ID";
    private static final String BAIDU_API_KEY = "api_key";
    static boolean shouldReadManifestConfig = true;
    private static final String PREF_KEY_MOE_GEN_UID = "APP_UNIQUE_ID_MOE";
    private static final String PREF_KEY_APP_VERSION = "appVersion";
    private static final String PREF_KEY_FCM_TOKEN_SERVER_SENT_STATE = "PREF_KEY_DEVICE_REGISTERED";
    private static final int NOTIFICATION_ID = 17987;
    private static final String PREF_KEY_LAST_NOTIFICATION_ID = "PREF_LAST_NOTIFICATION_ID";
    private Context context;
    private final Object lock = new Object();
    private static ConfigurationProvider _INSTANCE;
    private final Object gcmTokenLock = new Object();
    private final Object userLock = new Object();
    private static final String PREF_KEY_APP_UUID_MOE = "APP_UUID";
    static final String PREF_KEY_PROPERTY_REG_ID = "registration_id";
    static final String PREF_KEY_SENDER_ID = "SENDER_ID";
    static final String PREF_KEY_APP_INIT = "APP_INITIALIZED_MOE";
    static final String PREF_KEY_MOE_ISLAT = "PREF_KEY_MOE_ISLAT";
    static final String PREF_KEY_MOE_GAID = "PREF_KEY_MOE_GAID";
    static final String PREF_KEY_IN_APP_TIME_DIFF = "inapp_delay_dur";
    private static final String PREF_KEY_INAPP_LAST_SHOWN_TS = "MOE_LAST_IN_APP_SHOWN_TIME";
    private static final String PREF_KEY_INAPP_LAST_SYNC_TIME = "MOE_LAST_IN_APP_UPDATE_TIME";
    private static final String PREF_KEY_LAST_NOTIFICATION_CLICKED = "MOE_LAST_PUSH_CLICK_TIME";
    private static final String PREF_KEY_GAID_COLLECTION = "pref_key_isCollectGAID";
    private static final String PREF_KEY_USER_LOCATION = "key_geoinfo";
    private static final String KEY_DB_VERSION = "key_dbversion";
    private static final String PREF_KEY_NOTIFICATION_SOUND = "key_notification_sound";
    static final String PREF_KEY_SMART_ACTIONS = "smart_actions";
    private static final String KEY_TRACK_LOCATION = "key_track_location";
    private static final String KEY_SET_GEO_FENCE = "key_set_geo_fence";
    private static final String PREF_NAV_BAR_OPT_OUT = "opt_out_nav_bar";
    private static final String PREF_LAST_CONFIG_SYNC_TIME = "last_config_sync_time";
    private static final String PREF_LAST_MESSAGE_FETCH_TIME = "last_message_sync";
    private static final String PREF_VERIFICATION_REGISTRATION_TIME = "verfication_registration_time";
    private static final String PREF_HAS_REGISTERED_FOR_VERIFICATION = "has_registered_for_verification";
    private static final String PREF_IS_SEGMENT_INTEGRATION = "is_segment_integration";
    private static final String PREF_KEY_ANDROID_ID_COLLECTION = "pref_key_android_id_collection";
    private static final String PREF_KEY_OPERATOR_NAME_COLLECTION = "pref_key_operator_name_collection";
    private static final String PREF_KEY_DEVICE_ATTRIBUTE_COLLECTION = "pref_key_device_attribute_collection";
    private static final String PREF_KEY_ACTIVITY_SENT_LIST = "sent_activity_list";
    private static final String PREF_KEY_ENABLE_DEBUG_LOGS = "enable_logs";
    private static final String PREF_KEY_SEGMENT_ANONYMOUS_ID = "segment_anonymous_id";
    private static final String PREF_KEY_IMMEDIATE_RETRY_SYNC_COUNT = "retry_count";
    private static final String IN_APP_OPT_OUT_ACTIVITY = "IN_APP_OPT_OUT_ACTIVITY";
    private static String CONFIG_LOCATION_SERVICES;
    private static final String PREF_KEY_DEVICE_TRIGGERS_LAST_SHOW_TIME = "dt_last_show_time";
    private static final String PREF_KEY_DEVICE_TRIGGERS_LAST_SYNC_TIME = "dt_last_sync_time";
    private static final String PREF_KEY_DEVICE_TRIGGERS_MINIMUM_DELAY = "dt_minimum_delay";
    private static final String PREF_KEY_DEVICE_TRIGGERS_DND_START_TIME = "dt_dnd_start";
    private static final String PREF_KEY_DEVICE_TRIGGERS_DND_END_TIME = "dt_dnd_end";
    private static final String PREF_KEY_NOTIFICATION_LARGE_ICON_OPT_OUT = "notification_large_icon_opt_out";
    private static final String DATA_TRACKING_OPT_OUT = "data_tracking_opt_out";
    private static final String PUSH_NOTIFICATION_OPT_OUT = "push_notification_opt_out";
    private static final String IN_APP_NOTIFICATION_OPT_OUT = "in_app_notification_opt_out";
    private static final String CONFIG_BACKGROUND_SYNC_STATE = "config_background_sync_state";
    private static final String CONFIG_DT_BACKGROUND_SYNC_STATE = "config_dt_background_sync_state";
    private static final String PREF_KEY_USER_ATTRIBUTE_UNIQUE_ID = "user_attribute_unique_id";
    private static final String PREF_KEY_LAST_GEO_FENCE_SYNC_TIME = "last_geo_sync_time";
    private static final String PREF_KEY_MI_PUSH_TOKEN = "mi_push_token";
    private static final String PREF_KEY_IS_DEVICE_REGISTERED = "is_device_registered";
    private static final String PREF_KEY_MI_TOKEN_SERVER_SENT_STATE = "has_sent_mi_token_to_server";
    private static final String CONFIG_INSTANT_APP_STATE = "is_instant_app_enanbled";
    private static String PREF_KEY_USER_SESSION;
    private static String PREF_KEY_REMOTE_CONFIGURATION;
    private static final String PREF_KEY_PUSH_SERVICE = "push_service";

    private ConfigurationProvider(Context context) {
        if (context == null) {
            Logger.e("ConfigurationProvider : context passed is null");
            return;
        }
        this.context = context;
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        Object object = this.lock;
        synchronized (object) {
            if (this.initialized) {
                return;
            }
            this.configMap = new HashMap();
            try {
                PackageInfo packageInfo = this.context.getPackageManager().getPackageInfo(this.context.getPackageName(), 0);
                this.configMap.put(CURRENT_APP_VERSION, packageInfo.versionCode);
            }
            catch (PackageManager.NameNotFoundException e) {
                Logger.f("Could not get package name: ", e);
            }
            catch (Exception e) {
                Logger.f("Could not get package name: ", e);
            }
            if (shouldReadManifestConfig) {
                this.getSDKConfiguration();
                this.getOptedOutActivitiesFromManifest();
            }
            this.initialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConfigurationProvider getInstance(Context context) {
        Class<ConfigurationProvider> clazz = ConfigurationProvider.class;
        synchronized (ConfigurationProvider.class) {
            if (null == _INSTANCE) {
                _INSTANCE = new ConfigurationProvider(context);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return _INSTANCE;
        }
    }

    public boolean isPushRegistrationEnabled() {
        return this.isPushRegistrationEnabled;
    }

    private SharedPreferences getSharedPrefs() {
        return this.context.getSharedPreferences(PREF_NAME, 0);
    }

    public String getSenderIdIfAny() {
        return (String)this.configMap.get("SENDER_ID");
    }

    public int getNotificationSmallIcon() {
        Object obj = this.configMap.get(NOTIFICATION_ICON);
        if (obj == null) {
            return -1;
        }
        return (Integer)obj;
    }

    void saveAppDetails(String senderId, String appId) {
        ConfigurationCache.getInstance().setMoEAppId(appId);
        if (senderId != null) {
            this.setSenderID(senderId);
            this.configMap.put("SENDER_ID", senderId);
        }
    }

    public int getNotificationLargeIconIfAny() {
        Object obj = this.configMap.get(NOTIFICATION_LARGE_ICON);
        if (obj == null) {
            return -1;
        }
        return (Integer)obj;
    }

    public String getNotificationToneIfAny() {
        return (String)this.configMap.get(NOTIFICATION_TONE);
    }

    public int getNotificationColor() {
        Object obj = this.configMap.get(NOTIFICATION_COLOR);
        if (null == obj) {
            return -1;
        }
        return (Integer)obj;
    }

    public int getNotificationDisplayType() {
        return (Integer)this.configMap.get(NOTIFICATION_TYPE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getGCMToken() {
        Object object = this.gcmTokenLock;
        synchronized (object) {
            SharedPreferences prefs = this.getSharedPrefs();
            String registrationId = prefs.getString(PREF_KEY_PROPERTY_REG_ID, null);
            if (TextUtils.isEmpty((CharSequence)registrationId)) {
                Logger.v("ConfigurationProvider:getGCMToken: Registration not found.");
                return null;
            }
            return registrationId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGCMToken(String token) {
        Object object = this.gcmTokenLock;
        synchronized (object) {
            SharedPreferences prefs = this.getSharedPrefs();
            Logger.v("ConfigurationProvider: SettingGCMToken : " + token);
            SharedPreferences.Editor editor = prefs.edit();
            editor.putString(PREF_KEY_PROPERTY_REG_ID, token).apply();
        }
    }

    public int getAppVersion() {
        return (Integer)this.configMap.get(CURRENT_APP_VERSION);
    }

    int getStoredAppVersion() {
        return this.getSharedPrefs().getInt(PREF_KEY_APP_VERSION, 0);
    }

    void storeAppVersion(int version) {
        SharedPreferences pref = this.getSharedPrefs();
        pref.edit().putInt(PREF_KEY_APP_VERSION, version).apply();
    }

    private void getSDKConfiguration() {
        String senderId;
        ApplicationInfo info;
        try {
            info = this.context.getPackageManager().getApplicationInfo(this.context.getPackageName(), 128);
        }
        catch (PackageManager.NameNotFoundException e1) {
            Logger.f("ConfigurationProvider:getSDKConfiguration", e1);
            return;
        }
        catch (Exception e) {
            Logger.f("ConfigurationProvider:getSDKConfiguration", e);
            return;
        }
        Bundle metaData = info.metaData;
        if (null == metaData) {
            Logger.f("ConfigurationProvider: How can meta be null");
            return;
        }
        if (metaData.containsKey(APP_ID)) {
            String appId = metaData.getString(APP_ID);
            if (!TextUtils.isEmpty((CharSequence)appId)) {
                ConfigurationCache.getInstance().setMoEAppId(appId);
            } else {
                throw new IllegalStateException("No 'appId' added in manifest application meta");
            }
        }
        if (metaData.containsKey("SENDER_ID") && !TextUtils.isEmpty((CharSequence)(senderId = metaData.getString("SENDER_ID")))) {
            if ((senderId = senderId.trim()).startsWith("id:")) {
                senderId = senderId.substring(3);
            }
            this.configMap.put("SENDER_ID", senderId);
            Logger.i("ConfigurationProvider:getSDKConfig: Sender Id: " + senderId);
        }
        int resNotificationIcon = 0;
        if (metaData.containsKey(NOTIFICATION_ICON)) {
            resNotificationIcon = this.getDrawable(metaData.get(NOTIFICATION_ICON));
        }
        if (0 == resNotificationIcon || !MoEHelperUtils.isValidResourceId(this.context, resNotificationIcon)) {
            resNotificationIcon = this.getAppIcon();
        }
        Logger.v("ConfigurationProvider:getSDKConfig: Notification Icon: " + resNotificationIcon);
        this.setSmallIcon(resNotificationIcon);
        int largeIcon = 0;
        if (metaData.containsKey(NOTIFICATION_LARGE_ICON)) {
            largeIcon = this.getDrawable(metaData.get(NOTIFICATION_LARGE_ICON));
        }
        if (0 == largeIcon || !MoEHelperUtils.isValidResourceId(this.context, largeIcon)) {
            largeIcon = this.getAppIcon();
        }
        Logger.v("ConfigurationProvider:getSDKConfig: Notification Large Icon: " + largeIcon);
        this.setLargeIcon(largeIcon);
        if (metaData.containsKey(NOTIFICATION_TONE)) {
            try {
                String[] resourcePathParts;
                String resName;
                String notificationTone = metaData.getString(NOTIFICATION_TONE);
                String tone = null;
                tone = !TextUtils.isEmpty((CharSequence)notificationTone) ? (notificationTone.contains("res") ? ((resName = (resourcePathParts = notificationTone.split("/"))[resourcePathParts.length - 1]).contains(".") ? resName.substring(resName.lastIndexOf("/") + 1, resName.lastIndexOf(".")) : resName.substring(resName.lastIndexOf("/") + 1)) : notificationTone) : notificationTone;
                Logger.d("ConfigurationProvider:getSDKConfig: Tone is: " + tone);
                this.setNotificationTone(tone);
            }
            catch (Exception e) {
                Logger.f("ConfigurationProvider:getSDKConfig: tone", e);
            }
        }
        if (metaData.containsKey(NOTIFICATION_COLOR)) {
            try {
                String color;
                Object notifyObj = metaData.get(NOTIFICATION_COLOR);
                Logger.d("ConfigurationProvider:getSDKConfig: Notification Color: " + notifyObj);
                int resNotificationColor = notifyObj instanceof Integer ? (Integer)notifyObj : (null != (color = (String)notifyObj) && color.contains("res/color") ? this.context.getResources().getIdentifier(color.substring(color.lastIndexOf("/") + 1), "color", this.context.getPackageName()) : this.context.getResources().getIdentifier(color, "color", this.context.getPackageName()));
                if (0 < resNotificationColor) {
                    this.setNotificationColor(resNotificationColor);
                }
            }
            catch (Exception e) {
                Logger.f("ConfigurationProvider:getSDKConfig: Color", e);
            }
        }
        this.setColorFallback();
        if (metaData.containsKey(NOTIFICATION_TYPE)) {
            try {
                this.setNotificationType(metaData.getInt(NOTIFICATION_TYPE));
            }
            catch (ClassCastException e) {
                Logger.f("ConfigurationProvider:getSDKConfig: notification type", e);
            }
        } else {
            this.setNotificationType(this.context.getResources().getInteger(R.integer.notification_type_single));
        }
        if (metaData.containsKey(SKIP_GCM_REGISTRATION)) {
            this.setPushRegistrationState(!metaData.getBoolean(SKIP_GCM_REGISTRATION));
        }
        Logger.i("ConfigurationProvider: SDK initialized. MoEngage SDK version: 9803");
    }

    void setColorFallback() {
        try {
            int fallbackColor = this.context.getResources().getIdentifier("moe_notification_color", "color", this.context.getPackageName());
            if (0 < fallbackColor) {
                this.setNotificationColor(fallbackColor);
            }
        }
        catch (Exception e1) {
            Logger.f("ConfigurationProvider:getSDKConfig: Color", e1);
        }
    }

    private int getAppIcon() {
        int appIcon = 0;
        try {
            appIcon = this.context.getPackageManager().getApplicationInfo((String)this.context.getPackageName(), (int)0).icon;
        }
        catch (PackageManager.NameNotFoundException e) {
            Logger.f("ConfigurationProvider:getAppIcon: nameNotFoundException", e);
        }
        catch (Exception e) {
            Logger.f("ConfigurationProvider:getAppIcon: Exception", e);
        }
        return appIcon;
    }

    public String getLastPushCampaignId() {
        return this.getSharedPrefs().getString(PREF_KEY_LAST_CAMPAIGN_ID, null);
    }

    public void setLastPushCampaignId(String campaign_id) {
        this.getSharedPrefs().edit().putString(PREF_KEY_LAST_CAMPAIGN_ID, campaign_id).apply();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCurrentUserId() {
        Object object = this.userLock;
        synchronized (object) {
            String prefUniqueId = this.getSharedPrefs().getString(PREF_KEY_APP_UUID_MOE, null);
            UserAttribute dbUniqueIdObj = MoEDAO.getInstance(this.context).getUserAttributeByName(PREF_KEY_APP_UUID_MOE);
            String dbUniqueId = null;
            if (dbUniqueIdObj != null) {
                dbUniqueId = dbUniqueIdObj.userAttributeValue;
            }
            if (TextUtils.isEmpty((CharSequence)prefUniqueId) && TextUtils.isEmpty((CharSequence)dbUniqueId)) {
                Logger.v("ConfigurationProvider: getCurrentUserId() no uniqueId present generating new id");
                return this.generateAndSaveUniqueId();
            }
            if (!TextUtils.isEmpty((CharSequence)dbUniqueId)) {
                Logger.v("ConfigurationProvider: getCurrentUserId() unique id present in db");
                this.getSharedPrefs().edit().putString(PREF_KEY_APP_UUID_MOE, dbUniqueId).apply();
                return dbUniqueId;
            }
            if (!TextUtils.isEmpty((CharSequence)prefUniqueId)) {
                Logger.v("ConfigurationProvider: getCurrentUserId() unique id present in preference");
                return prefUniqueId;
            }
            Logger.v("ConfigurationProvider: getCurrentUserId() generating user id from fallback condition something went wrong");
            return this.generateAndSaveUniqueId();
        }
    }

    public int getNotificationId() {
        return this.getSharedPrefs().getInt(PREF_KEY_LAST_NOTIFICATION_ID, 17987);
    }

    public void updateNotificationId(int notificationId) {
        if (notificationId - 17987 >= 100) {
            notificationId = 17987;
        }
        SharedPreferences sp = this.getSharedPrefs();
        sp.edit().putInt(PREF_KEY_LAST_NOTIFICATION_ID, notificationId).apply();
    }

    private String generateAndSaveUniqueId() {
        String uid = this.generateUUID();
        UserAttribute uniqueId = new UserAttribute(PREF_KEY_APP_UUID_MOE, uid);
        MoEDAO.getInstance(this.context).addOrUpdateUserAttribute(uniqueId);
        this.getSharedPrefs().edit().putString(PREF_KEY_APP_UUID_MOE, uid).apply();
        return uid;
    }

    private String generateUUID() {
        UUID generatedUID = UUID.randomUUID();
        return generatedUID.toString();
    }

    public void setFcmTokenServerSendState(boolean state) {
        SharedPreferences sp = this.getSharedPrefs();
        sp.edit().putBoolean(PREF_KEY_FCM_TOKEN_SERVER_SENT_STATE, state).apply();
    }

    public boolean hasSentFcmTokenToServer() {
        SharedPreferences sp = this.getSharedPrefs();
        return sp.getBoolean(PREF_KEY_FCM_TOKEN_SERVER_SENT_STATE, false);
    }

    public void upgradeFromOldSharedPrefIfRequired() {
        SharedPreferences oldPref = PreferenceManager.getDefaultSharedPreferences((Context)this.context);
        SharedPreferences newPref = this.getSharedPrefs();
        if (oldPref.contains("SENDER_ID")) {
            boolean initialized;
            int duration;
            String uuid;
            String uid;
            Logger.v("Migrating from old shared pref");
            String registrationId = oldPref.getString(PREF_KEY_PROPERTY_REG_ID, null);
            if (null != registrationId) {
                newPref.edit().putString(PREF_KEY_PROPERTY_REG_ID, registrationId).apply();
                oldPref.edit().remove(PREF_KEY_PROPERTY_REG_ID).apply();
            }
            if (null != (uid = oldPref.getString(PREF_KEY_MOE_GEN_UID, null))) {
                newPref.edit().putString(PREF_KEY_MOE_GEN_UID, uid).apply();
                oldPref.edit().remove(PREF_KEY_MOE_GEN_UID).apply();
            }
            if (null != (uuid = oldPref.getString(PREF_KEY_APP_UUID_MOE, null))) {
                newPref.edit().putString(PREF_KEY_APP_UUID_MOE, uuid).apply();
                oldPref.edit().remove(PREF_KEY_APP_UUID_MOE).apply();
            }
            if ((duration = oldPref.getInt(PREF_KEY_IN_APP_TIME_DIFF, -1)) != -1) {
                newPref.edit().putInt(PREF_KEY_IN_APP_TIME_DIFF, duration).apply();
                oldPref.edit().remove(PREF_KEY_IN_APP_TIME_DIFF).apply();
            }
            if (initialized = oldPref.getBoolean(PREF_KEY_APP_INIT, false)) {
                newPref.edit().putBoolean(PREF_KEY_APP_INIT, true).apply();
                oldPref.edit().remove(PREF_KEY_APP_INIT).apply();
            }
        }
    }

    void storeGAID(String gaid) {
        SharedPreferences sp = this.getSharedPrefs();
        sp.edit().putString(PREF_KEY_MOE_GAID, gaid).apply();
    }

    public String getStoredGAID() {
        SharedPreferences sp = this.getSharedPrefs();
        return sp.getString(PREF_KEY_MOE_GAID, "");
    }

    void storeISLAT(int isLAT) {
        SharedPreferences sp = this.getSharedPrefs();
        sp.edit().putInt(PREF_KEY_MOE_ISLAT, isLAT).apply();
    }

    int getStoredISLAT() {
        SharedPreferences sp = this.getSharedPrefs();
        return sp.getInt(PREF_KEY_MOE_ISLAT, 2);
    }

    public void setInAppDelayDuration(int seconds) {
        if (seconds <= 0) {
            Logger.f("Ignoring the supplied value. Minimum delay should be greater than 0");
            return;
        }
        INAPP_DELAY_DURATION = seconds;
        SharedPreferences sp = this.getSharedPrefs();
        sp.edit().putInt(PREF_KEY_IN_APP_TIME_DIFF, seconds).apply();
    }

    public static long getInAppDelayDuration() {
        return INAPP_DELAY_DURATION * 1000L;
    }

    void removeUserConfigurationOnLogout() {
        SharedPreferences sp = this.getSharedPrefs();
        SharedPreferences.Editor editor = sp.edit();
        editor.remove(PREF_KEY_FCM_TOKEN_SERVER_SENT_STATE).remove(PREF_KEY_INAPP_LAST_SYNC_TIME).remove(PREF_KEY_LAST_CAMPAIGN_ID).remove(PREF_KEY_LAST_NOTIFICATION_CLICKED).remove(PREF_KEY_INAPP_LAST_SHOWN_TS).remove(PREF_KEY_APP_UUID_MOE).remove(PREF_KEY_MOE_GEN_UID).remove(PREF_KEY_DEVICE_TRIGGERS_LAST_SHOW_TIME).remove(PREF_KEY_DEVICE_TRIGGERS_LAST_SYNC_TIME).remove(PREF_KEY_DEVICE_TRIGGERS_MINIMUM_DELAY).remove(PREF_KEY_DEVICE_TRIGGERS_DND_END_TIME).remove(PREF_KEY_DEVICE_TRIGGERS_DND_START_TIME).remove(PREF_KEY_DEVICE_TRIGGERS_MINIMUM_DELAY).remove(PREF_LAST_CONFIG_SYNC_TIME).remove(PREF_KEY_USER_ATTRIBUTE_UNIQUE_ID).remove(PREF_KEY_IS_DEVICE_REGISTERED).remove(PREF_KEY_USER_SESSION).apply();
    }

    public void optOutOfAdIdCollection(boolean optOut) {
        this.configMap.put(PREF_KEY_GAID_COLLECTION, optOut);
    }

    public boolean isAdIdCollectionProhibitted() {
        return this.configMap.containsKey(PREF_KEY_GAID_COLLECTION) && this.configMap.get(PREF_KEY_GAID_COLLECTION) == Boolean.TRUE;
    }

    private int getDrawable(Object value) {
        int resource = 0;
        try {
            if (value instanceof Integer) {
                resource = (Integer)value;
                return resource;
            }
            String strObj = (String)value;
            if (strObj.contains("res")) {
                String name = strObj.substring(strObj.lastIndexOf("/") + 1, strObj.lastIndexOf("."));
                resource = strObj.contains("drawable") ? this.context.getResources().getIdentifier(name, "drawable", this.context.getPackageName()) : (strObj.contains("mipmap") ? this.context.getResources().getIdentifier(name, "mipmap", this.context.getPackageName()) : this.getAppIcon());
            } else {
                String notifyIcon = (String)value;
                resource = this.context.getResources().getIdentifier(notifyIcon, "drawable", this.context.getPackageName());
                if (0 == resource) {
                    resource = this.context.getResources().getIdentifier(notifyIcon, "mipmap", this.context.getPackageName());
                }
            }
        }
        catch (Exception e) {
            Logger.f("ConfigurationProvider:getDrawable: ", e);
        }
        return resource;
    }

    public void setNewDBVersion(int version) {
        this.getSharedPrefs().edit().putInt(KEY_DB_VERSION, version).apply();
    }

    public int getDBVersion() {
        return this.getSharedPrefs().getInt(KEY_DB_VERSION, -1);
    }

    public void storeLastKnownLocation(GeoLocation location) {
        this.getSharedPrefs().edit().putString(PREF_KEY_USER_LOCATION, location.latitude + "," + location.longitude).apply();
    }

    public GeoLocation getLastKnownUserLocation() {
        try {
            String location = this.getSharedPrefs().getString(PREF_KEY_USER_LOCATION, null);
            if (null != location) {
                String[] latLong = location.split(",");
                return new GeoLocation(Double.parseDouble(latLong[0]), Double.parseDouble(latLong[1]));
            }
        }
        catch (Exception e) {
            Logger.f("ConfigurationProvider: getLastKnownUserLocation", e);
        }
        return null;
    }

    public long getLastInAppupdate() {
        SharedPreferences sp = this.getSharedPrefs();
        return sp.getLong(PREF_KEY_INAPP_LAST_SYNC_TIME, 0L);
    }

    public void setLastInappUpdateTime(long value) {
        SharedPreferences sp = this.getSharedPrefs();
        sp.edit().putLong(PREF_KEY_INAPP_LAST_SYNC_TIME, value).apply();
    }

    public String getAppVersionName() {
        if (this.configMap.get("app_version_name") == null) {
            this.setAppVersionName();
        }
        return (String)this.configMap.get("app_version_name");
    }

    private void setAppVersionName() {
        PackageInfo pInfo = null;
        try {
            pInfo = this.context.getPackageManager().getPackageInfo(this.context.getPackageName(), 0);
            this.configMap.put("app_version_name", pInfo.versionName);
        }
        catch (PackageManager.NameNotFoundException e) {
            Logger.f("ConfigurationProvider#setAppVersionName : Package Name not found", e);
        }
    }

    public void saveGeoIDList(String list) {
        SharedPreferences sp = this.getSharedPrefs();
        sp.edit().putString("geo_list", list).apply();
    }

    public String getGeoIDList() {
        SharedPreferences sp = this.getSharedPrefs();
        return sp.getString("geo_list", null);
    }

    public void saveNotificationSoundState(boolean state) {
        SharedPreferences sp = this.getSharedPrefs();
        sp.edit().putBoolean(PREF_KEY_NOTIFICATION_SOUND, state).apply();
    }

    public boolean isNotificationSoundEnabled() {
        SharedPreferences sp = this.getSharedPrefs();
        return sp.getBoolean(PREF_KEY_NOTIFICATION_SOUND, true);
    }

    public long getLastInAppShownTime() {
        SharedPreferences sp = this.getSharedPrefs();
        return sp.getLong(PREF_KEY_INAPP_LAST_SHOWN_TS, 0L);
    }

    public void setLastInAppShownTime(long currentTimeMillis) {
        SharedPreferences sp = this.getSharedPrefs();
        sp.edit().putLong(PREF_KEY_INAPP_LAST_SHOWN_TS, currentTimeMillis).apply();
    }

    public void saveSmartTriggerList(String actionList) {
        if (null == actionList) {
            return;
        }
        SharedPreferences sp = this.getSharedPrefs();
        sp.edit().putString(PREF_KEY_SMART_ACTIONS, actionList).apply();
    }

    @Nullable
    public String getSmartTriggerList() {
        return this.getSharedPrefs().getString(PREF_KEY_SMART_ACTIONS, null);
    }

    public void optOutOfTrackLocation(boolean optOut) {
        this.configMap.put(KEY_TRACK_LOCATION, optOut);
    }

    public void optOutOfSetGeoFence(boolean optOut) {
        this.configMap.put(KEY_SET_GEO_FENCE, optOut);
    }

    public boolean isTrackLocationProhibited() {
        return this.configMap.containsKey(KEY_TRACK_LOCATION) && this.configMap.get(KEY_TRACK_LOCATION) == Boolean.TRUE;
    }

    public boolean isSetGeoFenceProhibited() {
        return this.configMap.containsKey(KEY_SET_GEO_FENCE) && this.configMap.get(KEY_SET_GEO_FENCE) == Boolean.TRUE;
    }

    private void getOptedOutActivitiesFromManifest() {
        String OPTOUT_ACTIVITY_KEY = "OPT_OUT_TRACKING";
        ArrayList<String> optedOutActivities = new ArrayList<String>();
        try {
            ActivityInfo[] activityInfoList;
            PackageManager pm = this.context.getPackageManager();
            PackageInfo info = pm.getPackageInfo(this.context.getPackageName(), 129);
            for (ActivityInfo activityInfo : activityInfoList = info.activities) {
                Bundle bundle = activityInfo.metaData;
                if (bundle == null || !bundle.containsKey(OPTOUT_ACTIVITY_KEY)) continue;
                optedOutActivities.add(activityInfo.name);
            }
            Logger.v("ConfigurationProvider : Opted out activities : " + ((Object)optedOutActivities).toString());
            ConfigurationCache.getInstance().setActivityOptOutList(optedOutActivities);
        }
        catch (PackageManager.NameNotFoundException pe) {
            Logger.f("ConfigurationProvider#getOptedOutActivitiesFromManifest " + pe.getMessage());
        }
        catch (Exception e) {
            Logger.f("ConfigurationProvider#getOptedOutActivitiesFromManifest " + e.getMessage());
        }
    }

    public void setNavBarOptOut(boolean hasNavBar) {
        this.configMap.put(PREF_NAV_BAR_OPT_OUT, hasNavBar);
    }

    public boolean hasOptedOutNavBar() {
        return this.configMap.containsKey(PREF_NAV_BAR_OPT_OUT) && this.configMap.get(PREF_NAV_BAR_OPT_OUT) == Boolean.TRUE;
    }

    void setLastConfigSyncTime(long syncTime) {
        SharedPreferences sp = this.getSharedPrefs();
        if (sp != null) {
            sp.edit().putLong(PREF_LAST_CONFIG_SYNC_TIME, syncTime).apply();
        }
    }

    long getLastConfigSyncTime() {
        SharedPreferences sp = this.getSharedPrefs();
        if (sp != null) {
            return sp.getLong(PREF_LAST_CONFIG_SYNC_TIME, 0L);
        }
        return 0L;
    }

    public String getBaiduApiKey() {
        return (String)this.configMap.get(BAIDU_API_KEY);
    }

    public void setLastPushAmpSyncTime(long time) {
        SharedPreferences sp = this.getSharedPrefs();
        if (sp != null) {
            sp.edit().putLong(PREF_LAST_MESSAGE_FETCH_TIME, time).commit();
        }
    }

    public long getLastPushAmpSyncTime() {
        SharedPreferences sp = this.getSharedPrefs();
        if (sp != null) {
            return sp.getLong(PREF_LAST_MESSAGE_FETCH_TIME, 0L);
        }
        return 0L;
    }

    public void setVerificationRegistrationTime(long time) {
        SharedPreferences sp = this.getSharedPrefs();
        if (sp != null) {
            sp.edit().putLong(PREF_VERIFICATION_REGISTRATION_TIME, time).apply();
        }
    }

    public long getVerificationRegistrationTime() {
        SharedPreferences sp = this.getSharedPrefs();
        if (sp != null) {
            return sp.getLong(PREF_VERIFICATION_REGISTRATION_TIME, 0L);
        }
        return 0L;
    }

    public void setVerificationRegistration(boolean hasVerificationRegistered) {
        SharedPreferences sp = this.getSharedPrefs();
        if (sp != null) {
            sp.edit().putBoolean(PREF_HAS_REGISTERED_FOR_VERIFICATION, hasVerificationRegistered).apply();
        }
    }

    public boolean isDeviceRegisteredForVerification() {
        SharedPreferences sp = this.getSharedPrefs();
        if (sp != null) {
            return sp.getBoolean(PREF_HAS_REGISTERED_FOR_VERIFICATION, false);
        }
        return false;
    }

    public void setSegmentEnabledFlag(boolean isSegmentEnabled) {
        SharedPreferences sp = this.getSharedPrefs();
        if (sp != null) {
            sp.edit().putBoolean(PREF_IS_SEGMENT_INTEGRATION, isSegmentEnabled).apply();
        }
    }

    public boolean isSegmentEnabled() {
        SharedPreferences sp = this.getSharedPrefs();
        return sp != null && sp.getBoolean(PREF_IS_SEGMENT_INTEGRATION, false);
    }

    public void optOutOfAndroidIdCollection(boolean optOut) {
        this.configMap.put(PREF_KEY_ANDROID_ID_COLLECTION, optOut);
    }

    boolean isAndroidIdCollectionProhibited() {
        return this.configMap.containsKey(PREF_KEY_ANDROID_ID_COLLECTION) && this.configMap.get(PREF_KEY_ANDROID_ID_COLLECTION) == Boolean.TRUE;
    }

    public void optOutOfOperatorNameCollection(boolean optOut) {
        this.configMap.put(PREF_KEY_OPERATOR_NAME_COLLECTION, optOut);
    }

    boolean isOperatorNameCollectionProhibited() {
        return this.configMap.containsKey(PREF_KEY_OPERATOR_NAME_COLLECTION) && this.configMap.get(PREF_KEY_OPERATOR_NAME_COLLECTION) == Boolean.TRUE;
    }

    public void optOutOfDeviceAttributesCollection(boolean optOut) {
        this.configMap.put(PREF_KEY_DEVICE_ATTRIBUTE_COLLECTION, optOut);
    }

    boolean isDeviceAttributesCollectionProhibited() {
        return this.configMap.containsKey(PREF_KEY_DEVICE_ATTRIBUTE_COLLECTION) && this.configMap.get(PREF_KEY_DEVICE_ATTRIBUTE_COLLECTION) == Boolean.TRUE;
    }

    void saveSentScreenNames(Set<String> sentScreenNames) {
        SharedPreferences.Editor editor = this.getSharedPrefs().edit();
        editor.putStringSet(PREF_KEY_ACTIVITY_SENT_LIST, sentScreenNames).apply();
    }

    Set<String> getSentScreenNames() {
        return this.getSharedPrefs().getStringSet(PREF_KEY_ACTIVITY_SENT_LIST, null);
    }

    public void setDebugLogStatus(boolean status) {
        SharedPreferences.Editor editor = this.getSharedPrefs().edit();
        editor.putBoolean(PREF_KEY_ENABLE_DEBUG_LOGS, status).apply();
    }

    boolean isDebugLogEnabled() {
        SharedPreferences sp = this.getSharedPrefs();
        return sp.getBoolean(PREF_KEY_ENABLE_DEBUG_LOGS, false);
    }

    public void saveSegmentAnonymousId(String anonymousId) {
        this.getSharedPrefs().edit().putString(PREF_KEY_SEGMENT_ANONYMOUS_ID, anonymousId).apply();
    }

    @Nullable
    public String getSegmentAnonymousId() {
        return this.getSharedPrefs().getString(PREF_KEY_SEGMENT_ANONYMOUS_ID, null);
    }

    void setImmediateRetryCount(int count) {
        this.getSharedPrefs().edit().putInt(PREF_KEY_IMMEDIATE_RETRY_SYNC_COUNT, count).apply();
    }

    int getImmediateRetryCount() {
        return this.getSharedPrefs().getInt(PREF_KEY_IMMEDIATE_RETRY_SYNC_COUNT, 0);
    }

    void setLargeIcon(int largeIcon) {
        this.configMap.put(NOTIFICATION_LARGE_ICON, largeIcon);
    }

    void setSmallIcon(int smallIcon) {
        this.configMap.put(NOTIFICATION_ICON, smallIcon);
    }

    void setNotificationType(int type) {
        this.configMap.put(NOTIFICATION_TYPE, type);
    }

    void setSenderID(String senderID) {
        this.configMap.put("SENDER_ID", senderID);
    }

    void setNotificationColor(int color) {
        this.configMap.put(NOTIFICATION_COLOR, color);
    }

    void setNotificationTone(String tone) {
        this.configMap.put(NOTIFICATION_TONE, tone);
    }

    void setPushRegistrationState(boolean state) {
        this.isPushRegistrationEnabled = state;
    }

    void setInAppOptOutActivityList(List<String> inAppOptOutActivityList) {
        this.configMap.put(IN_APP_OPT_OUT_ACTIVITY, inAppOptOutActivityList);
    }

    public List<String> getInAppOptedOutActivities() {
        if (this.configMap.containsKey(IN_APP_OPT_OUT_ACTIVITY)) {
            try {
                return (List)this.configMap.get(IN_APP_OPT_OUT_ACTIVITY);
            }
            catch (Exception e) {
                Logger.e("ConfigurationProvider: getInAppOptedOutActivities() : ", e);
            }
        }
        return null;
    }

    void setBaiduApiKey(String baiduApiKey) {
        this.configMap.put(BAIDU_API_KEY, baiduApiKey);
    }

    public boolean isManifestParsingEnabled() {
        return shouldReadManifestConfig;
    }

    void setLocationServicesState(boolean locationServicesState) {
        this.configMap.put(CONFIG_LOCATION_SERVICES, locationServicesState);
    }

    public boolean getLocationServiceState() {
        return this.configMap.containsKey(CONFIG_LOCATION_SERVICES) && this.configMap.get(CONFIG_LOCATION_SERVICES) == Boolean.TRUE;
    }

    public void saveLastDTShowTime(long time) {
        this.getSharedPrefs().edit().putLong(PREF_KEY_DEVICE_TRIGGERS_LAST_SHOW_TIME, time).apply();
    }

    public long getDTLastShowTime() {
        return this.getSharedPrefs().getLong(PREF_KEY_DEVICE_TRIGGERS_LAST_SHOW_TIME, 0L);
    }

    public void saveLastDTSyncTime(long time) {
        this.getSharedPrefs().edit().putLong(PREF_KEY_DEVICE_TRIGGERS_LAST_SYNC_TIME, time).apply();
    }

    public long getDTLastSyncTime() {
        return this.getSharedPrefs().getLong(PREF_KEY_DEVICE_TRIGGERS_LAST_SYNC_TIME, 0L);
    }

    public void saveDTMinimumDelay(long time) {
        this.getSharedPrefs().edit().putLong(PREF_KEY_DEVICE_TRIGGERS_MINIMUM_DELAY, time).apply();
    }

    public long getDTMinimumDelay() {
        return this.getSharedPrefs().getLong(PREF_KEY_DEVICE_TRIGGERS_MINIMUM_DELAY, 0L);
    }

    public void saveDTDNDStartTime(long time) {
        this.getSharedPrefs().edit().putLong(PREF_KEY_DEVICE_TRIGGERS_DND_START_TIME, time).apply();
    }

    public long getDTDNDStartTime() {
        return this.getSharedPrefs().getLong(PREF_KEY_DEVICE_TRIGGERS_DND_START_TIME, -1L);
    }

    public void saveDNDEndTime(long time) {
        this.getSharedPrefs().edit().putLong(PREF_KEY_DEVICE_TRIGGERS_DND_END_TIME, time).apply();
    }

    public long getDNDEndTime() {
        return this.getSharedPrefs().getLong(PREF_KEY_DEVICE_TRIGGERS_DND_END_TIME, -1L);
    }

    void optOutOfNotificationLargeIcon(boolean optOut) {
        this.configMap.put(PREF_KEY_NOTIFICATION_LARGE_ICON_OPT_OUT, optOut);
    }

    public boolean isNotificationLargeIconOptedOut() {
        return this.configMap.containsKey(PREF_KEY_NOTIFICATION_LARGE_ICON_OPT_OUT) && this.configMap.get(PREF_KEY_NOTIFICATION_LARGE_ICON_OPT_OUT) == Boolean.TRUE;
    }

    void optOutOfDataTracking(boolean optOut) {
        this.getSharedPrefs().edit().putBoolean(DATA_TRACKING_OPT_OUT, optOut).apply();
    }

    public boolean isDataTrackingOptedOut() {
        return this.getSharedPrefs().getBoolean(DATA_TRACKING_OPT_OUT, false);
    }

    void optOutOfPushNotification(boolean optOut) {
        this.getSharedPrefs().edit().putBoolean(PUSH_NOTIFICATION_OPT_OUT, optOut).apply();
    }

    public boolean isPushNotificationOptedOut() {
        return this.getSharedPrefs().getBoolean(PUSH_NOTIFICATION_OPT_OUT, false);
    }

    void optOutOfInAppNotification(boolean optOut) {
        this.getSharedPrefs().edit().putBoolean(IN_APP_NOTIFICATION_OPT_OUT, optOut).apply();
    }

    public boolean isInAppOptedOut() {
        return this.getSharedPrefs().getBoolean(IN_APP_NOTIFICATION_OPT_OUT, false);
    }

    void setBackgroundSyncState(boolean backgroundSyncState) {
        this.configMap.put(CONFIG_BACKGROUND_SYNC_STATE, backgroundSyncState);
    }

    public boolean isBackgroundSyncEnabled() {
        return this.configMap.containsKey(CONFIG_BACKGROUND_SYNC_STATE) && this.configMap.get(CONFIG_BACKGROUND_SYNC_STATE) == Boolean.TRUE;
    }

    void setDTBackgroundSyncState(boolean backgroundSyncState) {
        this.configMap.put(CONFIG_DT_BACKGROUND_SYNC_STATE, backgroundSyncState);
    }

    public boolean isDTBackgroundSyncEnabled() {
        return this.configMap.containsKey(CONFIG_DT_BACKGROUND_SYNC_STATE) && this.configMap.get(CONFIG_DT_BACKGROUND_SYNC_STATE) == Boolean.TRUE;
    }

    public void saveUserAttributeUniqueId(String uniqueId) {
        this.getSharedPrefs().edit().putString(PREF_KEY_USER_ATTRIBUTE_UNIQUE_ID, uniqueId).commit();
    }

    public String getUserAttributeUniqueId() {
        return this.getSharedPrefs().getString(PREF_KEY_USER_ATTRIBUTE_UNIQUE_ID, null);
    }

    public void setLastGeoFenceSyncTime(long time) {
        this.getSharedPrefs().edit().putLong(PREF_KEY_LAST_GEO_FENCE_SYNC_TIME, time).apply();
    }

    public long getLastGeoFenceSyncTime() {
        return this.getSharedPrefs().getLong(PREF_KEY_LAST_GEO_FENCE_SYNC_TIME, 0L);
    }

    public void saveMiPushToken(String token) {
        this.getSharedPrefs().edit().putString(PREF_KEY_MI_PUSH_TOKEN, token).apply();
    }

    public String getMiPushToken() {
        return this.getSharedPrefs().getString(PREF_KEY_MI_PUSH_TOKEN, null);
    }

    void setDeviceRegistrationState(boolean registrationState) {
        this.getSharedPrefs().edit().putBoolean(PREF_KEY_IS_DEVICE_REGISTERED, registrationState).apply();
    }

    public boolean isDeviceRegistered() {
        return this.getSharedPrefs().getBoolean(PREF_KEY_IS_DEVICE_REGISTERED, false);
    }

    void setMiTokenServerSentState(boolean serverSentState) {
        this.getSharedPrefs().edit().putBoolean(PREF_KEY_MI_TOKEN_SERVER_SENT_STATE, serverSentState).apply();
    }

    public boolean hasSentMiPushTokenToServer() {
        return this.getSharedPrefs().getBoolean(PREF_KEY_MI_TOKEN_SERVER_SENT_STATE, false);
    }

    void clearPushToken() {
        this.setGCMToken("");
        this.saveMiPushToken(null);
    }

    void setInstantAppState(boolean isInstantAppEnabled) {
        this.configMap.put(CONFIG_INSTANT_APP_STATE, isInstantAppEnabled);
    }

    public boolean isInstantAppEnabled() {
        return this.configMap.containsKey(CONFIG_INSTANT_APP_STATE) && this.configMap.get(CONFIG_INSTANT_APP_STATE) == Boolean.TRUE;
    }

    public void saveUserSession(String sessionString) {
        this.getSharedPrefs().edit().putString(PREF_KEY_USER_SESSION, sessionString).apply();
    }

    String getUserSession() {
        return this.getSharedPrefs().getString(PREF_KEY_USER_SESSION, null);
    }

    public void setRemoteConfiguration(String configurationString) {
        this.getSharedPrefs().edit().putString(PREF_KEY_REMOTE_CONFIGURATION, configurationString).apply();
    }

    public String getRemoteConfiguration() {
        return this.getSharedPrefs().getString(PREF_KEY_REMOTE_CONFIGURATION, null);
    }

    public void setInstallRegistered() {
        this.getSharedPrefs().edit().putBoolean("pref_installed", true).apply();
    }

    boolean isInstallRegistered() {
        return this.getSharedPrefs().getBoolean("pref_installed", false);
    }

    void loadInAppDelayDuration() {
        INAPP_DELAY_DURATION = this.getSharedPrefs().getInt(PREF_KEY_IN_APP_TIME_DIFF, 900);
    }

    public void savePushService(String service) {
        this.getSharedPrefs().edit().putString(PREF_KEY_PUSH_SERVICE, service).apply();
    }

    public String getPushService() {
        return this.getSharedPrefs().getString(PREF_KEY_PUSH_SERVICE, "FCM");
    }

    static {
        CONFIG_LOCATION_SERVICES = "config_location_services";
        PREF_KEY_USER_SESSION = "user_session";
        PREF_KEY_REMOTE_CONFIGURATION = "remote_configuration";
    }
}

