/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core;

import android.content.Context;
import android.net.Uri;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.text.TextUtils;
import com.moe.pushlibrary.exceptions.SDKNotInitializedException;
import com.moe.pushlibrary.utils.MoEHelperUtils;
import com.moengage.core.APIResponse;
import com.moengage.core.ConfigurationCache;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.Logger;
import com.moengage.core.MoERestClient;
import com.moengage.core.rest.Request;
import com.moengage.core.rest.RequestBuilder;
import com.moengage.core.rest.Response;
import com.moengage.core.rest.RestClient;
import com.moengage.core.utils.RestUtils;
import com.moengage.inapp.InAppController;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.HashMap;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONException;
import org.json.JSONObject;

public final class APIManager {
    private APIManager() {
    }

    @Nullable
    static String getGeoFences(Context con, String API, HashMap<String, String> paramsMap) {
        Logger.v("APIManager: getGeoFences: Get geo fences");
        if (MoEHelperUtils.hasPermission(con, "android.permission.ACCESS_FINE_LOCATION") || MoEHelperUtils.hasPermission(con, "android.permission.ACCESS_COARSE_LOCATION")) {
            try {
                if (!ConfigurationCache.getInstance().getRemoteConfiguration().isAppEnabled() || !ConfigurationCache.getInstance().getRemoteConfiguration().isGeofenceEnabled()) {
                    return null;
                }
                MoERestClient client = new MoERestClient(API, con);
                client.addParam(paramsMap);
                client.execute(MoERestClient.RequestMethod.POST);
                if (!APIManager.isHttpStatusOk(client.getResponseCode())) {
                    return null;
                }
                if (APIManager.isValidAPIResponse(client.getResponse())) {
                    return client.getResponse();
                }
            }
            catch (UnsupportedEncodingException e) {
                Logger.f("APIManager: getGeoFences", e);
            }
            catch (Exception e) {
                Logger.f("APIManager: getGeoFences", e);
            }
        }
        return null;
    }

    static void geoFenceHit(Context con, String API, HashMap<String, String> paramsMap) {
        Logger.v("APIManager:Registering a Geofence hit");
        try {
            if (!ConfigurationCache.getInstance().getRemoteConfiguration().isAppEnabled() || !ConfigurationCache.getInstance().getRemoteConfiguration().isGeofenceEnabled()) {
                return;
            }
            MoERestClient client = new MoERestClient(API, con);
            client.addParam(paramsMap);
            client.execute(MoERestClient.RequestMethod.POST);
        }
        catch (UnsupportedEncodingException e) {
            Logger.f("APIManager: geoFenceHit", e);
        }
        catch (IOException e) {
            Logger.f("APIManager: geoFenceHit", e);
        }
        catch (SDKNotInitializedException e) {
            Logger.f("APIManager: geoFenceHit", e);
        }
        catch (Exception e) {
            Logger.f("APIManager: geoFenceHit", e);
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public static String fetchInAppCampaigns(Context con, String API, HashMap<String, String> paramsMap, JSONObject requestBody) {
        try {
            if (!ConfigurationCache.getInstance().getRemoteConfiguration().isAppEnabled() || !ConfigurationCache.getInstance().getRemoteConfiguration().isInAppEnabled()) {
                return null;
            }
            MoERestClient client = new MoERestClient(API, con);
            client.addParam(paramsMap);
            if (requestBody != null) {
                client.addBody(requestBody);
            }
            client.execute(MoERestClient.RequestMethod.POST);
            Logger.v("APIManager: Processing InApp Response - will parse and save data");
            if (!APIManager.isHttpStatusOk(client.getResponseCode())) {
                InAppController.getInstance().trackAPIFailure(InAppController.SYNC_API_FAILURE);
                return null;
            }
            ConfigurationProvider.getInstance(con).setLastInappUpdateTime(System.currentTimeMillis());
            if (!TextUtils.isEmpty((CharSequence)client.getResponse())) {
                Logger.v("APIManager: fetchInAppCampaingn" + client.getResponse());
                return client.getResponse();
            }
        }
        catch (Exception e) {
            Logger.f("APIManager: fetchInAppCampaigns", e);
            InAppController.getInstance().trackAPIFailure(InAppController.SYNC_API_FAILURE);
        }
        return null;
    }

    @Nullable
    static String logASmartEvent(Context con, String API, HashMap<String, String> paramsMap, JSONObject requestBody) {
        try {
            if (!ConfigurationCache.getInstance().getRemoteConfiguration().isAppEnabled() || !ConfigurationCache.getInstance().getRemoteConfiguration().isInAppEnabled()) {
                return null;
            }
            MoERestClient client = new MoERestClient(API, con);
            client.addParam(paramsMap);
            if (requestBody != null) {
                client.addBody(requestBody);
            }
            client.execute(MoERestClient.RequestMethod.POST);
            Logger.v("APIManager: Processing Smart event response");
            if (!APIManager.isHttpStatusOk(client.getResponseCode())) {
                InAppController.getInstance().trackAPIFailure(InAppController.SMART_API_FAILURE);
                return null;
            }
            return client.getResponse();
        }
        catch (Exception e) {
            Logger.f("APIManager: logASmartEvent", e);
            InAppController.getInstance().trackAPIFailure(InAppController.SMART_API_FAILURE);
            return null;
        }
    }

    @Nullable
    static String fetchSingleInApp(Context context, String API, HashMap<String, String> requestParams) {
        try {
            if (!ConfigurationCache.getInstance().getRemoteConfiguration().isAppEnabled() || !ConfigurationCache.getInstance().getRemoteConfiguration().isInAppEnabled()) {
                return null;
            }
            MoERestClient client = new MoERestClient(API, context);
            client.addParam(requestParams);
            client.execute(MoERestClient.RequestMethod.POST);
            if (!APIManager.isHttpStatusOk(client.getResponseCode())) {
                InAppController.getInstance().trackAPIFailure(InAppController.SINGLE_API_FAILURE);
                return null;
            }
            return client.getResponse();
        }
        catch (Exception e) {
            Logger.f("APIManager: fetchInAppCampaigns", e);
            InAppController.getInstance().trackAPIFailure(InAppController.SINGLE_API_FAILURE);
            return null;
        }
    }

    static void uploadLogsToLogEntries(String api, JSONObject jsonObject) {
        try {
            URL url = new URL(api);
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)url.openConnection();
            httpsURLConnection.setDoOutput(true);
            httpsURLConnection.setRequestProperty("Accept-Charset", "UTF-8");
            httpsURLConnection.setRequestProperty("Content-type", "application/json");
            OutputStream output = httpsURLConnection.getOutputStream();
            output.write(jsonObject.toString().getBytes("UTF-8"));
            output.close();
            Logger.v("API Manager : uploadLogsToLogEntries : response" + httpsURLConnection.getResponseCode());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Nullable
    static String fetchMessages(Context context, String API, HashMap<String, String> paramsMap) {
        try {
            if (!ConfigurationCache.getInstance().getRemoteConfiguration().isAppEnabled() || !ConfigurationCache.getInstance().getRemoteConfiguration().isPushAmpEnabled()) {
                return null;
            }
            MoERestClient client = new MoERestClient(API, context);
            client.addParam(paramsMap);
            client.execute(MoERestClient.RequestMethod.POST);
            if (!APIManager.isHttpStatusOk(client.getResponseCode())) {
                return null;
            }
            return client.getResponse();
        }
        catch (Exception e) {
            Logger.f("API Manager : fetchMessages exception", e);
            return null;
        }
    }

    @Nullable
    static APIResponse registerUnregisterDeviceForIntegrationVerification(Context context, String API, HashMap<String, String> paramsMap) {
        try {
            if (!ConfigurationCache.getInstance().getRemoteConfiguration().isAppEnabled()) {
                return null;
            }
            MoERestClient client = new MoERestClient(API, context);
            if (paramsMap != null) {
                client.addParam(paramsMap);
            }
            client.execute(MoERestClient.RequestMethod.POST);
            return new APIResponse(client.getResponse(), client.getResponseCode());
        }
        catch (Exception e) {
            Logger.f("APIManager : registerUnregisterDeviceForIntegrationVerification :", e);
            return null;
        }
    }

    @Nullable
    public static APIResponse deviceTriggerSyncRequest(Context context, String API, HashMap<String, String> paramsMap, JSONObject requestBody) {
        try {
            if (!ConfigurationCache.getInstance().getRemoteConfiguration().isRealTimeTriggerEnabled() || !ConfigurationCache.getInstance().getRemoteConfiguration().isAppEnabled()) {
                return null;
            }
            MoERestClient client = new MoERestClient(API, context);
            if (paramsMap != null) {
                client.addParam(paramsMap);
            }
            if (requestBody != null) {
                client.addBody(requestBody);
            }
            client.execute(MoERestClient.RequestMethod.POST);
            return new APIResponse(client.getResponse(), client.getResponseCode());
        }
        catch (Exception e) {
            Logger.f("MoERestClient: deviceTriggerSyncRequest() : Exception ", e);
            return null;
        }
    }

    static boolean isHttpStatusOk(int responseCode) {
        return 200 == responseCode;
    }

    static boolean isValidAPIResponse(String response) throws JSONException {
        if (TextUtils.isEmpty((CharSequence)response)) {
            return false;
        }
        JSONObject jsonResponse = new JSONObject(response);
        String result = jsonResponse.getString("result");
        return "OK".equals(result);
    }

    @Nullable
    static Response reportAdd(String appId, String path, String requestId, JSONObject body) throws IOException, SDKNotInitializedException {
        Uri.Builder uriBuilder = RestUtils.getBaseUriBuilder().appendEncodedPath(path);
        RequestBuilder requestBuilder = RestUtils.getBaseRequestBuilder(uriBuilder.build(), RequestBuilder.RequestType.POST, appId).addHeader("MOE-REQUEST-ID", requestId).addBody(body);
        RestClient restClient = new RestClient(requestBuilder.build());
        return restClient.executeRequest();
    }

    @Nullable
    public static Response configApi(String appId, JSONObject requestBody) throws IOException, SDKNotInitializedException {
        Uri.Builder uriBuilder = RestUtils.getBaseUriBuilder().appendEncodedPath("v3/sdkconfig/android/").appendEncodedPath(appId);
        Request request = RestUtils.getBaseRequestBuilder(uriBuilder.build(), RequestBuilder.RequestType.POST, appId).addBody(requestBody).build();
        RestClient restClient = new RestClient(request);
        return restClient.executeRequest();
    }
}

