/* ************************************************************************
 *
 * MOENGAGE CONFIDENTIAL
 * __________________
 *
 *  [2014] - [2015] MoEngage Inc.
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of MoEngage Inc. The intellectual and technical concepts
 * contained herein are proprietary to MoEngage Incorporated
 * and its suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from MoEngage Incorporated.
 */
package com.moengage.push;

import android.content.Context;
import android.support.annotation.Nullable;
import com.moengage.core.ConfigurationCache;
import com.moengage.core.Logger;
import com.moengage.core.MoEngage.Builder;

/**
 * This is a Manager class which has callbacks for handling GCM payload handling and token refresh
 *
 * @author MoEngage (abhishek@moengage.com)
 * @since 5.3
 */
public class PushManager {

  private PushBaseHandler pushBaseHandler;

  private PushManager() {
    //check for PushHandler on class path
    loadPushHandler();
  }

  private void loadPushHandler() {
    try {
      //TODO think of adding play services check here
      if (!ConfigurationCache.getInstance().getBaiduPushState()) {
        try {
          Class baseHandler = Class.forName("com.moengage.pushbase.PushBaseHandlerImpl");
          pushBaseHandler = (PushBaseHandler) baseHandler.newInstance();
          Class handler = Class.forName("com.moengage.firebase.PushHandlerImpl");
          pushHandler = (PushHandler) handler.newInstance();
          Logger.v("PushManager:loadPushHandler FCM Enabled");
        } catch (Exception e) {
          Class handler = Class.forName("com.moengage.push.gcm.PushHandlerImpl");
          pushHandler = (PushHandler) handler.newInstance();
          Logger.v("PushManager:loadPushHandler GCM Enabled");
        }
      } else {
        Class handler = Class.forName("com.moengage.baidu.PushHandlerImpl");
        pushHandler = (PushHandler) handler.newInstance();
        Logger.v("PushManager:loadPushHandler Baidu Enabled");
      }
    } catch (Exception e) {
      Logger.e("PushManager : loadPushHandler : did not find supported module: " + e.getMessage());
    }
  }

  private static PushManager _INSTANCE = null;

  /**
   * Returns a singleton instance of {@link PushManager}
   * @return instance of {@link PushManager}
   */
  public static PushManager getInstance() {
    if (null == _INSTANCE) {
      _INSTANCE = new PushManager();
    }
    return _INSTANCE;
  }

  /**
   * Use MoEPushHelper.getInstance().setMessageListener()
   */
  @Deprecated public void setMessageListener(Object messageListener) {
    if (pushBaseHandler != null) {
      pushBaseHandler.setPushMessageListener(messageListener);
    }
  }

  /**
   * Helper API to pass the push token to the MoEngage platform.
   *
   * @param context instance of {@link Context}
   * @param token Generated Push Token.
   */
  public void refreshToken(Context context, String token) {
    TokenHandler.getInstance().processToken(context, token, "App");
  }

  @Nullable
  public PushHandler getPushHandler() {
    return pushHandler;
  }

  private PushHandler pushHandler;

  /**
   * This API is deprecated use {@link Builder#optOutBackStackBuilder()}
   */
  @Deprecated
  public final void optoutBackStackBuilder(Boolean value) {
    ConfigurationCache.getInstance().setBackStackOptOut(value);
  }

  /**
   * Interface definition for a callback which is invoked whenever a push token is generated.
   */
  public interface OnTokenReceivedListener {
    /**
     * Called whenever push token is generated.
     *
     * @param token Push token.
     */
    void onTokenReceived(String token);
  }

  /**
   * Register a callback to be invoked whenever a token is generated.
   *
   * @param tokenObserver instance of {@link OnTokenReceivedListener}
   */
  public void setTokenObserver(OnTokenReceivedListener tokenObserver) {
    TokenHandler.getInstance().setTokenListener(tokenObserver);
  }

  /**
   * This API is deprecated use {@link Builder#optOutMoEngageExtras()}
   */
  @Deprecated
  public final void optOutMoEngageExtras(boolean value){
    ConfigurationCache.getInstance().setExtrasOptOut(value);
  }

}
