package com.moengage.core.remoteconfig;

import android.content.Context;
import android.text.TextUtils;
import com.moengage.core.APIManager;
import com.moengage.core.Logger;
import com.moengage.core.MoEConstants;
import com.moengage.core.MoEUtils;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import com.moengage.core.rest.Response;
import com.moengage.core.utils.RestUtils;
import org.json.JSONObject;

/**
 * @author Umang Chamaria
 */
public class ConfigApiNetworkTask extends SDKTask {
  private static final String TAG = "ConfigApiNetworkTask";
  private Context mContext;

  public ConfigApiNetworkTask(Context context) {
    super(context);
    mContext = context;
  }

  @Override public TaskResult execute() {
    Logger.v("ConfigApiNetworkTask : executing Task");
    try {
      String appId = MoEUtils.getAppId(mContext);
      if (TextUtils.isEmpty(appId)) {
        Logger.e(TAG + " execute(): Cannot make config api sync request without app id.");
        return taskResult;
      }

      JSONObject requestBody = new JSONObject();
      requestBody.put(MoEConstants.REQUEST_ATTR_QUERY_PARAMS,
          RestUtils.getDefaultParams(mContext).build());
      Response response = APIManager.configApi(appId, requestBody);

      RemoteConfigResponseHandler handler = new RemoteConfigResponseHandler();
      boolean status = handler.handleConfigApiResponse(mContext, response);

      taskResult.setIsSuccess(status);
    } catch (Exception e) {
      Logger.f("ConfigApiNetworkTask : execute", e);
    }
    Logger.v("ConfigApiNetworkTask : execution completed");
    return taskResult;
  }

  @Override public String getTaskTag() {
    return TAG_SYNC_CONFIG_API;
  }

  @Override public boolean isSynchronous() {
    return true;
  }

}
