package com.moengage.core.model;

import android.support.annotation.Nullable;
import com.moengage.core.Logger;
import com.moengage.core.MoEUtils;
import com.moengage.core.utils.JsonBuilder;
import org.json.JSONArray;
import org.json.JSONObject;

/**
 * @author Umang Chamaria
 * Date: 2019-05-21
 */
public class UserSession {

  private static final String TAG = "UserSession";

  private String sessionId;
  private String startTime;
  private TrafficSource trafficSource;
  private long lastInteractionTime;
  private boolean isBackgroundInitiated;

  public UserSession() {
  }

  public String getSessionId() {
    return sessionId;
  }

  public void setSessionId(String sessionId) {
    this.sessionId = sessionId;
  }

  public String getStartTime() {
    return startTime;
  }

  public void setStartTime(String startTime) {
    this.startTime = startTime;
  }

  public long getLastInteractionTime() {
    return lastInteractionTime;
  }

  public void setLastInteractionTime(long lastInteractionTime) {
    this.lastInteractionTime = lastInteractionTime;
  }

  public TrafficSource getSource() {
    return trafficSource;
  }

  public void setSource(TrafficSource trafficSource) {
    this.trafficSource = trafficSource;
  }

  public boolean isBackgroundInitiated() {
    return isBackgroundInitiated;
  }

  public void setBackgroundInitiated(boolean isBackgroundInitiated) {
    this.isBackgroundInitiated = isBackgroundInitiated;
  }

  @Nullable
  public static JSONObject toJson(UserSession userSession) {
    try {
      JsonBuilder builder = new JsonBuilder();
      builder.putString(SESSION_ID, userSession.getSessionId())
          .putString(START_TIME, userSession.getStartTime())
          .putLong(LAST_INTERACTION_TIME, userSession.getLastInteractionTime())
          .putInt(INITIATED_IN_BACKGROUND, userSession.isBackgroundInitiated() ? 1 : 0);
      JSONArray sourceArray = new JSONArray();
      JSONObject sourceJson = TrafficSource.toJson(userSession.getSource());
      if (MoEUtils.hasKeys(sourceJson)) {
        sourceArray.put(sourceJson);
      }
      if (sourceArray.length() > 0) {
        builder.putJsonArray(SOURCE_ARRAY, sourceArray);
      }

      return builder.build();
    } catch (Exception e) {
      Logger.e(TAG + " toJson() : Exception: ", e);
    }
    return null;
  }

  @Nullable
  public static UserSession fromJsonString(String jsonString) {
    try {
      if (MoEUtils.isNullOrEmpty(jsonString)) return null;
      JSONObject jsonObject = new JSONObject(jsonString);
      UserSession session = new UserSession();
      session.setSessionId(jsonObject.getString(SESSION_ID));
      session.setStartTime(jsonObject.getString(START_TIME));
      session.setLastInteractionTime(jsonObject.getLong(LAST_INTERACTION_TIME));
      if (jsonObject.has(SOURCE_ARRAY)) {
        JSONArray sourceArray = jsonObject.getJSONArray(SOURCE_ARRAY);
        JSONObject sourceJson = sourceArray.getJSONObject(0);
        TrafficSource source = TrafficSource.fromJson(sourceJson);
        if (source != null) {
          session.setSource(source);
        }
      }
      session.setBackgroundInitiated(jsonObject.getInt(INITIATED_IN_BACKGROUND) == 1);
      return session;
    } catch (Exception e) {
      Logger.e(TAG + " fromJsonString() : Exception: ", e);
    }
    return null;
  }

  @Override public String toString() {
    return "{" +
        "sessionId : '" + sessionId + '\'' +
        ", startTime : '" + startTime + '\'' +
        ", trafficSource : " + trafficSource +
        ", lastInteractionTime : " + lastInteractionTime +
        ", isBackgroundInitiated : " + isBackgroundInitiated +
        '}';
  }

  private static final String SESSION_ID = "session_id";
  private static final String START_TIME = "start_time";
  public static final String LAST_INTERACTION_TIME = "last_interaction_time";
  public static final String SOURCE_ARRAY = "source_array";
  public static final String INITIATED_IN_BACKGROUND = "background_initiated";
}
