package com.moengage.core;

import android.content.Context;
import com.moe.pushlibrary.PayloadBuilder;
import com.moe.pushlibrary.utils.MoEHelperConstants;
import com.moengage.core.events.MoEEventManager;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import java.util.Date;

/**
 * @author Umang Chamaria
 * Date: 2020-02-01
 */
public class TrackAppStatus extends SDKTask {
  private static final String TAG = "TrackAppStatus";

  private boolean existing;

  public TrackAppStatus(Context context, boolean existing) {
    super(context);
    this.existing = existing;
  }

  @Override public TaskResult execute() {
    try {
      Logger.v(TAG + " execute() : Tracking App status.");
      if (!ConfigurationCache.getInstance().getRemoteConfiguration().isAppEnabled()) return taskResult;
      ConfigurationProvider configProvider = ConfigurationProvider.getInstance(context);
      boolean installRegistered =
          ConfigurationProvider.getInstance(context).isInstallRegistered();
      int currentVersion = configProvider.getAppVersion();
      if (existing) {
        int prevVersion = configProvider.getStoredAppVersion();
        if (currentVersion == prevVersion) {
          //already stored
          return taskResult;
        }
        configProvider.storeAppVersion(currentVersion);
        PayloadBuilder eventObj =
            new PayloadBuilder().putAttrInt(MoEHelperConstants.FROM_VERSION, prevVersion)
                .putAttrInt(MoEHelperConstants.TO_VERSION, currentVersion)
                .putAttrDate(MoEHelperConstants.TIME_OF_UPDATE, new Date());
        MoEEventManager.getInstance(context).trackEvent(MoEHelperConstants.EVENT_APP_UPD, eventObj);
        Logger.v(TAG + " execute() : Tracking Update");
      } else if (!installRegistered) {
        configProvider.storeAppVersion(currentVersion);
        PayloadBuilder builder = new PayloadBuilder();
        builder.putAttrInt(MoEHelperConstants.VERSION, currentVersion)
            .putAttrInt(MoEConstants.GENERIC_PARAM_V2_KEY_LIBVERSION,
                MoEHelperConstants.LIB_VERSION)
            .putAttrLong(MoEHelperConstants.TIME_OF_INSTALL, System.currentTimeMillis())
            .putAttrString(MoEConstants.GENERIC_PARAM_V2_KEY_OS,
                MoEConstants.GENERIC_PARAM_V2_VALUE_OS);
        MoEEventManager.getInstance(context)
            .trackEvent(MoEHelperConstants.EVENT_APP_INSTALL, builder);
        Logger.v(TAG + " execute() : Tracking Install");
      }
      Logger.v(TAG + " execute() : Completed tracking app status.");
    } catch (Exception e) {
      Logger.e( TAG + " execute() : ", e);
    }
    return taskResult;
  }

  @Override public String getTaskTag() {
    return TAG_TRACK_APP_STATUS;
  }

  @Override public boolean isSynchronous() {
    return true;
  }
}
