/*
 * Decompiled with CFR 0.152.
 */
package com.moe.pushlibrary.providers;

import android.content.ContentProvider;
import android.content.ContentProviderOperation;
import android.content.ContentProviderResult;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.OperationApplicationException;
import android.content.UriMatcher;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteQueryBuilder;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.moe.pushlibrary.providers.MoEDataContract;
import com.moe.pushlibrary.providers.MoEDatabaseHelper;
import com.moengage.core.Logger;
import com.moengage.core.MoEConstants;
import java.util.ArrayList;
import java.util.HashMap;

public class MoEProvider
extends ContentProvider {
    private static final String TAG = "MoEProvider";
    private static final int MESSAGES = 1;
    private static final int MESSAGE_ID = 2;
    private static final int DATAPOINTS = 3;
    private static final int DATAPOINT_ID = 4;
    private static final int INAPPS = 5;
    private static final int INAPP_ID = 6;
    private static final int USER_ATTRIBUTES = 9;
    private static final int USER_ATTRIBUTES_ID = 10;
    private static final int CAMPAIGN_IDS = 11;
    private static final int CAMPAIGN_ID = 12;
    private static final int DATA_BATCHES = 13;
    private static final int DATA_BATCH = 14;
    private static final int DEVICE_TRIGGERS = 15;
    private static final int DEVICE_TRIGGER = 16;
    private static final int ATTRIBUTE_CACHE = 17;
    private static final int ATTRIBUTE_CACHE_ID = 18;
    private static UriMatcher sUriMatcher;
    private static HashMap<String, String> sMessageProjectionMap;
    private static HashMap<String, String> sEventProjectionMap;
    private static HashMap<String, String> sInAppProjectionMap;
    private static HashMap<String, String> sUserAttributeProjectionMap;
    private static HashMap<String, String> sCampaignListProjectionMap;
    private static HashMap<String, String> sBatchDataProjectionMap;
    private static HashMap<String, String> sDTProjectionMap;
    private static HashMap<String, String> sAttributeCacheMap;
    private MoEDatabaseHelper mOpenHelper = null;

    public boolean onCreate() {
        this.mOpenHelper = new MoEDatabaseHelper(this.getContext());
        this.initializeUriMatcher();
        Logger.d("MoEProvider: Provider created");
        return true;
    }

    private void initializeUriMatcher() {
        sUriMatcher = new UriMatcher(-1);
        Context context = this.getContext();
        sUriMatcher.addURI(MoEDataContract.getAuthority(context), "messages", 1);
        sUriMatcher.addURI(MoEDataContract.getAuthority(context), "messages/#", 2);
        sUriMatcher.addURI(MoEDataContract.getAuthority(context), "datapoints", 3);
        sUriMatcher.addURI(MoEDataContract.getAuthority(context), "datapoints/#", 4);
        sUriMatcher.addURI(MoEDataContract.getAuthority(context), "inapps", 5);
        sUriMatcher.addURI(MoEDataContract.getAuthority(context), "inapps/#", 6);
        sUriMatcher.addURI(MoEDataContract.getAuthority(context), "userattributes/", 9);
        sUriMatcher.addURI(MoEDataContract.getAuthority(context), "userattributes/#", 10);
        sUriMatcher.addURI(MoEDataContract.getAuthority(context), "campaignlist/", 11);
        sUriMatcher.addURI(MoEDataContract.getAuthority(context), "campaignlist/#", 12);
        sUriMatcher.addURI(MoEDataContract.getAuthority(context), "batchdata/", 13);
        sUriMatcher.addURI(MoEDataContract.getAuthority(context), "batchdata/#", 14);
        sUriMatcher.addURI(MoEDataContract.getAuthority(context), "dtcampaign", 15);
        sUriMatcher.addURI(MoEDataContract.getAuthority(context), "dtcampaign/#", 16);
        sUriMatcher.addURI(MoEDataContract.getAuthority(context), "attributecache/", 17);
        sUriMatcher.addURI(MoEDataContract.getAuthority(context), "attributecache/#", 18);
    }

    public String getType(@NonNull Uri uri) {
        switch (sUriMatcher.match(uri)) {
            case 1: {
                return "vnd.android.cursor.dir/vnd.moe.message";
            }
            case 2: {
                return "vnd.android.cursor.item/vnd.moe.message";
            }
            case 3: {
                return "vnd.android.cursor.dir/vnd.moe.datapoints";
            }
            case 4: {
                return "vnd.android.cursor.item/vnd.moe.datapoint";
            }
            case 5: {
                return "vnd.android.cursor.dir/vnd.moe.inapps";
            }
            case 6: {
                return "vnd.android.cursor.item/vnd.moe.inapp";
            }
            case 9: {
                return "vnd.android.cursor.dir/vnd.moe.userattributes";
            }
            case 10: {
                return "vnd.android.cursor.item/vnd.moe.userattributes";
            }
            case 11: {
                return "vnd.android.cursor.dir/vnd.moe.campaignlist";
            }
            case 12: {
                return "vnd.android.cursor.item/vnd.moe.campaignlist";
            }
            case 13: {
                return "vnd.android.cursor.dir/vnd.moe.batchdata";
            }
            case 14: {
                return "vnd.android.cursor.item/vnd.moe.batchdata";
            }
            case 15: {
                return "vnd.android.cursor.dir/vnd.moe.dtcampaign";
            }
            case 16: {
                return "vnd.android.cursor.item/vnd.moe.dtcampaign";
            }
            case 17: {
                return "vnd.android.cursor.dir/vnd.moe.attributecache";
            }
            case 18: {
                return "vnd.android.cursor.item/vnd.moe.attributecache";
            }
        }
        Logger.f("No Matching URI found");
        return null;
    }

    public Cursor query(@NonNull Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        SQLiteDatabase db = this.mOpenHelper.getReadableDatabase();
        this.updateIfRequired(db);
        SQLiteQueryBuilder qb = new SQLiteQueryBuilder();
        String orderBy = sortOrder;
        String limit = uri.getQueryParameter("LIMIT");
        switch (sUriMatcher.match(uri)) {
            case 2: {
                qb.appendWhere((CharSequence)("_id=" + (String)uri.getPathSegments().get(1)));
            }
            case 1: {
                qb.setProjectionMap(sMessageProjectionMap);
                qb.setTables("MESSAGES");
                if (!TextUtils.isEmpty((CharSequence)sortOrder)) break;
                orderBy = "gtime DESC";
                break;
            }
            case 4: {
                qb.appendWhere((CharSequence)("_id=" + (String)uri.getPathSegments().get(1)));
            }
            case 3: {
                qb.setProjectionMap(sEventProjectionMap);
                qb.setTables("DATAPOINTS");
                break;
            }
            case 6: {
                qb.appendWhere((CharSequence)("_id=" + (String)uri.getPathSegments().get(1)));
            }
            case 5: {
                qb.setProjectionMap(sInAppProjectionMap);
                qb.setTables("INAPPMSG");
                if (!TextUtils.isEmpty((CharSequence)sortOrder)) break;
                orderBy = "priority DESC, gtime DESC";
                break;
            }
            case 9: {
                qb.setProjectionMap(sUserAttributeProjectionMap);
                qb.setTables("USERATTRIBUTES");
                break;
            }
            case 11: {
                qb.setProjectionMap(sCampaignListProjectionMap);
                qb.setTables("CAMPAIGNLIST");
                break;
            }
            case 13: {
                qb.setProjectionMap(sBatchDataProjectionMap);
                qb.setTables("BATCH_DATA");
                break;
            }
            case 15: {
                qb.setProjectionMap(sDTProjectionMap);
                qb.setTables("DEVICE_TRIGGERS");
                break;
            }
            case 17: {
                qb.setProjectionMap(sAttributeCacheMap);
                qb.setTables("ATTRIBUTE_CACHE");
                break;
            }
            default: {
                Logger.f("Unknown URI " + uri);
            }
        }
        Cursor c = null;
        try {
            c = qb.query(db, projection, selection, selectionArgs, null, null, orderBy, limit);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return c;
    }

    public Uri insert(Uri uri, ContentValues values) {
        Uri newUri = null;
        try {
            if (null == values) {
                return null;
            }
            SQLiteDatabase db = this.mOpenHelper.getWritableDatabase();
            this.updateIfRequired(db);
            long rowId = 0L;
            newUri = null;
            switch (sUriMatcher.match(uri)) {
                case 1: {
                    rowId = db.insert("MESSAGES", null, values);
                    if (rowId <= 0L) break;
                    newUri = ContentUris.withAppendedId((Uri)MoEDataContract.MessageEntity.getContentUri(this.getContext()), (long)rowId);
                    break;
                }
                case 3: {
                    rowId = db.insert("DATAPOINTS", null, values);
                    if (rowId <= 0L) break;
                    newUri = ContentUris.withAppendedId((Uri)MoEDataContract.DatapointEntity.getContentUri(this.getContext()), (long)rowId);
                    break;
                }
                case 5: {
                    rowId = db.insert("INAPPMSG", null, values);
                    if (rowId <= 0L) break;
                    newUri = ContentUris.withAppendedId((Uri)MoEDataContract.InAppMessageEntity.getContentUri(this.getContext()), (long)rowId);
                    break;
                }
                case 9: {
                    rowId = db.insert("USERATTRIBUTES", null, values);
                    if (rowId <= 0L) break;
                    newUri = ContentUris.withAppendedId((Uri)MoEDataContract.UserAttributeEntity.getContentUri(this.getContext()), (long)rowId);
                    break;
                }
                case 11: {
                    rowId = db.insert("CAMPAIGNLIST", null, values);
                    if (rowId <= 0L) break;
                    newUri = ContentUris.withAppendedId((Uri)MoEDataContract.UserAttributeEntity.getContentUri(this.getContext()), (long)rowId);
                    break;
                }
                case 13: {
                    rowId = db.insert("BATCH_DATA", null, values);
                    if (rowId <= 0L) break;
                    newUri = ContentUris.withAppendedId((Uri)MoEDataContract.BatchDataEntity.getContentUri(this.getContext()), (long)rowId);
                    break;
                }
                case 15: {
                    rowId = db.insert("DEVICE_TRIGGERS", null, values);
                    if (rowId <= 0L) break;
                    newUri = ContentUris.withAppendedId((Uri)MoEDataContract.DTEntity.getContentUri(this.getContext()), (long)rowId);
                    break;
                }
                case 17: {
                    rowId = db.insert("ATTRIBUTE_CACHE", null, values);
                    if (rowId <= 0L) break;
                    newUri = ContentUris.withAppendedId((Uri)MoEDataContract.AttributeCacheEntity.getContentUri(this.getContext()), (long)rowId);
                    break;
                }
                default: {
                    Logger.f("Unknown URI " + uri);
                }
            }
            if (null != newUri) {
                Logger.v("MoEProvider: Added new record : " + newUri.toString());
                this.getContext().getContentResolver().notifyChange(uri, null);
            } else {
                Logger.f("MoEProvider: Failed to add new record");
            }
        }
        catch (Exception e) {
            Logger.e("MoEProvider insert() : ", e);
        }
        return newUri;
    }

    public void updateIfRequired(SQLiteDatabase db) {
        if (MoEConstants.dbUpdateRequired) {
            this.mOpenHelper.addMSGTagIfRequiredInbox(db);
            this.mOpenHelper.addUserAttributesTableIfRequired(db);
            this.mOpenHelper.addCampaignListTableIfRequired(db);
            this.mOpenHelper.addBatchDataTableIfRequired(db);
            this.mOpenHelper.addDeviceTriggerTableIfRequired(db);
            this.mOpenHelper.addAttributeCacheTableIfRequired(db);
            this.mOpenHelper.addCampaignIdToMessageTable(db);
            MoEConstants.dbUpdateRequired = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public ContentProviderResult[] applyBatch(@NonNull ArrayList<ContentProviderOperation> operations) throws OperationApplicationException {
        ContentProviderResult[] result = new ContentProviderResult[operations.size()];
        int i = 0;
        SQLiteDatabase db = this.mOpenHelper.getWritableDatabase();
        this.updateIfRequired(db);
        db.beginTransaction();
        try {
            for (ContentProviderOperation operation : operations) {
                result[i++] = operation.apply((ContentProvider)this, result, i);
            }
            db.setTransactionSuccessful();
        }
        catch (OperationApplicationException e) {
            Logger.f("MoEProvider : batch failed: ", e);
        }
        catch (Exception e) {
            Logger.f("MoEProvider : batch failed: ", e);
        }
        finally {
            db.endTransaction();
        }
        return result;
    }

    public int delete(Uri uri, String selection, String[] selectionArgs) {
        int count = 0;
        try {
            if (null == uri) {
                return 0;
            }
            SQLiteDatabase db = this.mOpenHelper.getWritableDatabase();
            this.updateIfRequired(db);
            switch (sUriMatcher.match(uri)) {
                case 1: {
                    count = db.delete("MESSAGES", selection, selectionArgs);
                    break;
                }
                case 2: {
                    String noteId = (String)uri.getPathSegments().get(1);
                    count = db.delete("MESSAGES", "_id=" + noteId + (!TextUtils.isEmpty((CharSequence)selection) ? " AND " + selection : ""), selectionArgs);
                    break;
                }
                case 3: {
                    count = db.delete("DATAPOINTS", selection, selectionArgs);
                    break;
                }
                case 4: {
                    String eventId = (String)uri.getPathSegments().get(1);
                    count = db.delete("DATAPOINTS", "_id = " + eventId + (!TextUtils.isEmpty((CharSequence)selection) ? " AND " + selection : ""), selectionArgs);
                    break;
                }
                case 5: {
                    count = db.delete("INAPPMSG", selection, selectionArgs);
                    break;
                }
                case 6: {
                    String inappId = (String)uri.getPathSegments().get(1);
                    count = db.delete("INAPPMSG", "_id=" + inappId + (!TextUtils.isEmpty((CharSequence)selection) ? " AND " + selection : ""), selectionArgs);
                    break;
                }
                case 9: {
                    count = db.delete("USERATTRIBUTES", selection, selectionArgs);
                    break;
                }
                case 10: {
                    String attributeId = (String)uri.getPathSegments().get(1);
                    count = db.delete("USERATTRIBUTES", "_id=" + attributeId + (!TextUtils.isEmpty((CharSequence)selection) ? " AND " + selection : ""), selectionArgs);
                    break;
                }
                case 11: {
                    count = db.delete("CAMPAIGNLIST", selection, selectionArgs);
                    break;
                }
                case 12: {
                    String campaignId = (String)uri.getPathSegments().get(1);
                    count = db.delete("CAMPAIGNLIST", "_id=" + campaignId + (!TextUtils.isEmpty((CharSequence)selection) ? " AND " + selection : ""), selectionArgs);
                    break;
                }
                case 13: {
                    count = db.delete("BATCH_DATA", selection, selectionArgs);
                    break;
                }
                case 14: {
                    String batchId = (String)uri.getPathSegments().get(1);
                    count = db.delete("BATCH_DATA", "_id=" + batchId + (!TextUtils.isEmpty((CharSequence)selection) ? " AND " + selection : ""), selectionArgs);
                    break;
                }
                case 15: {
                    count = db.delete("DEVICE_TRIGGERS", selection, selectionArgs);
                    break;
                }
                case 16: {
                    String triggerId = (String)uri.getPathSegments().get(1);
                    count = db.delete("DEVICE_TRIGGERS", "_id=" + triggerId + (!TextUtils.isEmpty((CharSequence)selection) ? " AND " + selection : ""), selectionArgs);
                    break;
                }
                case 17: {
                    count = db.delete("ATTRIBUTE_CACHE", selection, selectionArgs);
                    break;
                }
                case 18: {
                    String cachedAttributeId = (String)uri.getPathSegments().get(1);
                    count = db.delete("ATTRIBUTE_CACHE", "_id=" + cachedAttributeId + (!TextUtils.isEmpty((CharSequence)selection) ? " AND " + selection : ""), selectionArgs);
                    break;
                }
                default: {
                    Logger.f("Unknown URI " + uri);
                }
            }
            this.getContext().getContentResolver().notifyChange(uri, null);
            Logger.v("MoEProvider: Deleted " + count + " record(s) for URI: " + uri.toString());
        }
        catch (Exception e) {
            Logger.e("MoEProvider delete() : ", e);
        }
        return count;
    }

    public int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        int count = 0;
        try {
            SQLiteDatabase db = this.mOpenHelper.getWritableDatabase();
            this.updateIfRequired(db);
            switch (sUriMatcher.match(uri)) {
                case 1: {
                    count = db.update("MESSAGES", values, selection, selectionArgs);
                    break;
                }
                case 2: {
                    String msgId = (String)uri.getPathSegments().get(1);
                    count = db.update("MESSAGES", values, "_id=" + msgId + (!TextUtils.isEmpty((CharSequence)selection) ? " AND " + selection : ""), selectionArgs);
                    break;
                }
                case 3: {
                    count = db.update("DATAPOINTS", values, selection, selectionArgs);
                    break;
                }
                case 4: {
                    String eventId = (String)uri.getPathSegments().get(1);
                    count = db.update("DATAPOINTS", values, "_id=" + eventId + (!TextUtils.isEmpty((CharSequence)selection) ? " AND " + selection : ""), selectionArgs);
                    break;
                }
                case 5: {
                    count = db.update("INAPPMSG", values, selection, selectionArgs);
                    break;
                }
                case 6: {
                    String inAppId = (String)uri.getPathSegments().get(1);
                    count = db.update("INAPPMSG", values, "_id=" + inAppId + (!TextUtils.isEmpty((CharSequence)selection) ? " AND " + selection : ""), selectionArgs);
                    break;
                }
                case 9: {
                    count = db.update("USERATTRIBUTES", values, selection, selectionArgs);
                    break;
                }
                case 10: {
                    String attributeId = (String)uri.getPathSegments().get(1);
                    count = db.update("USERATTRIBUTES", values, "_id=" + attributeId + (!TextUtils.isEmpty((CharSequence)selection) ? " AND " + selection : ""), selectionArgs);
                    break;
                }
                case 11: {
                    count = db.update("CAMPAIGNLIST", values, selection, selectionArgs);
                    break;
                }
                case 12: {
                    String campaignId = (String)uri.getPathSegments().get(1);
                    count = db.update("CAMPAIGNLIST", values, "_id=" + campaignId + (!TextUtils.isEmpty((CharSequence)selection) ? " AND " + selection : ""), selectionArgs);
                    break;
                }
                case 13: {
                    count = db.update("BATCH_DATA", values, selection, selectionArgs);
                    break;
                }
                case 14: {
                    String batchId = (String)uri.getPathSegments().get(1);
                    count = db.update("BATCH_DATA", values, "_id=" + batchId + (!TextUtils.isEmpty((CharSequence)selection) ? " AND " + selection : ""), selectionArgs);
                    break;
                }
                case 15: {
                    count = db.update("DEVICE_TRIGGERS", values, selection, selectionArgs);
                    break;
                }
                case 16: {
                    String triggerId = (String)uri.getPathSegments().get(1);
                    count = db.update("DEVICE_TRIGGERS", values, "_id=" + triggerId + (!TextUtils.isEmpty((CharSequence)selection) ? " AND " + selection : ""), selectionArgs);
                    break;
                }
                case 17: {
                    count = db.update("ATTRIBUTE_CACHE", values, selection, selectionArgs);
                    break;
                }
                case 18: {
                    String cachedAttributeId = (String)uri.getPathSegments().get(1);
                    count = db.update("ATTRIBUTE_CACHE", values, "_id=" + cachedAttributeId + (!TextUtils.isEmpty((CharSequence)selection) ? " AND " + selection : ""), selectionArgs);
                    break;
                }
                default: {
                    Logger.f("Unknown URI " + uri);
                }
            }
            this.getContext().getContentResolver().notifyChange(uri, null);
            Logger.v("MoEProvider: Updated " + count + " record(s)");
        }
        catch (Exception e) {
            Logger.e("MoEProvider update() : ", e);
        }
        return count;
    }

    static {
        sMessageProjectionMap = new HashMap();
        sMessageProjectionMap.put("_id", "_id");
        sMessageProjectionMap.put("gtime", "gtime");
        sMessageProjectionMap.put("msg", "msg");
        sMessageProjectionMap.put("msgclicked", "msgclicked");
        sMessageProjectionMap.put("msgttl", "msgttl");
        sMessageProjectionMap.put("msg_tag", "msg_tag");
        sMessageProjectionMap.put("campaign_id", "campaign_id");
        sEventProjectionMap = new HashMap();
        sEventProjectionMap.put("_id", "_id");
        sEventProjectionMap.put("gtime", "gtime");
        sEventProjectionMap.put("details", "details");
        sInAppProjectionMap = new HashMap();
        sInAppProjectionMap.put("_id", "_id");
        sInAppProjectionMap.put("gtime", "gtime");
        sInAppProjectionMap.put("campaign_id", "campaign_id");
        sInAppProjectionMap.put("align_type", "align_type");
        sInAppProjectionMap.put("inapp_type", "inapp_type");
        sInAppProjectionMap.put("ttl", "ttl");
        sInAppProjectionMap.put("min_delay", "min_delay");
        sInAppProjectionMap.put("max_times", "max_times");
        sInAppProjectionMap.put("shown_count", "shown_count");
        sInAppProjectionMap.put("persistent", "persistent");
        sInAppProjectionMap.put("priority", "priority");
        sInAppProjectionMap.put("context", "context");
        sInAppProjectionMap.put("last_shown", "last_shown");
        sInAppProjectionMap.put("is_clicked", "is_clicked");
        sInAppProjectionMap.put("has_errors", "has_errors");
        sInAppProjectionMap.put("auto_dismiss", "auto_dismiss");
        sInAppProjectionMap.put("cancelable", "cancelable");
        sInAppProjectionMap.put("content", "content");
        sInAppProjectionMap.put("show_only_in", "show_only_in");
        sInAppProjectionMap.put("status", "status");
        sInAppProjectionMap.put("dim_style", "dim_style");
        sUserAttributeProjectionMap = new HashMap();
        sUserAttributeProjectionMap.put("_id", "_id");
        sUserAttributeProjectionMap.put("gtime", "gtime");
        sUserAttributeProjectionMap.put("attribute_name", "attribute_name");
        sUserAttributeProjectionMap.put("attribute_value", "attribute_value");
        sCampaignListProjectionMap = new HashMap();
        sCampaignListProjectionMap.put("_id", "_id");
        sCampaignListProjectionMap.put("campaign_id", "campaign_id");
        sCampaignListProjectionMap.put("ttl", "ttl");
        sBatchDataProjectionMap = new HashMap();
        sBatchDataProjectionMap.put("_id", "_id");
        sBatchDataProjectionMap.put("batch_data", "batch_data");
        sDTProjectionMap = new HashMap();
        sDTProjectionMap.put("_id", "_id");
        sDTProjectionMap.put("campaign_id", "campaign_id");
        sDTProjectionMap.put("event_name", "event_name");
        sDTProjectionMap.put("payload", "payload");
        sDTProjectionMap.put("campaign_payload", "campaign_payload");
        sDTProjectionMap.put("campaign_type", "campaign_type");
        sDTProjectionMap.put("max_count", "max_count");
        sDTProjectionMap.put("minimum_delay", "minimum_delay");
        sDTProjectionMap.put("should_show_offline", "should_show_offline");
        sDTProjectionMap.put("max_sync_delay_time", "max_sync_delay_time");
        sDTProjectionMap.put("expiry_time", "expiry_time");
        sDTProjectionMap.put("priority", "priority");
        sDTProjectionMap.put("last_show_time", "last_show_time");
        sDTProjectionMap.put("show_count", "show_count");
        sDTProjectionMap.put("last_updated_time", "last_updated_time");
        sDTProjectionMap.put("status", "status");
        sDTProjectionMap.put("should_ignore_dnd", "should_ignore_dnd");
        sDTProjectionMap.put("delay_before_showing", "delay_before_showing");
        sAttributeCacheMap = new HashMap();
        sAttributeCacheMap.put("_id", "_id");
        sAttributeCacheMap.put("name", "name");
        sAttributeCacheMap.put("value", "value");
        sAttributeCacheMap.put("last_tracked_time", "last_tracked_time");
        sAttributeCacheMap.put("datatype", "datatype");
    }
}

