package com.moengage.core;

import android.content.Context;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;

/**
 * (non-JavaDoc)
 * Logs an impression for notification clicks
 * Service Constant - MSG_NOTIFICATION_CLICKED
 * @author Umang Chamaria
 */
class NotificationClickedTask extends SDKTask {
  private long time;

  NotificationClickedTask(Context context, long time) {
    super(context);
    this.time = time;
  }

  @Override public TaskResult execute() {
    Logger.v("NotificationClickedTask : executing task");
    MoEDAO.getInstance(context).setMessageClickedByTime(time);
    Logger.v("NotificationClickedTask : completed task");
    return null;
  }

  @Override public String getTaskTag() {
    return TAG_NOTIFICATION_CLICKED;
  }

  @Override public boolean isSynchronous() {
    return false;
  }
}
